# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RepositoryMetricSummary(object):
    """
    The metrics details of a repository resource.
    """

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "COMMITS"
    METRIC_NAME_COMMITS = "COMMITS"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "LINES_ADDED"
    METRIC_NAME_LINES_ADDED = "LINES_ADDED"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "LINES_DELETED"
    METRIC_NAME_LINES_DELETED = "LINES_DELETED"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "PULL_REQUEST_CREATED"
    METRIC_NAME_PULL_REQUEST_CREATED = "PULL_REQUEST_CREATED"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "PULL_REQUEST_MERGED"
    METRIC_NAME_PULL_REQUEST_MERGED = "PULL_REQUEST_MERGED"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "PULL_REQUEST_DECLINED"
    METRIC_NAME_PULL_REQUEST_DECLINED = "PULL_REQUEST_DECLINED"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "PULL_REQUEST_REVIEW_START_DURATION_IN_DAYS"
    METRIC_NAME_PULL_REQUEST_REVIEW_START_DURATION_IN_DAYS = "PULL_REQUEST_REVIEW_START_DURATION_IN_DAYS"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "PULL_REQUEST_REVIEW_DURATION_IN_DAYS"
    METRIC_NAME_PULL_REQUEST_REVIEW_DURATION_IN_DAYS = "PULL_REQUEST_REVIEW_DURATION_IN_DAYS"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "PULL_REQUEST_APPROVED"
    METRIC_NAME_PULL_REQUEST_APPROVED = "PULL_REQUEST_APPROVED"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "PULL_REQUEST_REVIEWED"
    METRIC_NAME_PULL_REQUEST_REVIEWED = "PULL_REQUEST_REVIEWED"

    #: A constant which can be used with the metric_name property of a RepositoryMetricSummary.
    #: This constant has a value of "PULL_REQUEST_COMMENTS"
    METRIC_NAME_PULL_REQUEST_COMMENTS = "PULL_REQUEST_COMMENTS"

    def __init__(self, **kwargs):
        """
        Initializes a new RepositoryMetricSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this RepositoryMetricSummary.
            Allowed values for this property are: "COMMITS", "LINES_ADDED", "LINES_DELETED", "PULL_REQUEST_CREATED", "PULL_REQUEST_MERGED", "PULL_REQUEST_DECLINED", "PULL_REQUEST_REVIEW_START_DURATION_IN_DAYS", "PULL_REQUEST_REVIEW_DURATION_IN_DAYS", "PULL_REQUEST_APPROVED", "PULL_REQUEST_REVIEWED", "PULL_REQUEST_COMMENTS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type metric_name: str

        :param duration_in_seconds:
            The value to assign to the duration_in_seconds property of this RepositoryMetricSummary.
        :type duration_in_seconds: int

        :param dimensions:
            The value to assign to the dimensions property of this RepositoryMetricSummary.
        :type dimensions: dict(str, str)

        :param start_timestamp_in_epoch_seconds:
            The value to assign to the start_timestamp_in_epoch_seconds property of this RepositoryMetricSummary.
        :type start_timestamp_in_epoch_seconds: int

        :param count:
            The value to assign to the count property of this RepositoryMetricSummary.
        :type count: float

        :param sum:
            The value to assign to the sum property of this RepositoryMetricSummary.
        :type sum: float

        """
        self.swagger_types = {
            'metric_name': 'str',
            'duration_in_seconds': 'int',
            'dimensions': 'dict(str, str)',
            'start_timestamp_in_epoch_seconds': 'int',
            'count': 'float',
            'sum': 'float'
        }
        self.attribute_map = {
            'metric_name': 'metricName',
            'duration_in_seconds': 'durationInSeconds',
            'dimensions': 'dimensions',
            'start_timestamp_in_epoch_seconds': 'startTimestampInEpochSeconds',
            'count': 'count',
            'sum': 'sum'
        }
        self._metric_name = None
        self._duration_in_seconds = None
        self._dimensions = None
        self._start_timestamp_in_epoch_seconds = None
        self._count = None
        self._sum = None

    @property
    def metric_name(self):
        """
        Gets the metric_name of this RepositoryMetricSummary.
        Type of metric

        Allowed values for this property are: "COMMITS", "LINES_ADDED", "LINES_DELETED", "PULL_REQUEST_CREATED", "PULL_REQUEST_MERGED", "PULL_REQUEST_DECLINED", "PULL_REQUEST_REVIEW_START_DURATION_IN_DAYS", "PULL_REQUEST_REVIEW_DURATION_IN_DAYS", "PULL_REQUEST_APPROVED", "PULL_REQUEST_REVIEWED", "PULL_REQUEST_COMMENTS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The metric_name of this RepositoryMetricSummary.
        :rtype: str
        """
        return self._metric_name

    @metric_name.setter
    def metric_name(self, metric_name):
        """
        Sets the metric_name of this RepositoryMetricSummary.
        Type of metric


        :param metric_name: The metric_name of this RepositoryMetricSummary.
        :type: str
        """
        allowed_values = ["COMMITS", "LINES_ADDED", "LINES_DELETED", "PULL_REQUEST_CREATED", "PULL_REQUEST_MERGED", "PULL_REQUEST_DECLINED", "PULL_REQUEST_REVIEW_START_DURATION_IN_DAYS", "PULL_REQUEST_REVIEW_DURATION_IN_DAYS", "PULL_REQUEST_APPROVED", "PULL_REQUEST_REVIEWED", "PULL_REQUEST_COMMENTS"]
        if not value_allowed_none_or_none_sentinel(metric_name, allowed_values):
            metric_name = 'UNKNOWN_ENUM_VALUE'
        self._metric_name = metric_name

    @property
    def duration_in_seconds(self):
        """
        Gets the duration_in_seconds of this RepositoryMetricSummary.
        The duration of the returned aggregated data in seconds.


        :return: The duration_in_seconds of this RepositoryMetricSummary.
        :rtype: int
        """
        return self._duration_in_seconds

    @duration_in_seconds.setter
    def duration_in_seconds(self, duration_in_seconds):
        """
        Sets the duration_in_seconds of this RepositoryMetricSummary.
        The duration of the returned aggregated data in seconds.


        :param duration_in_seconds: The duration_in_seconds of this RepositoryMetricSummary.
        :type: int
        """
        self._duration_in_seconds = duration_in_seconds

    @property
    def dimensions(self):
        """
        Gets the dimensions of this RepositoryMetricSummary.
        The qualifiers provided in the definition of the returned metric.


        :return: The dimensions of this RepositoryMetricSummary.
        :rtype: dict(str, str)
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this RepositoryMetricSummary.
        The qualifiers provided in the definition of the returned metric.


        :param dimensions: The dimensions of this RepositoryMetricSummary.
        :type: dict(str, str)
        """
        self._dimensions = dimensions

    @property
    def start_timestamp_in_epoch_seconds(self):
        """
        Gets the start_timestamp_in_epoch_seconds of this RepositoryMetricSummary.
        The start time associated with the value of the metric.


        :return: The start_timestamp_in_epoch_seconds of this RepositoryMetricSummary.
        :rtype: int
        """
        return self._start_timestamp_in_epoch_seconds

    @start_timestamp_in_epoch_seconds.setter
    def start_timestamp_in_epoch_seconds(self, start_timestamp_in_epoch_seconds):
        """
        Sets the start_timestamp_in_epoch_seconds of this RepositoryMetricSummary.
        The start time associated with the value of the metric.


        :param start_timestamp_in_epoch_seconds: The start_timestamp_in_epoch_seconds of this RepositoryMetricSummary.
        :type: int
        """
        self._start_timestamp_in_epoch_seconds = start_timestamp_in_epoch_seconds

    @property
    def count(self):
        """
        Gets the count of this RepositoryMetricSummary.
        Represents the total number of the metric being calculated.


        :return: The count of this RepositoryMetricSummary.
        :rtype: float
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this RepositoryMetricSummary.
        Represents the total number of the metric being calculated.


        :param count: The count of this RepositoryMetricSummary.
        :type: float
        """
        self._count = count

    @property
    def sum(self):
        """
        Gets the sum of this RepositoryMetricSummary.
        Represents the total duration in days calculated corresponding to the total no. of PRs.
        This is used only for \"PULL_REQUEST_REVIEW_START_DURATION_IN_DAYS\" and \"PULL_REQUEST_REVIEW_DURATION_IN_DAYS\" metrics.


        :return: The sum of this RepositoryMetricSummary.
        :rtype: float
        """
        return self._sum

    @sum.setter
    def sum(self, sum):
        """
        Sets the sum of this RepositoryMetricSummary.
        Represents the total duration in days calculated corresponding to the total no. of PRs.
        This is used only for \"PULL_REQUEST_REVIEW_START_DURATION_IN_DAYS\" and \"PULL_REQUEST_REVIEW_DURATION_IN_DAYS\" metrics.


        :param sum: The sum of this RepositoryMetricSummary.
        :type: float
        """
        self._sum = sum

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
