# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdbDetail(object):
    """
    Details to create an Oracle Autonomous Database.
    """

    #: A constant which can be used with the db_workload property of a AdbDetail.
    #: This constant has a value of "OLTP"
    DB_WORKLOAD_OLTP = "OLTP"

    #: A constant which can be used with the db_workload property of a AdbDetail.
    #: This constant has a value of "DW"
    DB_WORKLOAD_DW = "DW"

    def __init__(self, **kwargs):
        """
        Initializes a new AdbDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this AdbDetail.
        :type instance_id: str

        :param db_workload:
            The value to assign to the db_workload property of this AdbDetail.
            Allowed values for this property are: "OLTP", "DW", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type db_workload: str

        :param ecpu:
            The value to assign to the ecpu property of this AdbDetail.
        :type ecpu: int

        :param data_storage_size_in_tbs:
            The value to assign to the data_storage_size_in_tbs property of this AdbDetail.
        :type data_storage_size_in_tbs: int

        :param admin_password_id:
            The value to assign to the admin_password_id property of this AdbDetail.
        :type admin_password_id: str

        :param is_mtls_connection_required:
            The value to assign to the is_mtls_connection_required property of this AdbDetail.
        :type is_mtls_connection_required: bool

        :param subnet_id:
            The value to assign to the subnet_id property of this AdbDetail.
        :type subnet_id: str

        :param db_version:
            The value to assign to the db_version property of this AdbDetail.
        :type db_version: str

        :param tools_public_access:
            The value to assign to the tools_public_access property of this AdbDetail.
        :type tools_public_access: str

        :param is_public:
            The value to assign to the is_public property of this AdbDetail.
        :type is_public: bool

        """
        self.swagger_types = {
            'instance_id': 'str',
            'db_workload': 'str',
            'ecpu': 'int',
            'data_storage_size_in_tbs': 'int',
            'admin_password_id': 'str',
            'is_mtls_connection_required': 'bool',
            'subnet_id': 'str',
            'db_version': 'str',
            'tools_public_access': 'str',
            'is_public': 'bool'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'db_workload': 'dbWorkload',
            'ecpu': 'ecpu',
            'data_storage_size_in_tbs': 'dataStorageSizeInTBs',
            'admin_password_id': 'adminPasswordId',
            'is_mtls_connection_required': 'isMtlsConnectionRequired',
            'subnet_id': 'subnetId',
            'db_version': 'dbVersion',
            'tools_public_access': 'toolsPublicAccess',
            'is_public': 'isPublic'
        }
        self._instance_id = None
        self._db_workload = None
        self._ecpu = None
        self._data_storage_size_in_tbs = None
        self._admin_password_id = None
        self._is_mtls_connection_required = None
        self._subnet_id = None
        self._db_version = None
        self._tools_public_access = None
        self._is_public = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this AdbDetail.
        Id for the adw instance.


        :return: The instance_id of this AdbDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this AdbDetail.
        Id for the adw instance.


        :param instance_id: The instance_id of this AdbDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def db_workload(self):
        """
        **[Required]** Gets the db_workload of this AdbDetail.
        DB Workload to be used with ADB. Accepted values are OLTP, DW.

        Allowed values for this property are: "OLTP", "DW", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The db_workload of this AdbDetail.
        :rtype: str
        """
        return self._db_workload

    @db_workload.setter
    def db_workload(self, db_workload):
        """
        Sets the db_workload of this AdbDetail.
        DB Workload to be used with ADB. Accepted values are OLTP, DW.


        :param db_workload: The db_workload of this AdbDetail.
        :type: str
        """
        allowed_values = ["OLTP", "DW"]
        if not value_allowed_none_or_none_sentinel(db_workload, allowed_values):
            db_workload = 'UNKNOWN_ENUM_VALUE'
        self._db_workload = db_workload

    @property
    def ecpu(self):
        """
        **[Required]** Gets the ecpu of this AdbDetail.
        The compute amount (ECPUs) available to the database.


        :return: The ecpu of this AdbDetail.
        :rtype: int
        """
        return self._ecpu

    @ecpu.setter
    def ecpu(self, ecpu):
        """
        Sets the ecpu of this AdbDetail.
        The compute amount (ECPUs) available to the database.


        :param ecpu: The ecpu of this AdbDetail.
        :type: int
        """
        self._ecpu = ecpu

    @property
    def data_storage_size_in_tbs(self):
        """
        **[Required]** Gets the data_storage_size_in_tbs of this AdbDetail.
        The size, in terabytes, of the data volume that will be created and attached to the database.


        :return: The data_storage_size_in_tbs of this AdbDetail.
        :rtype: int
        """
        return self._data_storage_size_in_tbs

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, data_storage_size_in_tbs):
        """
        Sets the data_storage_size_in_tbs of this AdbDetail.
        The size, in terabytes, of the data volume that will be created and attached to the database.


        :param data_storage_size_in_tbs: The data_storage_size_in_tbs of this AdbDetail.
        :type: int
        """
        self._data_storage_size_in_tbs = data_storage_size_in_tbs

    @property
    def admin_password_id(self):
        """
        **[Required]** Gets the admin_password_id of this AdbDetail.
        The OCI vault secret [/Content/General/Concepts/identifiers.htm]OCID for admin password.


        :return: The admin_password_id of this AdbDetail.
        :rtype: str
        """
        return self._admin_password_id

    @admin_password_id.setter
    def admin_password_id(self, admin_password_id):
        """
        Sets the admin_password_id of this AdbDetail.
        The OCI vault secret [/Content/General/Concepts/identifiers.htm]OCID for admin password.


        :param admin_password_id: The admin_password_id of this AdbDetail.
        :type: str
        """
        self._admin_password_id = admin_password_id

    @property
    def is_mtls_connection_required(self):
        """
        Gets the is_mtls_connection_required of this AdbDetail.
        Specifies if the Autonomous Database requires mTLS connections.


        :return: The is_mtls_connection_required of this AdbDetail.
        :rtype: bool
        """
        return self._is_mtls_connection_required

    @is_mtls_connection_required.setter
    def is_mtls_connection_required(self, is_mtls_connection_required):
        """
        Sets the is_mtls_connection_required of this AdbDetail.
        Specifies if the Autonomous Database requires mTLS connections.


        :param is_mtls_connection_required: The is_mtls_connection_required of this AdbDetail.
        :type: bool
        """
        self._is_mtls_connection_required = is_mtls_connection_required

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this AdbDetail.
        The OCID of the subnet the Autonomous Database is associated with.


        :return: The subnet_id of this AdbDetail.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this AdbDetail.
        The OCID of the subnet the Autonomous Database is associated with.


        :param subnet_id: The subnet_id of this AdbDetail.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def db_version(self):
        """
        **[Required]** Gets the db_version of this AdbDetail.
        A valid Oracle Database version for Autonomous Database.


        :return: The db_version of this AdbDetail.
        :rtype: str
        """
        return self._db_version

    @db_version.setter
    def db_version(self, db_version):
        """
        Sets the db_version of this AdbDetail.
        A valid Oracle Database version for Autonomous Database.


        :param db_version: The db_version of this AdbDetail.
        :type: str
        """
        self._db_version = db_version

    @property
    def tools_public_access(self):
        """
        Gets the tools_public_access of this AdbDetail.
        This is an array of CIDR (classless inter-domain routing) notations for a subnet or VCN OCID (virtual cloud network Oracle Cloud ID). Allowed only when subnetId is provided (private ADB).


        :return: The tools_public_access of this AdbDetail.
        :rtype: str
        """
        return self._tools_public_access

    @tools_public_access.setter
    def tools_public_access(self, tools_public_access):
        """
        Sets the tools_public_access of this AdbDetail.
        This is an array of CIDR (classless inter-domain routing) notations for a subnet or VCN OCID (virtual cloud network Oracle Cloud ID). Allowed only when subnetId is provided (private ADB).


        :param tools_public_access: The tools_public_access of this AdbDetail.
        :type: str
        """
        self._tools_public_access = tools_public_access

    @property
    def is_public(self):
        """
        Gets the is_public of this AdbDetail.
        If true then subnetId should not be provided.


        :return: The is_public of this AdbDetail.
        :rtype: bool
        """
        return self._is_public

    @is_public.setter
    def is_public(self, is_public):
        """
        Sets the is_public of this AdbDetail.
        If true then subnetId should not be provided.


        :param is_public: The is_public of this AdbDetail.
        :type: bool
        """
        self._is_public = is_public

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
