# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrPlanExecutionStepStatusCounts(object):
    """
    A categorized summary of step execution statuses and their corresponding counts.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DrPlanExecutionStepStatusCounts object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_steps:
            The value to assign to the total_steps property of this DrPlanExecutionStepStatusCounts.
        :type total_steps: int

        :param remaining_steps:
            The value to assign to the remaining_steps property of this DrPlanExecutionStepStatusCounts.
        :type remaining_steps: oci.disaster_recovery.models.DrPlanExecutionRemainingStepStatusCounts

        :param skipped_steps:
            The value to assign to the skipped_steps property of this DrPlanExecutionStepStatusCounts.
        :type skipped_steps: oci.disaster_recovery.models.DrPlanExecutionSkippedStepStatusCounts

        :param successful_steps:
            The value to assign to the successful_steps property of this DrPlanExecutionStepStatusCounts.
        :type successful_steps: oci.disaster_recovery.models.DrPlanExecutionSuccessfulStepStatusCounts

        :param warning_steps:
            The value to assign to the warning_steps property of this DrPlanExecutionStepStatusCounts.
        :type warning_steps: oci.disaster_recovery.models.DrPlanExecutionWarningStepStatusCounts

        :param failed_steps:
            The value to assign to the failed_steps property of this DrPlanExecutionStepStatusCounts.
        :type failed_steps: oci.disaster_recovery.models.DrPlanExecutionFailedStepStatusCounts

        """
        self.swagger_types = {
            'total_steps': 'int',
            'remaining_steps': 'DrPlanExecutionRemainingStepStatusCounts',
            'skipped_steps': 'DrPlanExecutionSkippedStepStatusCounts',
            'successful_steps': 'DrPlanExecutionSuccessfulStepStatusCounts',
            'warning_steps': 'DrPlanExecutionWarningStepStatusCounts',
            'failed_steps': 'DrPlanExecutionFailedStepStatusCounts'
        }
        self.attribute_map = {
            'total_steps': 'totalSteps',
            'remaining_steps': 'remainingSteps',
            'skipped_steps': 'skippedSteps',
            'successful_steps': 'successfulSteps',
            'warning_steps': 'warningSteps',
            'failed_steps': 'failedSteps'
        }
        self._total_steps = None
        self._remaining_steps = None
        self._skipped_steps = None
        self._successful_steps = None
        self._warning_steps = None
        self._failed_steps = None

    @property
    def total_steps(self):
        """
        **[Required]** Gets the total_steps of this DrPlanExecutionStepStatusCounts.
        The total number of steps in a DR plan execution.


        :return: The total_steps of this DrPlanExecutionStepStatusCounts.
        :rtype: int
        """
        return self._total_steps

    @total_steps.setter
    def total_steps(self, total_steps):
        """
        Sets the total_steps of this DrPlanExecutionStepStatusCounts.
        The total number of steps in a DR plan execution.


        :param total_steps: The total_steps of this DrPlanExecutionStepStatusCounts.
        :type: int
        """
        self._total_steps = total_steps

    @property
    def remaining_steps(self):
        """
        **[Required]** Gets the remaining_steps of this DrPlanExecutionStepStatusCounts.

        :return: The remaining_steps of this DrPlanExecutionStepStatusCounts.
        :rtype: oci.disaster_recovery.models.DrPlanExecutionRemainingStepStatusCounts
        """
        return self._remaining_steps

    @remaining_steps.setter
    def remaining_steps(self, remaining_steps):
        """
        Sets the remaining_steps of this DrPlanExecutionStepStatusCounts.

        :param remaining_steps: The remaining_steps of this DrPlanExecutionStepStatusCounts.
        :type: oci.disaster_recovery.models.DrPlanExecutionRemainingStepStatusCounts
        """
        self._remaining_steps = remaining_steps

    @property
    def skipped_steps(self):
        """
        **[Required]** Gets the skipped_steps of this DrPlanExecutionStepStatusCounts.

        :return: The skipped_steps of this DrPlanExecutionStepStatusCounts.
        :rtype: oci.disaster_recovery.models.DrPlanExecutionSkippedStepStatusCounts
        """
        return self._skipped_steps

    @skipped_steps.setter
    def skipped_steps(self, skipped_steps):
        """
        Sets the skipped_steps of this DrPlanExecutionStepStatusCounts.

        :param skipped_steps: The skipped_steps of this DrPlanExecutionStepStatusCounts.
        :type: oci.disaster_recovery.models.DrPlanExecutionSkippedStepStatusCounts
        """
        self._skipped_steps = skipped_steps

    @property
    def successful_steps(self):
        """
        **[Required]** Gets the successful_steps of this DrPlanExecutionStepStatusCounts.

        :return: The successful_steps of this DrPlanExecutionStepStatusCounts.
        :rtype: oci.disaster_recovery.models.DrPlanExecutionSuccessfulStepStatusCounts
        """
        return self._successful_steps

    @successful_steps.setter
    def successful_steps(self, successful_steps):
        """
        Sets the successful_steps of this DrPlanExecutionStepStatusCounts.

        :param successful_steps: The successful_steps of this DrPlanExecutionStepStatusCounts.
        :type: oci.disaster_recovery.models.DrPlanExecutionSuccessfulStepStatusCounts
        """
        self._successful_steps = successful_steps

    @property
    def warning_steps(self):
        """
        **[Required]** Gets the warning_steps of this DrPlanExecutionStepStatusCounts.

        :return: The warning_steps of this DrPlanExecutionStepStatusCounts.
        :rtype: oci.disaster_recovery.models.DrPlanExecutionWarningStepStatusCounts
        """
        return self._warning_steps

    @warning_steps.setter
    def warning_steps(self, warning_steps):
        """
        Sets the warning_steps of this DrPlanExecutionStepStatusCounts.

        :param warning_steps: The warning_steps of this DrPlanExecutionStepStatusCounts.
        :type: oci.disaster_recovery.models.DrPlanExecutionWarningStepStatusCounts
        """
        self._warning_steps = warning_steps

    @property
    def failed_steps(self):
        """
        **[Required]** Gets the failed_steps of this DrPlanExecutionStepStatusCounts.

        :return: The failed_steps of this DrPlanExecutionStepStatusCounts.
        :rtype: oci.disaster_recovery.models.DrPlanExecutionFailedStepStatusCounts
        """
        return self._failed_steps

    @failed_steps.setter
    def failed_steps(self, failed_steps):
        """
        Sets the failed_steps of this DrPlanExecutionStepStatusCounts.

        :param failed_steps: The failed_steps of this DrPlanExecutionStepStatusCounts.
        :type: oci.disaster_recovery.models.DrPlanExecutionFailedStepStatusCounts
        """
        self._failed_steps = failed_steps

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
