# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrPlanExecutionSuccessfulStepStatusCounts(object):
    """
    A summary of steps that completed successfully during a DR plan execution.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DrPlanExecutionSuccessfulStepStatusCounts object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_successful:
            The value to assign to the total_successful property of this DrPlanExecutionSuccessfulStepStatusCounts.
        :type total_successful: int

        :param succeeded:
            The value to assign to the succeeded property of this DrPlanExecutionSuccessfulStepStatusCounts.
        :type succeeded: int

        """
        self.swagger_types = {
            'total_successful': 'int',
            'succeeded': 'int'
        }
        self.attribute_map = {
            'total_successful': 'totalSuccessful',
            'succeeded': 'succeeded'
        }
        self._total_successful = None
        self._succeeded = None

    @property
    def total_successful(self):
        """
        **[Required]** Gets the total_successful of this DrPlanExecutionSuccessfulStepStatusCounts.
        The total number of successful steps in a DR plan execution.


        :return: The total_successful of this DrPlanExecutionSuccessfulStepStatusCounts.
        :rtype: int
        """
        return self._total_successful

    @total_successful.setter
    def total_successful(self, total_successful):
        """
        Sets the total_successful of this DrPlanExecutionSuccessfulStepStatusCounts.
        The total number of successful steps in a DR plan execution.


        :param total_successful: The total_successful of this DrPlanExecutionSuccessfulStepStatusCounts.
        :type: int
        """
        self._total_successful = total_successful

    @property
    def succeeded(self):
        """
        **[Required]** Gets the succeeded of this DrPlanExecutionSuccessfulStepStatusCounts.
        The total number of steps that succeeded during a DR plan execution.


        :return: The succeeded of this DrPlanExecutionSuccessfulStepStatusCounts.
        :rtype: int
        """
        return self._succeeded

    @succeeded.setter
    def succeeded(self, succeeded):
        """
        Sets the succeeded of this DrPlanExecutionSuccessfulStepStatusCounts.
        The total number of steps that succeeded during a DR plan execution.


        :param succeeded: The succeeded of this DrPlanExecutionSuccessfulStepStatusCounts.
        :type: int
        """
        self._succeeded = succeeded

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
