# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .update_dr_protection_group_member_details import UpdateDrProtectionGroupMemberDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDrProtectionGroupMemberMySqlDbSystemDetails(UpdateDrProtectionGroupMemberDetails):
    """
    Update properties for a HeatWave MySQL Db System member.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDrProtectionGroupMemberMySqlDbSystemDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.disaster_recovery.models.UpdateDrProtectionGroupMemberMySqlDbSystemDetails.member_type` attribute
        of this class is ``MYSQL_DB_SYSTEM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_id:
            The value to assign to the member_id property of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type member_id: str

        :param member_type:
            The value to assign to the member_type property of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
            Allowed values for this property are: "COMPUTE_INSTANCE", "COMPUTE_INSTANCE_MOVABLE", "COMPUTE_INSTANCE_NON_MOVABLE", "VOLUME_GROUP", "DATABASE", "AUTONOMOUS_DATABASE", "AUTONOMOUS_CONTAINER_DATABASE", "LOAD_BALANCER", "NETWORK_LOAD_BALANCER", "FILE_SYSTEM", "OKE_CLUSTER", "OBJECT_STORAGE_BUCKET", "MYSQL_DB_SYSTEM", "INTEGRATION_INSTANCE"
        :type member_type: str

        :param peer_db_system_id:
            The value to assign to the peer_db_system_id property of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type peer_db_system_id: str

        :param gtid_reconciliation_timeout:
            The value to assign to the gtid_reconciliation_timeout property of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type gtid_reconciliation_timeout: int

        :param is_continue_on_gtid_reconciliation_timeout:
            The value to assign to the is_continue_on_gtid_reconciliation_timeout property of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type is_continue_on_gtid_reconciliation_timeout: bool

        :param db_system_admin_user_details:
            The value to assign to the db_system_admin_user_details property of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type db_system_admin_user_details: oci.disaster_recovery.models.UpdateMySqlDbSystemAdminUserDetails

        :param db_system_replication_user_details:
            The value to assign to the db_system_replication_user_details property of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type db_system_replication_user_details: oci.disaster_recovery.models.UpdateMySqlDbSystemReplicationUserDetails

        """
        self.swagger_types = {
            'member_id': 'str',
            'member_type': 'str',
            'peer_db_system_id': 'str',
            'gtid_reconciliation_timeout': 'int',
            'is_continue_on_gtid_reconciliation_timeout': 'bool',
            'db_system_admin_user_details': 'UpdateMySqlDbSystemAdminUserDetails',
            'db_system_replication_user_details': 'UpdateMySqlDbSystemReplicationUserDetails'
        }
        self.attribute_map = {
            'member_id': 'memberId',
            'member_type': 'memberType',
            'peer_db_system_id': 'peerDbSystemId',
            'gtid_reconciliation_timeout': 'gtidReconciliationTimeout',
            'is_continue_on_gtid_reconciliation_timeout': 'isContinueOnGtidReconciliationTimeout',
            'db_system_admin_user_details': 'dbSystemAdminUserDetails',
            'db_system_replication_user_details': 'dbSystemReplicationUserDetails'
        }
        self._member_id = None
        self._member_type = None
        self._peer_db_system_id = None
        self._gtid_reconciliation_timeout = None
        self._is_continue_on_gtid_reconciliation_timeout = None
        self._db_system_admin_user_details = None
        self._db_system_replication_user_details = None
        self._member_type = 'MYSQL_DB_SYSTEM'

    @property
    def peer_db_system_id(self):
        """
        Gets the peer_db_system_id of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        The OCID of the peer HeatWave MySQL DB System from the peer region.

        Example: `ocid1.mysqldbsystem.oc1..uniqueID`


        :return: The peer_db_system_id of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :rtype: str
        """
        return self._peer_db_system_id

    @peer_db_system_id.setter
    def peer_db_system_id(self, peer_db_system_id):
        """
        Sets the peer_db_system_id of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        The OCID of the peer HeatWave MySQL DB System from the peer region.

        Example: `ocid1.mysqldbsystem.oc1..uniqueID`


        :param peer_db_system_id: The peer_db_system_id of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type: str
        """
        self._peer_db_system_id = peer_db_system_id

    @property
    def gtid_reconciliation_timeout(self):
        """
        Gets the gtid_reconciliation_timeout of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        The maximum time (in seconds) to wait for the Global Transaction Identifier (GTID) synchronization process to complete before timing out.

        Example: `600`


        :return: The gtid_reconciliation_timeout of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :rtype: int
        """
        return self._gtid_reconciliation_timeout

    @gtid_reconciliation_timeout.setter
    def gtid_reconciliation_timeout(self, gtid_reconciliation_timeout):
        """
        Sets the gtid_reconciliation_timeout of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        The maximum time (in seconds) to wait for the Global Transaction Identifier (GTID) synchronization process to complete before timing out.

        Example: `600`


        :param gtid_reconciliation_timeout: The gtid_reconciliation_timeout of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type: int
        """
        self._gtid_reconciliation_timeout = gtid_reconciliation_timeout

    @property
    def is_continue_on_gtid_reconciliation_timeout(self):
        """
        Gets the is_continue_on_gtid_reconciliation_timeout of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        A flag indicating whether to continue with DR operation if the Global Transaction Identifier (GTID) reconciliation operation times out.

        Example: `false`


        :return: The is_continue_on_gtid_reconciliation_timeout of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :rtype: bool
        """
        return self._is_continue_on_gtid_reconciliation_timeout

    @is_continue_on_gtid_reconciliation_timeout.setter
    def is_continue_on_gtid_reconciliation_timeout(self, is_continue_on_gtid_reconciliation_timeout):
        """
        Sets the is_continue_on_gtid_reconciliation_timeout of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        A flag indicating whether to continue with DR operation if the Global Transaction Identifier (GTID) reconciliation operation times out.

        Example: `false`


        :param is_continue_on_gtid_reconciliation_timeout: The is_continue_on_gtid_reconciliation_timeout of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type: bool
        """
        self._is_continue_on_gtid_reconciliation_timeout = is_continue_on_gtid_reconciliation_timeout

    @property
    def db_system_admin_user_details(self):
        """
        Gets the db_system_admin_user_details of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.

        :return: The db_system_admin_user_details of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :rtype: oci.disaster_recovery.models.UpdateMySqlDbSystemAdminUserDetails
        """
        return self._db_system_admin_user_details

    @db_system_admin_user_details.setter
    def db_system_admin_user_details(self, db_system_admin_user_details):
        """
        Sets the db_system_admin_user_details of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.

        :param db_system_admin_user_details: The db_system_admin_user_details of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type: oci.disaster_recovery.models.UpdateMySqlDbSystemAdminUserDetails
        """
        self._db_system_admin_user_details = db_system_admin_user_details

    @property
    def db_system_replication_user_details(self):
        """
        Gets the db_system_replication_user_details of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.

        :return: The db_system_replication_user_details of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :rtype: oci.disaster_recovery.models.UpdateMySqlDbSystemReplicationUserDetails
        """
        return self._db_system_replication_user_details

    @db_system_replication_user_details.setter
    def db_system_replication_user_details(self, db_system_replication_user_details):
        """
        Sets the db_system_replication_user_details of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.

        :param db_system_replication_user_details: The db_system_replication_user_details of this UpdateDrProtectionGroupMemberMySqlDbSystemDetails.
        :type: oci.disaster_recovery.models.UpdateMySqlDbSystemReplicationUserDetails
        """
        self._db_system_replication_user_details = db_system_replication_user_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
