# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ShardPeerWithDedicatedInfra(object):
    """
    Details of the shard peer
    """

    #: A constant which can be used with the status property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "DELETING"
    STATUS_DELETING = "DELETING"

    #: A constant which can be used with the status property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "DELETED"
    STATUS_DELETED = "DELETED"

    #: A constant which can be used with the status property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "UPDATING"
    STATUS_UPDATING = "UPDATING"

    #: A constant which can be used with the status property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "CREATING"
    STATUS_CREATING = "CREATING"

    #: A constant which can be used with the status property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "CREATED"
    STATUS_CREATED = "CREATED"

    #: A constant which can be used with the status property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "READY_FOR_CONFIGURATION"
    STATUS_READY_FOR_CONFIGURATION = "READY_FOR_CONFIGURATION"

    #: A constant which can be used with the status property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "CONFIGURED"
    STATUS_CONFIGURED = "CONFIGURED"

    #: A constant which can be used with the status property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "NEEDS_ATTENTION"
    STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the protection_mode property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "MAXIMUM_AVAILABILITY"
    PROTECTION_MODE_MAXIMUM_AVAILABILITY = "MAXIMUM_AVAILABILITY"

    #: A constant which can be used with the protection_mode property of a ShardPeerWithDedicatedInfra.
    #: This constant has a value of "MAXIMUM_PERFORMANCE"
    PROTECTION_MODE_MAXIMUM_PERFORMANCE = "MAXIMUM_PERFORMANCE"

    def __init__(self, **kwargs):
        """
        Initializes a new ShardPeerWithDedicatedInfra object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cloud_autonomous_vm_cluster_id:
            The value to assign to the cloud_autonomous_vm_cluster_id property of this ShardPeerWithDedicatedInfra.
        :type cloud_autonomous_vm_cluster_id: str

        :param shard_group:
            The value to assign to the shard_group property of this ShardPeerWithDedicatedInfra.
        :type shard_group: str

        :param status:
            The value to assign to the status property of this ShardPeerWithDedicatedInfra.
            Allowed values for this property are: "FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param supporting_resource_id:
            The value to assign to the supporting_resource_id property of this ShardPeerWithDedicatedInfra.
        :type supporting_resource_id: str

        :param container_database_id:
            The value to assign to the container_database_id property of this ShardPeerWithDedicatedInfra.
        :type container_database_id: str

        :param time_created:
            The value to assign to the time_created property of this ShardPeerWithDedicatedInfra.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ShardPeerWithDedicatedInfra.
        :type time_updated: datetime

        :param protection_mode:
            The value to assign to the protection_mode property of this ShardPeerWithDedicatedInfra.
            Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type protection_mode: str

        :param fast_start_fail_over_lag_limit_in_seconds:
            The value to assign to the fast_start_fail_over_lag_limit_in_seconds property of this ShardPeerWithDedicatedInfra.
        :type fast_start_fail_over_lag_limit_in_seconds: int

        :param is_automatic_failover_enabled:
            The value to assign to the is_automatic_failover_enabled property of this ShardPeerWithDedicatedInfra.
        :type is_automatic_failover_enabled: bool

        :param standby_maintenance_buffer_in_days:
            The value to assign to the standby_maintenance_buffer_in_days property of this ShardPeerWithDedicatedInfra.
        :type standby_maintenance_buffer_in_days: int

        :param metadata:
            The value to assign to the metadata property of this ShardPeerWithDedicatedInfra.
        :type metadata: oci.distributed_database.models.DistributedAutonomousDbMetadata

        """
        self.swagger_types = {
            'cloud_autonomous_vm_cluster_id': 'str',
            'shard_group': 'str',
            'status': 'str',
            'supporting_resource_id': 'str',
            'container_database_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'protection_mode': 'str',
            'fast_start_fail_over_lag_limit_in_seconds': 'int',
            'is_automatic_failover_enabled': 'bool',
            'standby_maintenance_buffer_in_days': 'int',
            'metadata': 'DistributedAutonomousDbMetadata'
        }
        self.attribute_map = {
            'cloud_autonomous_vm_cluster_id': 'cloudAutonomousVmClusterId',
            'shard_group': 'shardGroup',
            'status': 'status',
            'supporting_resource_id': 'supportingResourceId',
            'container_database_id': 'containerDatabaseId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'protection_mode': 'protectionMode',
            'fast_start_fail_over_lag_limit_in_seconds': 'fastStartFailOverLagLimitInSeconds',
            'is_automatic_failover_enabled': 'isAutomaticFailoverEnabled',
            'standby_maintenance_buffer_in_days': 'standbyMaintenanceBufferInDays',
            'metadata': 'metadata'
        }
        self._cloud_autonomous_vm_cluster_id = None
        self._shard_group = None
        self._status = None
        self._supporting_resource_id = None
        self._container_database_id = None
        self._time_created = None
        self._time_updated = None
        self._protection_mode = None
        self._fast_start_fail_over_lag_limit_in_seconds = None
        self._is_automatic_failover_enabled = None
        self._standby_maintenance_buffer_in_days = None
        self._metadata = None

    @property
    def cloud_autonomous_vm_cluster_id(self):
        """
        **[Required]** Gets the cloud_autonomous_vm_cluster_id of this ShardPeerWithDedicatedInfra.
        The `OCID`__ of the cloudAutonomousVmCluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cloud_autonomous_vm_cluster_id of this ShardPeerWithDedicatedInfra.
        :rtype: str
        """
        return self._cloud_autonomous_vm_cluster_id

    @cloud_autonomous_vm_cluster_id.setter
    def cloud_autonomous_vm_cluster_id(self, cloud_autonomous_vm_cluster_id):
        """
        Sets the cloud_autonomous_vm_cluster_id of this ShardPeerWithDedicatedInfra.
        The `OCID`__ of the cloudAutonomousVmCluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cloud_autonomous_vm_cluster_id: The cloud_autonomous_vm_cluster_id of this ShardPeerWithDedicatedInfra.
        :type: str
        """
        self._cloud_autonomous_vm_cluster_id = cloud_autonomous_vm_cluster_id

    @property
    def shard_group(self):
        """
        **[Required]** Gets the shard_group of this ShardPeerWithDedicatedInfra.
        The name of the shardGroup for the peer.


        :return: The shard_group of this ShardPeerWithDedicatedInfra.
        :rtype: str
        """
        return self._shard_group

    @shard_group.setter
    def shard_group(self, shard_group):
        """
        Sets the shard_group of this ShardPeerWithDedicatedInfra.
        The name of the shardGroup for the peer.


        :param shard_group: The shard_group of this ShardPeerWithDedicatedInfra.
        :type: str
        """
        self._shard_group = shard_group

    @property
    def status(self):
        """
        **[Required]** Gets the status of this ShardPeerWithDedicatedInfra.
        Status of shard with dedicated infrastructure for the Globally distributed autonomous database.

        Allowed values for this property are: "FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this ShardPeerWithDedicatedInfra.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ShardPeerWithDedicatedInfra.
        Status of shard with dedicated infrastructure for the Globally distributed autonomous database.


        :param status: The status of this ShardPeerWithDedicatedInfra.
        :type: str
        """
        allowed_values = ["FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def supporting_resource_id(self):
        """
        Gets the supporting_resource_id of this ShardPeerWithDedicatedInfra.
        the identifier of the underlying supporting resource.


        :return: The supporting_resource_id of this ShardPeerWithDedicatedInfra.
        :rtype: str
        """
        return self._supporting_resource_id

    @supporting_resource_id.setter
    def supporting_resource_id(self, supporting_resource_id):
        """
        Sets the supporting_resource_id of this ShardPeerWithDedicatedInfra.
        the identifier of the underlying supporting resource.


        :param supporting_resource_id: The supporting_resource_id of this ShardPeerWithDedicatedInfra.
        :type: str
        """
        self._supporting_resource_id = supporting_resource_id

    @property
    def container_database_id(self):
        """
        Gets the container_database_id of this ShardPeerWithDedicatedInfra.
        the identifier of the container database for underlying supporting resource.


        :return: The container_database_id of this ShardPeerWithDedicatedInfra.
        :rtype: str
        """
        return self._container_database_id

    @container_database_id.setter
    def container_database_id(self, container_database_id):
        """
        Sets the container_database_id of this ShardPeerWithDedicatedInfra.
        the identifier of the container database for underlying supporting resource.


        :param container_database_id: The container_database_id of this ShardPeerWithDedicatedInfra.
        :type: str
        """
        self._container_database_id = container_database_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ShardPeerWithDedicatedInfra.
        The time the shard peer was created. An RFC3339 formatted datetime string


        :return: The time_created of this ShardPeerWithDedicatedInfra.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ShardPeerWithDedicatedInfra.
        The time the shard peer was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this ShardPeerWithDedicatedInfra.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ShardPeerWithDedicatedInfra.
        The time the shard peer was last updated. An RFC3339 formatted datetime string


        :return: The time_updated of this ShardPeerWithDedicatedInfra.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ShardPeerWithDedicatedInfra.
        The time the shard peer was last updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this ShardPeerWithDedicatedInfra.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def protection_mode(self):
        """
        Gets the protection_mode of this ShardPeerWithDedicatedInfra.
        The protectionMode for the shard peer.

        Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The protection_mode of this ShardPeerWithDedicatedInfra.
        :rtype: str
        """
        return self._protection_mode

    @protection_mode.setter
    def protection_mode(self, protection_mode):
        """
        Sets the protection_mode of this ShardPeerWithDedicatedInfra.
        The protectionMode for the shard peer.


        :param protection_mode: The protection_mode of this ShardPeerWithDedicatedInfra.
        :type: str
        """
        allowed_values = ["MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE"]
        if not value_allowed_none_or_none_sentinel(protection_mode, allowed_values):
            protection_mode = 'UNKNOWN_ENUM_VALUE'
        self._protection_mode = protection_mode

    @property
    def fast_start_fail_over_lag_limit_in_seconds(self):
        """
        Gets the fast_start_fail_over_lag_limit_in_seconds of this ShardPeerWithDedicatedInfra.
        The lag time for my preference based on data loss tolerance in seconds.


        :return: The fast_start_fail_over_lag_limit_in_seconds of this ShardPeerWithDedicatedInfra.
        :rtype: int
        """
        return self._fast_start_fail_over_lag_limit_in_seconds

    @fast_start_fail_over_lag_limit_in_seconds.setter
    def fast_start_fail_over_lag_limit_in_seconds(self, fast_start_fail_over_lag_limit_in_seconds):
        """
        Sets the fast_start_fail_over_lag_limit_in_seconds of this ShardPeerWithDedicatedInfra.
        The lag time for my preference based on data loss tolerance in seconds.


        :param fast_start_fail_over_lag_limit_in_seconds: The fast_start_fail_over_lag_limit_in_seconds of this ShardPeerWithDedicatedInfra.
        :type: int
        """
        self._fast_start_fail_over_lag_limit_in_seconds = fast_start_fail_over_lag_limit_in_seconds

    @property
    def is_automatic_failover_enabled(self):
        """
        Gets the is_automatic_failover_enabled of this ShardPeerWithDedicatedInfra.
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association


        :return: The is_automatic_failover_enabled of this ShardPeerWithDedicatedInfra.
        :rtype: bool
        """
        return self._is_automatic_failover_enabled

    @is_automatic_failover_enabled.setter
    def is_automatic_failover_enabled(self, is_automatic_failover_enabled):
        """
        Sets the is_automatic_failover_enabled of this ShardPeerWithDedicatedInfra.
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association


        :param is_automatic_failover_enabled: The is_automatic_failover_enabled of this ShardPeerWithDedicatedInfra.
        :type: bool
        """
        self._is_automatic_failover_enabled = is_automatic_failover_enabled

    @property
    def standby_maintenance_buffer_in_days(self):
        """
        Gets the standby_maintenance_buffer_in_days of this ShardPeerWithDedicatedInfra.
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database.
        This value represents the number of days before schedlued maintenance of the primary database.


        :return: The standby_maintenance_buffer_in_days of this ShardPeerWithDedicatedInfra.
        :rtype: int
        """
        return self._standby_maintenance_buffer_in_days

    @standby_maintenance_buffer_in_days.setter
    def standby_maintenance_buffer_in_days(self, standby_maintenance_buffer_in_days):
        """
        Sets the standby_maintenance_buffer_in_days of this ShardPeerWithDedicatedInfra.
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database.
        This value represents the number of days before schedlued maintenance of the primary database.


        :param standby_maintenance_buffer_in_days: The standby_maintenance_buffer_in_days of this ShardPeerWithDedicatedInfra.
        :type: int
        """
        self._standby_maintenance_buffer_in_days = standby_maintenance_buffer_in_days

    @property
    def metadata(self):
        """
        Gets the metadata of this ShardPeerWithDedicatedInfra.

        :return: The metadata of this ShardPeerWithDedicatedInfra.
        :rtype: oci.distributed_database.models.DistributedAutonomousDbMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this ShardPeerWithDedicatedInfra.

        :param metadata: The metadata of this ShardPeerWithDedicatedInfra.
        :type: oci.distributed_database.models.DistributedAutonomousDbMetadata
        """
        self._metadata = metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
