# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20170907


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AddEmailOutboundIpDetails(object):
    """
    Outbound IP details to be assigned to the IpPool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AddEmailOutboundIpDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param outbound_ips:
            The value to assign to the outbound_ips property of this AddEmailOutboundIpDetails.
        :type outbound_ips: list[str]

        """
        self.swagger_types = {
            'outbound_ips': 'list[str]'
        }
        self.attribute_map = {
            'outbound_ips': 'outboundIps'
        }
        self._outbound_ips = None

    @property
    def outbound_ips(self):
        """
        **[Required]** Gets the outbound_ips of this AddEmailOutboundIpDetails.
        List of public IPs to ADD to the IpPool.
        Public IPs must be in the AVAILABLE state to be assigned to the IpPool.


        :return: The outbound_ips of this AddEmailOutboundIpDetails.
        :rtype: list[str]
        """
        return self._outbound_ips

    @outbound_ips.setter
    def outbound_ips(self, outbound_ips):
        """
        Sets the outbound_ips of this AddEmailOutboundIpDetails.
        List of public IPs to ADD to the IpPool.
        Public IPs must be in the AVAILABLE state to be assigned to the IpPool.


        :param outbound_ips: The outbound_ips of this AddEmailOutboundIpDetails.
        :type: list[str]
        """
        self._outbound_ips = outbound_ips

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
