# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .catalog_result_payload import CatalogResultPayload
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogGitResultConfig(CatalogResultPayload):
    """
    Catalog GIT result config.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogGitResultConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.CatalogGitResultConfig.config_result_type` attribute
        of this class is ``GIT_RESULT_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_result_type:
            The value to assign to the config_result_type property of this CatalogGitResultConfig.
            Allowed values for this property are: "PAR_RESULT_CONFIG", "TEMPLATE_RESULT_CONFIG", "GIT_RESULT_CONFIG"
        :type config_result_type: str

        :param working_directory:
            The value to assign to the working_directory property of this CatalogGitResultConfig.
        :type working_directory: str

        :param branch_name:
            The value to assign to the branch_name property of this CatalogGitResultConfig.
        :type branch_name: str

        :param configuration_source_provider_id:
            The value to assign to the configuration_source_provider_id property of this CatalogGitResultConfig.
        :type configuration_source_provider_id: str

        :param repository_url:
            The value to assign to the repository_url property of this CatalogGitResultConfig.
        :type repository_url: str

        """
        self.swagger_types = {
            'config_result_type': 'str',
            'working_directory': 'str',
            'branch_name': 'str',
            'configuration_source_provider_id': 'str',
            'repository_url': 'str'
        }
        self.attribute_map = {
            'config_result_type': 'configResultType',
            'working_directory': 'workingDirectory',
            'branch_name': 'branchName',
            'configuration_source_provider_id': 'configurationSourceProviderId',
            'repository_url': 'repositoryUrl'
        }
        self._config_result_type = None
        self._working_directory = None
        self._branch_name = None
        self._configuration_source_provider_id = None
        self._repository_url = None
        self._config_result_type = 'GIT_RESULT_CONFIG'

    @property
    def branch_name(self):
        """
        Gets the branch_name of this CatalogGitResultConfig.
        branch Name


        :return: The branch_name of this CatalogGitResultConfig.
        :rtype: str
        """
        return self._branch_name

    @branch_name.setter
    def branch_name(self, branch_name):
        """
        Sets the branch_name of this CatalogGitResultConfig.
        branch Name


        :param branch_name: The branch_name of this CatalogGitResultConfig.
        :type: str
        """
        self._branch_name = branch_name

    @property
    def configuration_source_provider_id(self):
        """
        Gets the configuration_source_provider_id of this CatalogGitResultConfig.
        configuration Source Provider `OCID`__

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The configuration_source_provider_id of this CatalogGitResultConfig.
        :rtype: str
        """
        return self._configuration_source_provider_id

    @configuration_source_provider_id.setter
    def configuration_source_provider_id(self, configuration_source_provider_id):
        """
        Sets the configuration_source_provider_id of this CatalogGitResultConfig.
        configuration Source Provider `OCID`__

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param configuration_source_provider_id: The configuration_source_provider_id of this CatalogGitResultConfig.
        :type: str
        """
        self._configuration_source_provider_id = configuration_source_provider_id

    @property
    def repository_url(self):
        """
        Gets the repository_url of this CatalogGitResultConfig.
        repository Url


        :return: The repository_url of this CatalogGitResultConfig.
        :rtype: str
        """
        return self._repository_url

    @repository_url.setter
    def repository_url(self, repository_url):
        """
        Sets the repository_url of this CatalogGitResultConfig.
        repository Url


        :param repository_url: The repository_url of this CatalogGitResultConfig.
        :type: str
        """
        self._repository_url = repository_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
