# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComplianceDetailProduct(object):
    """
    Details of the Product.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComplianceDetailProduct object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param product_stack:
            The value to assign to the product_stack property of this ComplianceDetailProduct.
        :type product_stack: str

        :param product_name:
            The value to assign to the product_name property of this ComplianceDetailProduct.
        :type product_name: str

        :param product_version:
            The value to assign to the product_version property of this ComplianceDetailProduct.
        :type product_version: str

        """
        self.swagger_types = {
            'product_stack': 'str',
            'product_name': 'str',
            'product_version': 'str'
        }
        self.attribute_map = {
            'product_stack': 'productStack',
            'product_name': 'productName',
            'product_version': 'productVersion'
        }
        self._product_stack = None
        self._product_name = None
        self._product_version = None

    @property
    def product_stack(self):
        """
        Gets the product_stack of this ComplianceDetailProduct.
        Product Stack.


        :return: The product_stack of this ComplianceDetailProduct.
        :rtype: str
        """
        return self._product_stack

    @product_stack.setter
    def product_stack(self, product_stack):
        """
        Sets the product_stack of this ComplianceDetailProduct.
        Product Stack.


        :param product_stack: The product_stack of this ComplianceDetailProduct.
        :type: str
        """
        self._product_stack = product_stack

    @property
    def product_name(self):
        """
        **[Required]** Gets the product_name of this ComplianceDetailProduct.
        Product Name.


        :return: The product_name of this ComplianceDetailProduct.
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """
        Sets the product_name of this ComplianceDetailProduct.
        Product Name.


        :param product_name: The product_name of this ComplianceDetailProduct.
        :type: str
        """
        self._product_name = product_name

    @property
    def product_version(self):
        """
        Gets the product_version of this ComplianceDetailProduct.
        Product Version.


        :return: The product_version of this ComplianceDetailProduct.
        :rtype: str
        """
        return self._product_version

    @product_version.setter
    def product_version(self, product_version):
        """
        Sets the product_version of this ComplianceDetailProduct.
        Product Version.


        :param product_version: The product_version of this ComplianceDetailProduct.
        :type: str
        """
        self._product_version = product_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
