# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .base_output import BaseOutput
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CsvOutput(BaseOutput):
    """
    CSV output.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CsvOutput object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.CsvOutput.type` attribute
        of this class is ``CSV`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CsvOutput.
            Allowed values for this property are: "ARRAY", "BOOLEAN", "NUMBER", "STRING", "COPYABLESTRING", "MAP", "LIST", "JSON", "CSV", "LINK", "OCID"
        :type type: str

        :param title:
            The value to assign to the title property of this CsvOutput.
        :type title: str

        :param description:
            The value to assign to the description property of this CsvOutput.
        :type description: str

        :param is_sensitive:
            The value to assign to the is_sensitive property of this CsvOutput.
        :type is_sensitive: bool

        :param format:
            The value to assign to the format property of this CsvOutput.
        :type format: str

        :param visible:
            The value to assign to the visible property of this CsvOutput.
        :type visible: str

        :param value:
            The value to assign to the value property of this CsvOutput.
        :type value: list[object]

        """
        self.swagger_types = {
            'type': 'str',
            'title': 'str',
            'description': 'str',
            'is_sensitive': 'bool',
            'format': 'str',
            'visible': 'str',
            'value': 'list[object]'
        }
        self.attribute_map = {
            'type': 'type',
            'title': 'title',
            'description': 'description',
            'is_sensitive': 'isSensitive',
            'format': 'format',
            'visible': 'visible',
            'value': 'value'
        }
        self._type = None
        self._title = None
        self._description = None
        self._is_sensitive = None
        self._format = None
        self._visible = None
        self._value = None
        self._type = 'CSV'

    @property
    def value(self):
        """
        Gets the value of this CsvOutput.
        Array of objects for CSV rows.


        :return: The value of this CsvOutput.
        :rtype: list[object]
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this CsvOutput.
        Array of objects for CSV rows.


        :param value: The value of this CsvOutput.
        :type: list[object]
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
