# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .config_category_details import ConfigCategoryDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EnvironmentConfigCategoryDetails(ConfigCategoryDetails):
    """
    Environment Config Category Details.
    Defines the supported prioritization associated with resources based on the implementation phase of the applications hosted by them.
    For example, your organization might support development, beta, or production environment types.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EnvironmentConfigCategoryDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.EnvironmentConfigCategoryDetails.config_category` attribute
        of this class is ``ENVIRONMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_category:
            The value to assign to the config_category property of this EnvironmentConfigCategoryDetails.
            Allowed values for this property are: "PRODUCT", "PRODUCT_STACK", "ENVIRONMENT", "PATCH_TYPE", "CREDENTIAL", "SELF_HOSTED_INSTANCE", "LIFECYCLE_OPERATION"
        :type config_category: str

        """
        self.swagger_types = {
            'config_category': 'str'
        }
        self.attribute_map = {
            'config_category': 'configCategory'
        }
        self._config_category = None
        self._config_category = 'ENVIRONMENT'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
