# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportRunbookVersionDetails(object):
    """
    Request to Export Runbook Version.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExportRunbookVersionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content_destination:
            The value to assign to the content_destination property of this ExportRunbookVersionDetails.
        :type content_destination: oci.fleet_apps_management.models.TransferRunbookContentDetails

        :param version:
            The value to assign to the version property of this ExportRunbookVersionDetails.
        :type version: float

        """
        self.swagger_types = {
            'content_destination': 'TransferRunbookContentDetails',
            'version': 'float'
        }
        self.attribute_map = {
            'content_destination': 'contentDestination',
            'version': 'version'
        }
        self._content_destination = None
        self._version = None

    @property
    def content_destination(self):
        """
        **[Required]** Gets the content_destination of this ExportRunbookVersionDetails.

        :return: The content_destination of this ExportRunbookVersionDetails.
        :rtype: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        return self._content_destination

    @content_destination.setter
    def content_destination(self, content_destination):
        """
        Sets the content_destination of this ExportRunbookVersionDetails.

        :param content_destination: The content_destination of this ExportRunbookVersionDetails.
        :type: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        self._content_destination = content_destination

    @property
    def version(self):
        """
        Gets the version of this ExportRunbookVersionDetails.
        Export Runbook Version Details.


        :return: The version of this ExportRunbookVersionDetails.
        :rtype: float
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ExportRunbookVersionDetails.
        Export Runbook Version Details.


        :param version: The version of this ExportRunbookVersionDetails.
        :type: float
        """
        self._version = version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
