# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .action_group_details import ActionGroupDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FleetBasedActionGroupDetails(ActionGroupDetails):
    """
    A string variable that holds a value
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FleetBasedActionGroupDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.FleetBasedActionGroupDetails.kind` attribute
        of this class is ``FLEET_USING_RUNBOOK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this FleetBasedActionGroupDetails.
        :type display_name: str

        :param kind:
            The value to assign to the kind property of this FleetBasedActionGroupDetails.
            Allowed values for this property are: "FLEET_USING_RUNBOOK"
        :type kind: str

        :param product:
            The value to assign to the product property of this FleetBasedActionGroupDetails.
        :type product: str

        :param lifecycle_operation:
            The value to assign to the lifecycle_operation property of this FleetBasedActionGroupDetails.
        :type lifecycle_operation: str

        :param activity_id:
            The value to assign to the activity_id property of this FleetBasedActionGroupDetails.
        :type activity_id: str

        :param status:
            The value to assign to the status property of this FleetBasedActionGroupDetails.
            Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED"
        :type status: str

        :param time_started:
            The value to assign to the time_started property of this FleetBasedActionGroupDetails.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this FleetBasedActionGroupDetails.
        :type time_ended: datetime

        :param fleet_id:
            The value to assign to the fleet_id property of this FleetBasedActionGroupDetails.
        :type fleet_id: str

        :param sequence:
            The value to assign to the sequence property of this FleetBasedActionGroupDetails.
        :type sequence: int

        :param runbook_id:
            The value to assign to the runbook_id property of this FleetBasedActionGroupDetails.
        :type runbook_id: str

        :param runbook_version_name:
            The value to assign to the runbook_version_name property of this FleetBasedActionGroupDetails.
        :type runbook_version_name: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'kind': 'str',
            'product': 'str',
            'lifecycle_operation': 'str',
            'activity_id': 'str',
            'status': 'str',
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'fleet_id': 'str',
            'sequence': 'int',
            'runbook_id': 'str',
            'runbook_version_name': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'kind': 'kind',
            'product': 'product',
            'lifecycle_operation': 'lifecycleOperation',
            'activity_id': 'activityId',
            'status': 'status',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'fleet_id': 'fleetId',
            'sequence': 'sequence',
            'runbook_id': 'runbookId',
            'runbook_version_name': 'runbookVersionName'
        }
        self._display_name = None
        self._kind = None
        self._product = None
        self._lifecycle_operation = None
        self._activity_id = None
        self._status = None
        self._time_started = None
        self._time_ended = None
        self._fleet_id = None
        self._sequence = None
        self._runbook_id = None
        self._runbook_version_name = None
        self._kind = 'FLEET_USING_RUNBOOK'

    @property
    def fleet_id(self):
        """
        **[Required]** Gets the fleet_id of this FleetBasedActionGroupDetails.
        ID of the fleet


        :return: The fleet_id of this FleetBasedActionGroupDetails.
        :rtype: str
        """
        return self._fleet_id

    @fleet_id.setter
    def fleet_id(self, fleet_id):
        """
        Sets the fleet_id of this FleetBasedActionGroupDetails.
        ID of the fleet


        :param fleet_id: The fleet_id of this FleetBasedActionGroupDetails.
        :type: str
        """
        self._fleet_id = fleet_id

    @property
    def sequence(self):
        """
        Gets the sequence of this FleetBasedActionGroupDetails.
        sequence of the Action Group


        :return: The sequence of this FleetBasedActionGroupDetails.
        :rtype: int
        """
        return self._sequence

    @sequence.setter
    def sequence(self, sequence):
        """
        Sets the sequence of this FleetBasedActionGroupDetails.
        sequence of the Action Group


        :param sequence: The sequence of this FleetBasedActionGroupDetails.
        :type: int
        """
        self._sequence = sequence

    @property
    def runbook_id(self):
        """
        **[Required]** Gets the runbook_id of this FleetBasedActionGroupDetails.
        ID of the runbook


        :return: The runbook_id of this FleetBasedActionGroupDetails.
        :rtype: str
        """
        return self._runbook_id

    @runbook_id.setter
    def runbook_id(self, runbook_id):
        """
        Sets the runbook_id of this FleetBasedActionGroupDetails.
        ID of the runbook


        :param runbook_id: The runbook_id of this FleetBasedActionGroupDetails.
        :type: str
        """
        self._runbook_id = runbook_id

    @property
    def runbook_version_name(self):
        """
        **[Required]** Gets the runbook_version_name of this FleetBasedActionGroupDetails.
        Name of the runbook version


        :return: The runbook_version_name of this FleetBasedActionGroupDetails.
        :rtype: str
        """
        return self._runbook_version_name

    @runbook_version_name.setter
    def runbook_version_name(self, runbook_version_name):
        """
        Sets the runbook_version_name of this FleetBasedActionGroupDetails.
        Name of the runbook version


        :param runbook_version_name: The runbook_version_name of this FleetBasedActionGroupDetails.
        :type: str
        """
        self._runbook_version_name = runbook_version_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
