# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceSummary(object):
    """
    InstanceSummary contains info regarding deployed instances.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this InstanceSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InstanceSummary.
        :type compartment_id: str

        :param state:
            The value to assign to the state property of this InstanceSummary.
        :type state: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'state': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'state': 'state'
        }
        self._id = None
        self._compartment_id = None
        self._state = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this InstanceSummary.
        The `OCID`__ of the instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this InstanceSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this InstanceSummary.
        The `OCID`__ of the instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this InstanceSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this InstanceSummary.
        The `OCID`__ of the compartment in which instance is deployed.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this InstanceSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InstanceSummary.
        The `OCID`__ of the compartment in which instance is deployed.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this InstanceSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def state(self):
        """
        **[Required]** Gets the state of this InstanceSummary.
        Instance lifecycle state


        :return: The state of this InstanceSummary.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this InstanceSummary.
        Instance lifecycle state


        :param state: The state of this InstanceSummary.
        :type: str
        """
        self._state = state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
