# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .base_variable import BaseVariable
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IntegerVariable(BaseVariable):
    """
    Integer variable.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IntegerVariable object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.IntegerVariable.type` attribute
        of this class is ``INTEGER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this IntegerVariable.
            Allowed values for this property are: "ARRAY", "BOOLEAN", "ENUM", "INTEGER", "NUMBER", "STRING", "TEXT", "FILE", "PASSWORD", "DATETIME", "DUMMY", "OCI_IDENTITY_DOMAINS_ID", "OCI_CORE_IMAGE_ID", "OCI_CORE_INSTANCESHAPEWITHFLEX_NAME", "OCI_CORE_INSTANCESHAPE_NAME", "OCI_CORE_NATGATEWAY_ID", "OCI_CORE_INSTANCE_ID", "OCI_CORE_SUBNET_ID", "OCI_CORE_SERVICEGATEWAY_ID", "OCI_LOGAN_LOGGROUP_ID", "OCI_LOGAN_SCHEDULEDTASK_ID", "OCI_LOGAN_LOGENTITY_ID", "OCI_LOGAN_ENTITYTYPE_ID", "OCI_MGMT_AGENT_ID", "OCI_LOGAN_SOURCE_ID", "OCI_CORE_NSG_ID", "OCI_CORE_VCN_ID", "OCI_IDENTITY_AVAILABILITYDOMAIN_NAME", "OCI_IDENTITY_COMPARTMENT_ID", "OCI_IDENTITY_FAULTDOMAIN_NAME", "OCI_IDENTITY_REGION_NAME", "OCI_DATABASE_DBSYSTEM_ID", "OCI_DATABASE_DBHOME_ID", "OCI_DATABASE_DBHOME_DBVERSION", "OCI_DATABASE_DATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID", "OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID", "OCI_KMS_KEY_ID", "OCI_KMS_SECRET_ID", "OCI_CONTAINER_CLUSTER_ID", "OCI_KUBERNETES_VERSIONS_ID", "OCI_BLOCKSTORAGE_POLICIES_ID", "OCI_IDENTITY_GROUPS_ID", "OCI_IDENTITY_DYNAMICGROUPS_ID", "OCI_LOADBALANCER_LOADBALANCER_ID", "OCI_MOUNT_TARGET_ID", "OCI_IDENTITY_TAG_VALUE", "OCI_ODS_PROJECT_ID", "OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID", "OCI_APM_DOMAIN_ID", "OCI_CORE_SSH_PUBLICKEY", "OCI_KMS_VAULT_ID", "OCI_LOADBALANCER_NETWORKLOADBALANCER_ID", "OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID", "OCI_DATABASE_MYSQL_SHAPE_ID", "OCI_DATABASE_MYSQL_CONFIGURATION_ID", "OCI_STORAGE_FILESTORAGE_EXPORTSET_ID", "OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID", "OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME", "OCI_CORE_VCN_SECLIST_ID", "OCI_CORE_VOLUME_ID", "OCI_DATABASE_DATAGUARD_ID", "OCI_DATABASE_EXADATA_ID", "OCI_DATABASE_CLOUDVMCLUSTER_ID", "OCI_DATABASE_CDB_ID", "OCI_DATABASE_DATAGUARDASSOCIATION_ID", "OCI_DATABASE_DBNODE_ID", "OCI_CORE_VCN_NETWORKSECURITYGROUP_ID", "OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID"
        :type type: str

        :param title:
            The value to assign to the title property of this IntegerVariable.
        :type title: str

        :param description:
            The value to assign to the description property of this IntegerVariable.
        :type description: str

        :param is_required:
            The value to assign to the is_required property of this IntegerVariable.
        :type is_required: bool

        :param visible:
            The value to assign to the visible property of this IntegerVariable.
        :type visible: str

        :param default_value:
            The value to assign to the default_value property of this IntegerVariable.
        :type default_value: int

        :param multiple_of:
            The value to assign to the multiple_of property of this IntegerVariable.
        :type multiple_of: float

        :param minimum:
            The value to assign to the minimum property of this IntegerVariable.
        :type minimum: float

        :param maximum:
            The value to assign to the maximum property of this IntegerVariable.
        :type maximum: float

        :param exclusive_minimum:
            The value to assign to the exclusive_minimum property of this IntegerVariable.
        :type exclusive_minimum: float

        :param exclusive_maximum:
            The value to assign to the exclusive_maximum property of this IntegerVariable.
        :type exclusive_maximum: float

        """
        self.swagger_types = {
            'type': 'str',
            'title': 'str',
            'description': 'str',
            'is_required': 'bool',
            'visible': 'str',
            'default_value': 'int',
            'multiple_of': 'float',
            'minimum': 'float',
            'maximum': 'float',
            'exclusive_minimum': 'float',
            'exclusive_maximum': 'float'
        }
        self.attribute_map = {
            'type': 'type',
            'title': 'title',
            'description': 'description',
            'is_required': 'isRequired',
            'visible': 'visible',
            'default_value': 'defaultValue',
            'multiple_of': 'multipleOf',
            'minimum': 'minimum',
            'maximum': 'maximum',
            'exclusive_minimum': 'exclusiveMinimum',
            'exclusive_maximum': 'exclusiveMaximum'
        }
        self._type = None
        self._title = None
        self._description = None
        self._is_required = None
        self._visible = None
        self._default_value = None
        self._multiple_of = None
        self._minimum = None
        self._maximum = None
        self._exclusive_minimum = None
        self._exclusive_maximum = None
        self._type = 'INTEGER'

    @property
    def default_value(self):
        """
        Gets the default_value of this IntegerVariable.
        Default value if input is not supplied.


        :return: The default_value of this IntegerVariable.
        :rtype: int
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this IntegerVariable.
        Default value if input is not supplied.


        :param default_value: The default_value of this IntegerVariable.
        :type: int
        """
        self._default_value = default_value

    @property
    def multiple_of(self):
        """
        Gets the multiple_of of this IntegerVariable.
        Value must be a multiple of this number.


        :return: The multiple_of of this IntegerVariable.
        :rtype: float
        """
        return self._multiple_of

    @multiple_of.setter
    def multiple_of(self, multiple_of):
        """
        Sets the multiple_of of this IntegerVariable.
        Value must be a multiple of this number.


        :param multiple_of: The multiple_of of this IntegerVariable.
        :type: float
        """
        self._multiple_of = multiple_of

    @property
    def minimum(self):
        """
        Gets the minimum of this IntegerVariable.
        The minimum accepted integer value.


        :return: The minimum of this IntegerVariable.
        :rtype: float
        """
        return self._minimum

    @minimum.setter
    def minimum(self, minimum):
        """
        Sets the minimum of this IntegerVariable.
        The minimum accepted integer value.


        :param minimum: The minimum of this IntegerVariable.
        :type: float
        """
        self._minimum = minimum

    @property
    def maximum(self):
        """
        Gets the maximum of this IntegerVariable.
        The maximum accepted integer value.


        :return: The maximum of this IntegerVariable.
        :rtype: float
        """
        return self._maximum

    @maximum.setter
    def maximum(self, maximum):
        """
        Sets the maximum of this IntegerVariable.
        The maximum accepted integer value.


        :param maximum: The maximum of this IntegerVariable.
        :type: float
        """
        self._maximum = maximum

    @property
    def exclusive_minimum(self):
        """
        Gets the exclusive_minimum of this IntegerVariable.
        Value must be greater than this (exclusive lower bound).


        :return: The exclusive_minimum of this IntegerVariable.
        :rtype: float
        """
        return self._exclusive_minimum

    @exclusive_minimum.setter
    def exclusive_minimum(self, exclusive_minimum):
        """
        Sets the exclusive_minimum of this IntegerVariable.
        Value must be greater than this (exclusive lower bound).


        :param exclusive_minimum: The exclusive_minimum of this IntegerVariable.
        :type: float
        """
        self._exclusive_minimum = exclusive_minimum

    @property
    def exclusive_maximum(self):
        """
        Gets the exclusive_maximum of this IntegerVariable.
        Value must be less than this (exclusive upper bound).


        :return: The exclusive_maximum of this IntegerVariable.
        :rtype: float
        """
        return self._exclusive_maximum

    @exclusive_maximum.setter
    def exclusive_maximum(self, exclusive_maximum):
        """
        Sets the exclusive_maximum of this IntegerVariable.
        Value must be less than this (exclusive upper bound).


        :param exclusive_maximum: The exclusive_maximum of this IntegerVariable.
        :type: float
        """
        self._exclusive_maximum = exclusive_maximum

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
