# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Properties(object):
    """
    The properties of the task.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Properties object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param num_retries:
            The value to assign to the num_retries property of this Properties.
        :type num_retries: int

        :param timeout_in_seconds:
            The value to assign to the timeout_in_seconds property of this Properties.
        :type timeout_in_seconds: int

        """
        self.swagger_types = {
            'num_retries': 'int',
            'timeout_in_seconds': 'int'
        }
        self.attribute_map = {
            'num_retries': 'numRetries',
            'timeout_in_seconds': 'timeoutInSeconds'
        }
        self._num_retries = None
        self._timeout_in_seconds = None

    @property
    def num_retries(self):
        """
        **[Required]** Gets the num_retries of this Properties.
        The number of retries allowed.


        :return: The num_retries of this Properties.
        :rtype: int
        """
        return self._num_retries

    @num_retries.setter
    def num_retries(self, num_retries):
        """
        Sets the num_retries of this Properties.
        The number of retries allowed.


        :param num_retries: The num_retries of this Properties.
        :type: int
        """
        self._num_retries = num_retries

    @property
    def timeout_in_seconds(self):
        """
        **[Required]** Gets the timeout_in_seconds of this Properties.
        The timeout in seconds for the task.


        :return: The timeout_in_seconds of this Properties.
        :rtype: int
        """
        return self._timeout_in_seconds

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, timeout_in_seconds):
        """
        Sets the timeout_in_seconds of this Properties.
        The timeout in seconds for the task.


        :param timeout_in_seconds: The timeout_in_seconds of this Properties.
        :type: int
        """
        self._timeout_in_seconds = timeout_in_seconds

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
