# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .runbook_import_as import RunbookImportAs
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunbookImportAsRunbook(RunbookImportAs):
    """
    Import as Runbook.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RunbookImportAsRunbook object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.RunbookImportAsRunbook.import_type` attribute
        of this class is ``RUNBOOK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param import_type:
            The value to assign to the import_type property of this RunbookImportAsRunbook.
            Allowed values for this property are: "RUNBOOK", "RUNBOOK_VERSION"
        :type import_type: str

        :param version:
            The value to assign to the version property of this RunbookImportAsRunbook.
        :type version: str

        :param import_option:
            The value to assign to the import_option property of this RunbookImportAsRunbook.
        :type import_option: str

        :param runbook_name:
            The value to assign to the runbook_name property of this RunbookImportAsRunbook.
        :type runbook_name: str

        """
        self.swagger_types = {
            'import_type': 'str',
            'version': 'str',
            'import_option': 'str',
            'runbook_name': 'str'
        }
        self.attribute_map = {
            'import_type': 'importType',
            'version': 'version',
            'import_option': 'importOption',
            'runbook_name': 'runbookName'
        }
        self._import_type = None
        self._version = None
        self._import_option = None
        self._runbook_name = None
        self._import_type = 'RUNBOOK'

    @property
    def runbook_name(self):
        """
        **[Required]** Gets the runbook_name of this RunbookImportAsRunbook.
        Only for RUNBOOK importType.


        :return: The runbook_name of this RunbookImportAsRunbook.
        :rtype: str
        """
        return self._runbook_name

    @runbook_name.setter
    def runbook_name(self, runbook_name):
        """
        Sets the runbook_name of this RunbookImportAsRunbook.
        Only for RUNBOOK importType.


        :param runbook_name: The runbook_name of this RunbookImportAsRunbook.
        :type: str
        """
        self._runbook_name = runbook_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
