# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RollbackDetails(object):
    """
    Rollback details specified for the action.
    """

    #: A constant which can be used with the strategy property of a RollbackDetails.
    #: This constant has a value of "FAILED_JOBS"
    STRATEGY_FAILED_JOBS = "FAILED_JOBS"

    #: A constant which can be used with the strategy property of a RollbackDetails.
    #: This constant has a value of "LIST_OF_TARGETS"
    STRATEGY_LIST_OF_TARGETS = "LIST_OF_TARGETS"

    def __init__(self, **kwargs):
        """
        Initializes a new RollbackDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_software_update.models.ListOfTargetsRollbackDetails`
        * :class:`~oci.fleet_software_update.models.FailedJobsRollbackDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param strategy:
            The value to assign to the strategy property of this RollbackDetails.
            Allowed values for this property are: "FAILED_JOBS", "LIST_OF_TARGETS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type strategy: str

        """
        self.swagger_types = {
            'strategy': 'str'
        }
        self.attribute_map = {
            'strategy': 'strategy'
        }
        self._strategy = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['strategy']

        if type == 'LIST_OF_TARGETS':
            return 'ListOfTargetsRollbackDetails'

        if type == 'FAILED_JOBS':
            return 'FailedJobsRollbackDetails'
        else:
            return 'RollbackDetails'

    @property
    def strategy(self):
        """
        **[Required]** Gets the strategy of this RollbackDetails.
        Rollback strategy to use.
        FAILED_JOBS: Rollback and remove targets which had a failure in their last job.
        LIST_OF_TARGETS: Rollback and remove a specific list of targets.

        Allowed values for this property are: "FAILED_JOBS", "LIST_OF_TARGETS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The strategy of this RollbackDetails.
        :rtype: str
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """
        Sets the strategy of this RollbackDetails.
        Rollback strategy to use.
        FAILED_JOBS: Rollback and remove targets which had a failure in their last job.
        LIST_OF_TARGETS: Rollback and remove a specific list of targets.


        :param strategy: The strategy of this RollbackDetails.
        :type: str
        """
        allowed_values = ["FAILED_JOBS", "LIST_OF_TARGETS"]
        if not value_allowed_none_or_none_sentinel(strategy, allowed_values):
            strategy = 'UNKNOWN_ENUM_VALUE'
        self._strategy = strategy

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
