# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ContentModerationGuardrailConfig(object):
    """
    The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
    """

    #: A constant which can be used with the input_guardrail_mode property of a ContentModerationGuardrailConfig.
    #: This constant has a value of "DISABLE"
    INPUT_GUARDRAIL_MODE_DISABLE = "DISABLE"

    #: A constant which can be used with the input_guardrail_mode property of a ContentModerationGuardrailConfig.
    #: This constant has a value of "BLOCK"
    INPUT_GUARDRAIL_MODE_BLOCK = "BLOCK"

    #: A constant which can be used with the input_guardrail_mode property of a ContentModerationGuardrailConfig.
    #: This constant has a value of "INFORM"
    INPUT_GUARDRAIL_MODE_INFORM = "INFORM"

    #: A constant which can be used with the output_guardrail_mode property of a ContentModerationGuardrailConfig.
    #: This constant has a value of "DISABLE"
    OUTPUT_GUARDRAIL_MODE_DISABLE = "DISABLE"

    #: A constant which can be used with the output_guardrail_mode property of a ContentModerationGuardrailConfig.
    #: This constant has a value of "BLOCK"
    OUTPUT_GUARDRAIL_MODE_BLOCK = "BLOCK"

    #: A constant which can be used with the output_guardrail_mode property of a ContentModerationGuardrailConfig.
    #: This constant has a value of "INFORM"
    OUTPUT_GUARDRAIL_MODE_INFORM = "INFORM"

    def __init__(self, **kwargs):
        """
        Initializes a new ContentModerationGuardrailConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param input_guardrail_mode:
            The value to assign to the input_guardrail_mode property of this ContentModerationGuardrailConfig.
            Allowed values for this property are: "DISABLE", "BLOCK", "INFORM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type input_guardrail_mode: str

        :param output_guardrail_mode:
            The value to assign to the output_guardrail_mode property of this ContentModerationGuardrailConfig.
            Allowed values for this property are: "DISABLE", "BLOCK", "INFORM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type output_guardrail_mode: str

        """
        self.swagger_types = {
            'input_guardrail_mode': 'str',
            'output_guardrail_mode': 'str'
        }
        self.attribute_map = {
            'input_guardrail_mode': 'inputGuardrailMode',
            'output_guardrail_mode': 'outputGuardrailMode'
        }
        self._input_guardrail_mode = None
        self._output_guardrail_mode = None

    @property
    def input_guardrail_mode(self):
        """
        Gets the input_guardrail_mode of this ContentModerationGuardrailConfig.
        An input guardrail mode for content moderation.

        Allowed values for this property are: "DISABLE", "BLOCK", "INFORM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The input_guardrail_mode of this ContentModerationGuardrailConfig.
        :rtype: str
        """
        return self._input_guardrail_mode

    @input_guardrail_mode.setter
    def input_guardrail_mode(self, input_guardrail_mode):
        """
        Sets the input_guardrail_mode of this ContentModerationGuardrailConfig.
        An input guardrail mode for content moderation.


        :param input_guardrail_mode: The input_guardrail_mode of this ContentModerationGuardrailConfig.
        :type: str
        """
        allowed_values = ["DISABLE", "BLOCK", "INFORM"]
        if not value_allowed_none_or_none_sentinel(input_guardrail_mode, allowed_values):
            input_guardrail_mode = 'UNKNOWN_ENUM_VALUE'
        self._input_guardrail_mode = input_guardrail_mode

    @property
    def output_guardrail_mode(self):
        """
        Gets the output_guardrail_mode of this ContentModerationGuardrailConfig.
        An output guardrail mode for content moderation.

        Allowed values for this property are: "DISABLE", "BLOCK", "INFORM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The output_guardrail_mode of this ContentModerationGuardrailConfig.
        :rtype: str
        """
        return self._output_guardrail_mode

    @output_guardrail_mode.setter
    def output_guardrail_mode(self, output_guardrail_mode):
        """
        Sets the output_guardrail_mode of this ContentModerationGuardrailConfig.
        An output guardrail mode for content moderation.


        :param output_guardrail_mode: The output_guardrail_mode of this ContentModerationGuardrailConfig.
        :type: str
        """
        allowed_values = ["DISABLE", "BLOCK", "INFORM"]
        if not value_allowed_none_or_none_sentinel(output_guardrail_mode, allowed_values):
            output_guardrail_mode = 'UNKNOWN_ENUM_VALUE'
        self._output_guardrail_mode = output_guardrail_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
