# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Function(object):
    """
    Details of Function for Function calling tool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Function object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this Function.
        :type name: str

        :param description:
            The value to assign to the description property of this Function.
        :type description: str

        :param parameters:
            The value to assign to the parameters property of this Function.
        :type parameters: dict(str, str)

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'parameters': 'dict(str, str)'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'parameters': 'parameters'
        }
        self._name = None
        self._description = None
        self._parameters = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this Function.
        The name of the function to invoke.


        :return: The name of this Function.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Function.
        The name of the function to invoke.


        :param name: The name of this Function.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this Function.
        A description of the function.


        :return: The description of this Function.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Function.
        A description of the function.


        :param description: The description of this Function.
        :type: str
        """
        self._description = description

    @property
    def parameters(self):
        """
        Gets the parameters of this Function.
        The parameters the function accepts, defined using a JSON Schema object.
        Refer to the guide for examples and the JSON Schema documentation for details on the format.


        :return: The parameters of this Function.
        :rtype: dict(str, str)
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this Function.
        The parameters the function accepts, defined using a JSON Schema object.
        Refer to the guide for examples and the JSON Schema documentation for details on the format.


        :param parameters: The parameters of this Function.
        :type: dict(str, str)
        """
        self._parameters = parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
