# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KnowledgeBaseConfig(object):
    """
    The KnowledgeBase configuration this RAG Tool uses.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KnowledgeBaseConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param knowledge_base_id:
            The value to assign to the knowledge_base_id property of this KnowledgeBaseConfig.
        :type knowledge_base_id: str

        """
        self.swagger_types = {
            'knowledge_base_id': 'str'
        }
        self.attribute_map = {
            'knowledge_base_id': 'knowledgeBaseId'
        }
        self._knowledge_base_id = None

    @property
    def knowledge_base_id(self):
        """
        **[Required]** Gets the knowledge_base_id of this KnowledgeBaseConfig.
        The `OCID`__ of the knowledgeBase this RAG Tool uses

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The knowledge_base_id of this KnowledgeBaseConfig.
        :rtype: str
        """
        return self._knowledge_base_id

    @knowledge_base_id.setter
    def knowledge_base_id(self, knowledge_base_id):
        """
        Sets the knowledge_base_id of this KnowledgeBaseConfig.
        The `OCID`__ of the knowledgeBase this RAG Tool uses

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param knowledge_base_id: The knowledge_base_id of this KnowledgeBaseConfig.
        :type: str
        """
        self._knowledge_base_id = knowledge_base_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
