# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .data_source_config import DataSourceConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciObjectStorageDataSourceConfig(DataSourceConfig):
    """
    The details of OCI Search with OpenSearch data source information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciObjectStorageDataSourceConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.OciObjectStorageDataSourceConfig.data_source_config_type` attribute
        of this class is ``OCI_OBJECT_STORAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param should_enable_multi_modality:
            The value to assign to the should_enable_multi_modality property of this OciObjectStorageDataSourceConfig.
        :type should_enable_multi_modality: bool

        :param data_source_config_type:
            The value to assign to the data_source_config_type property of this OciObjectStorageDataSourceConfig.
            Allowed values for this property are: "OCI_OBJECT_STORAGE"
        :type data_source_config_type: str

        :param object_storage_prefixes:
            The value to assign to the object_storage_prefixes property of this OciObjectStorageDataSourceConfig.
        :type object_storage_prefixes: list[oci.generative_ai_agent.models.ObjectStoragePrefix]

        """
        self.swagger_types = {
            'should_enable_multi_modality': 'bool',
            'data_source_config_type': 'str',
            'object_storage_prefixes': 'list[ObjectStoragePrefix]'
        }
        self.attribute_map = {
            'should_enable_multi_modality': 'shouldEnableMultiModality',
            'data_source_config_type': 'dataSourceConfigType',
            'object_storage_prefixes': 'objectStoragePrefixes'
        }
        self._should_enable_multi_modality = None
        self._data_source_config_type = None
        self._object_storage_prefixes = None
        self._data_source_config_type = 'OCI_OBJECT_STORAGE'

    @property
    def object_storage_prefixes(self):
        """
        Gets the object_storage_prefixes of this OciObjectStorageDataSourceConfig.
        The locations of data items in Object Storage, can either be an object (File) or a prefix (folder).


        :return: The object_storage_prefixes of this OciObjectStorageDataSourceConfig.
        :rtype: list[oci.generative_ai_agent.models.ObjectStoragePrefix]
        """
        return self._object_storage_prefixes

    @object_storage_prefixes.setter
    def object_storage_prefixes(self, object_storage_prefixes):
        """
        Sets the object_storage_prefixes of this OciObjectStorageDataSourceConfig.
        The locations of data items in Object Storage, can either be an object (File) or a prefix (folder).


        :param object_storage_prefixes: The object_storage_prefixes of this OciObjectStorageDataSourceConfig.
        :type: list[oci.generative_ai_agent.models.ObjectStoragePrefix]
        """
        self._object_storage_prefixes = object_storage_prefixes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
