# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PerformedAction(object):
    """
    The base structure for an action that has already been performed.
    """

    #: A constant which can be used with the performed_action_type property of a PerformedAction.
    #: This constant has a value of "HUMAN_APPROVAL_PERFORMED_ACTION"
    PERFORMED_ACTION_TYPE_HUMAN_APPROVAL_PERFORMED_ACTION = "HUMAN_APPROVAL_PERFORMED_ACTION"

    #: A constant which can be used with the performed_action_type property of a PerformedAction.
    #: This constant has a value of "FUNCTION_CALLING_PERFORMED_ACTION"
    PERFORMED_ACTION_TYPE_FUNCTION_CALLING_PERFORMED_ACTION = "FUNCTION_CALLING_PERFORMED_ACTION"

    def __init__(self, **kwargs):
        """
        Initializes a new PerformedAction object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_agent_runtime.models.FunctionCallingPerformedAction`
        * :class:`~oci.generative_ai_agent_runtime.models.HumanApprovalPerformedAction`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_id:
            The value to assign to the action_id property of this PerformedAction.
        :type action_id: str

        :param performed_action_type:
            The value to assign to the performed_action_type property of this PerformedAction.
            Allowed values for this property are: "HUMAN_APPROVAL_PERFORMED_ACTION", "FUNCTION_CALLING_PERFORMED_ACTION"
        :type performed_action_type: str

        """
        self.swagger_types = {
            'action_id': 'str',
            'performed_action_type': 'str'
        }
        self.attribute_map = {
            'action_id': 'actionId',
            'performed_action_type': 'performedActionType'
        }
        self._action_id = None
        self._performed_action_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['performedActionType']

        if type == 'FUNCTION_CALLING_PERFORMED_ACTION':
            return 'FunctionCallingPerformedAction'

        if type == 'HUMAN_APPROVAL_PERFORMED_ACTION':
            return 'HumanApprovalPerformedAction'
        else:
            return 'PerformedAction'

    @property
    def action_id(self):
        """
        **[Required]** Gets the action_id of this PerformedAction.
        The unique identifier for the action that has been performed.


        :return: The action_id of this PerformedAction.
        :rtype: str
        """
        return self._action_id

    @action_id.setter
    def action_id(self, action_id):
        """
        Sets the action_id of this PerformedAction.
        The unique identifier for the action that has been performed.


        :param action_id: The action_id of this PerformedAction.
        :type: str
        """
        self._action_id = action_id

    @property
    def performed_action_type(self):
        """
        **[Required]** Gets the performed_action_type of this PerformedAction.
        Specifies the type of the performed action.

        Allowed values for this property are: "HUMAN_APPROVAL_PERFORMED_ACTION", "FUNCTION_CALLING_PERFORMED_ACTION"


        :return: The performed_action_type of this PerformedAction.
        :rtype: str
        """
        return self._performed_action_type

    @performed_action_type.setter
    def performed_action_type(self, performed_action_type):
        """
        Sets the performed_action_type of this PerformedAction.
        Specifies the type of the performed action.


        :param performed_action_type: The performed_action_type of this PerformedAction.
        :type: str
        """
        allowed_values = ["HUMAN_APPROVAL_PERFORMED_ACTION", "FUNCTION_CALLING_PERFORMED_ACTION"]
        if not value_allowed_none_or_none_sentinel(performed_action_type, allowed_values):
            raise ValueError(
                f"Invalid value for `performed_action_type`, must be None or one of {allowed_values}"
            )
        self._performed_action_type = performed_action_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
