# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Annotation(object):
    """
    An annotation attached to the assistant's message, used to represent additional
    metadata such as citations.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Annotation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this Annotation.
        :type type: str

        :param url_citation:
            The value to assign to the url_citation property of this Annotation.
        :type url_citation: oci.generative_ai_inference.models.UrlCitation

        """
        self.swagger_types = {
            'type': 'str',
            'url_citation': 'UrlCitation'
        }
        self.attribute_map = {
            'type': 'type',
            'url_citation': 'urlCitation'
        }
        self._type = None
        self._url_citation = None

    @property
    def type(self):
        """
        Gets the type of this Annotation.
        Type of annotation. For web search citations, this is `url_citation`.


        :return: The type of this Annotation.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Annotation.
        Type of annotation. For web search citations, this is `url_citation`.


        :param type: The type of this Annotation.
        :type: str
        """
        self._type = type

    @property
    def url_citation(self):
        """
        Gets the url_citation of this Annotation.

        :return: The url_citation of this Annotation.
        :rtype: oci.generative_ai_inference.models.UrlCitation
        """
        return self._url_citation

    @url_citation.setter
    def url_citation(self, url_citation):
        """
        Sets the url_citation of this Annotation.

        :param url_citation: The url_citation of this Annotation.
        :type: oci.generative_ai_inference.models.UrlCitation
        """
        self._url_citation = url_citation

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
