# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CategoryScore(object):
    """
    A category with its score.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CategoryScore object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CategoryScore.
        :type name: str

        :param score:
            The value to assign to the score property of this CategoryScore.
        :type score: float

        """
        self.swagger_types = {
            'name': 'str',
            'score': 'float'
        }
        self.attribute_map = {
            'name': 'name',
            'score': 'score'
        }
        self._name = None
        self._score = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CategoryScore.
        The name of the category.


        :return: The name of this CategoryScore.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CategoryScore.
        The name of the category.


        :param name: The name of this CategoryScore.
        :type: str
        """
        self._name = name

    @property
    def score(self):
        """
        **[Required]** Gets the score of this CategoryScore.
        The score of the category.


        :return: The score of this CategoryScore.
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this CategoryScore.
        The score of the category.


        :param score: The score of this CategoryScore.
        :type: float
        """
        self._score = score

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
