# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GroundingSupport(object):
    """
    chunk to connect model response text to the source in groundingChunk
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GroundingSupport object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param segment:
            The value to assign to the segment property of this GroundingSupport.
        :type segment: oci.generative_ai_inference.models.GroundingSupportSegment

        :param grounding_chunk_indices:
            The value to assign to the grounding_chunk_indices property of this GroundingSupport.
        :type grounding_chunk_indices: list[int]

        """
        self.swagger_types = {
            'segment': 'GroundingSupportSegment',
            'grounding_chunk_indices': 'list[int]'
        }
        self.attribute_map = {
            'segment': 'segment',
            'grounding_chunk_indices': 'groundingChunkIndices'
        }
        self._segment = None
        self._grounding_chunk_indices = None

    @property
    def segment(self):
        """
        Gets the segment of this GroundingSupport.

        :return: The segment of this GroundingSupport.
        :rtype: oci.generative_ai_inference.models.GroundingSupportSegment
        """
        return self._segment

    @segment.setter
    def segment(self, segment):
        """
        Sets the segment of this GroundingSupport.

        :param segment: The segment of this GroundingSupport.
        :type: oci.generative_ai_inference.models.GroundingSupportSegment
        """
        self._segment = segment

    @property
    def grounding_chunk_indices(self):
        """
        Gets the grounding_chunk_indices of this GroundingSupport.
        The grounding chunk indices


        :return: The grounding_chunk_indices of this GroundingSupport.
        :rtype: list[int]
        """
        return self._grounding_chunk_indices

    @grounding_chunk_indices.setter
    def grounding_chunk_indices(self, grounding_chunk_indices):
        """
        Sets the grounding_chunk_indices of this GroundingSupport.
        The grounding chunk indices


        :param grounding_chunk_indices: The grounding_chunk_indices of this GroundingSupport.
        :type: list[int]
        """
        self._grounding_chunk_indices = grounding_chunk_indices

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
