# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230301


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DedicatedShardOrCatalogEncryptionKeyDetails(object):
    """
    Details of encryption key to be used to encrypt data for shards and catalog for sharded database. For system-defined
    sharding type, all shards have to use same encryptionKeyDetails. For system-defined sharding, if encryptionKeyDetails
    are not specified for catalog, then Oracle managed key will be used for catalog.
    For user-defined sharding type, if encryptionKeyDetails are not provided for any shard or catalog, then Oracle managed
    key will be used for such shard or catalog. For system-defined or user-defined sharding type, if the shard or catalog
    has a peer in region other than primary shard or catalog region, then make sure to provide virtual vault for such shard
    or catalog, which is also replicated to peer region (the region where peer or standby shard or catalog exists).
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DedicatedShardOrCatalogEncryptionKeyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vault_id:
            The value to assign to the vault_id property of this DedicatedShardOrCatalogEncryptionKeyDetails.
        :type vault_id: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this DedicatedShardOrCatalogEncryptionKeyDetails.
        :type kms_key_id: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this DedicatedShardOrCatalogEncryptionKeyDetails.
        :type kms_key_version_id: str

        """
        self.swagger_types = {
            'vault_id': 'str',
            'kms_key_id': 'str',
            'kms_key_version_id': 'str'
        }
        self.attribute_map = {
            'vault_id': 'vaultId',
            'kms_key_id': 'kmsKeyId',
            'kms_key_version_id': 'kmsKeyVersionId'
        }
        self._vault_id = None
        self._kms_key_id = None
        self._kms_key_version_id = None

    @property
    def vault_id(self):
        """
        **[Required]** Gets the vault_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        The `OCID`__ of the vault in customer tenancy where KMS key is present.
        For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only,
        which is also replicated in the region of standby shard.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vault_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        The `OCID`__ of the vault in customer tenancy where KMS key is present.
        For shard or catalog with cross-region data guard enabled, user needs to make sure to provide virtual private vault only,
        which is also replicated in the region of standby shard.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vault_id: The vault_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def kms_key_id(self):
        """
        **[Required]** Gets the kms_key_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        The `OCID`__ of the KMS key in vault identified by vaultId in customer tenancy
        that is used as the master encryption key.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The kms_key_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        The `OCID`__ of the KMS key in vault identified by vaultId in customer tenancy
        that is used as the master encryption key.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param kms_key_id: The kms_key_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def kms_key_version_id(self):
        """
        Gets the kms_key_version_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        The `OCID`__ of the KMS key version for key identified by kmsKeyId
        that is used in data encryption (TDE) operations.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The kms_key_version_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        :rtype: str
        """
        return self._kms_key_version_id

    @kms_key_version_id.setter
    def kms_key_version_id(self, kms_key_version_id):
        """
        Sets the kms_key_version_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        The `OCID`__ of the KMS key version for key identified by kmsKeyId
        that is used in data encryption (TDE) operations.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param kms_key_version_id: The kms_key_version_id of this DedicatedShardOrCatalogEncryptionKeyDetails.
        :type: str
        """
        self._kms_key_version_id = kms_key_version_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
