# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .iceberg_catalog import IcebergCatalog
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GlueIcebergCatalog(IcebergCatalog):
    """
    Represents a Glue catalog used in the Iceberg connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GlueIcebergCatalog object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.GlueIcebergCatalog.catalog_type` attribute
        of this class is ``GLUE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param catalog_type:
            The value to assign to the catalog_type property of this GlueIcebergCatalog.
            Allowed values for this property are: "GLUE", "HADOOP", "NESSIE", "POLARIS", "REST"
        :type catalog_type: str

        :param glue_id:
            The value to assign to the glue_id property of this GlueIcebergCatalog.
        :type glue_id: str

        """
        self.swagger_types = {
            'catalog_type': 'str',
            'glue_id': 'str'
        }
        self.attribute_map = {
            'catalog_type': 'catalogType',
            'glue_id': 'glueId'
        }
        self._catalog_type = None
        self._glue_id = None
        self._catalog_type = 'GLUE'

    @property
    def glue_id(self):
        """
        **[Required]** Gets the glue_id of this GlueIcebergCatalog.
        The AWS Glue Catalog ID where Iceberg tables are registered.


        :return: The glue_id of this GlueIcebergCatalog.
        :rtype: str
        """
        return self._glue_id

    @glue_id.setter
    def glue_id(self, glue_id):
        """
        Sets the glue_id of this GlueIcebergCatalog.
        The AWS Glue Catalog ID where Iceberg tables are registered.


        :param glue_id: The glue_id of this GlueIcebergCatalog.
        :type: str
        """
        self._glue_id = glue_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
