# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Setting(object):
    """
    Settings schema
    """

    #: A constant which can be used with the idcs_prevented_operations property of a Setting.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a Setting.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a Setting.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    #: A constant which can be used with the re_auth_factor property of a Setting.
    #: This constant has a value of "password"
    RE_AUTH_FACTOR_PASSWORD = "password"

    #: A constant which can be used with the csr_access property of a Setting.
    #: This constant has a value of "readOnly"
    CSR_ACCESS_READ_ONLY = "readOnly"

    #: A constant which can be used with the csr_access property of a Setting.
    #: This constant has a value of "readWrite"
    CSR_ACCESS_READ_WRITE = "readWrite"

    #: A constant which can be used with the csr_access property of a Setting.
    #: This constant has a value of "none"
    CSR_ACCESS_NONE = "none"

    #: A constant which can be used with the default_trust_scope property of a Setting.
    #: This constant has a value of "Explicit"
    DEFAULT_TRUST_SCOPE_EXPLICIT = "Explicit"

    #: A constant which can be used with the default_trust_scope property of a Setting.
    #: This constant has a value of "Account"
    DEFAULT_TRUST_SCOPE_ACCOUNT = "Account"

    #: A constant which can be used with the default_trust_scope property of a Setting.
    #: This constant has a value of "Tags"
    DEFAULT_TRUST_SCOPE_TAGS = "Tags"

    def __init__(self, **kwargs):
        """
        Initializes a new Setting object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Setting.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this Setting.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this Setting.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this Setting.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this Setting.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this Setting.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this Setting.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this Setting.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this Setting.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this Setting.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this Setting.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this Setting.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this Setting.
        :type tenancy_ocid: str

        :param external_id:
            The value to assign to the external_id property of this Setting.
        :type external_id: str

        :param contact_emails:
            The value to assign to the contact_emails property of this Setting.
        :type contact_emails: list[str]

        :param custom_branding:
            The value to assign to the custom_branding property of this Setting.
        :type custom_branding: bool

        :param preferred_language:
            The value to assign to the preferred_language property of this Setting.
        :type preferred_language: str

        :param timezone:
            The value to assign to the timezone property of this Setting.
        :type timezone: str

        :param diagnostic_record_for_search_identifies_returned_resources:
            The value to assign to the diagnostic_record_for_search_identifies_returned_resources property of this Setting.
        :type diagnostic_record_for_search_identifies_returned_resources: bool

        :param re_auth_when_changing_my_authentication_factors:
            The value to assign to the re_auth_when_changing_my_authentication_factors property of this Setting.
        :type re_auth_when_changing_my_authentication_factors: bool

        :param re_auth_factor:
            The value to assign to the re_auth_factor property of this Setting.
            Allowed values for items in this list are: "password", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type re_auth_factor: list[str]

        :param locale:
            The value to assign to the locale property of this Setting.
        :type locale: str

        :param csr_access:
            The value to assign to the csr_access property of this Setting.
            Allowed values for this property are: "readOnly", "readWrite", "none", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type csr_access: str

        :param signing_cert_public_access:
            The value to assign to the signing_cert_public_access property of this Setting.
        :type signing_cert_public_access: bool

        :param sub_mapping_attr:
            The value to assign to the sub_mapping_attr property of this Setting.
        :type sub_mapping_attr: str

        :param account_always_trust_scope:
            The value to assign to the account_always_trust_scope property of this Setting.
        :type account_always_trust_scope: bool

        :param default_trust_scope:
            The value to assign to the default_trust_scope property of this Setting.
            Allowed values for this property are: "Explicit", "Account", "Tags", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type default_trust_scope: str

        :param issuer:
            The value to assign to the issuer property of this Setting.
        :type issuer: str

        :param prev_issuer:
            The value to assign to the prev_issuer property of this Setting.
        :type prev_issuer: str

        :param diagnostic_level:
            The value to assign to the diagnostic_level property of this Setting.
        :type diagnostic_level: int

        :param diagnostic_tracing_upto:
            The value to assign to the diagnostic_tracing_upto property of this Setting.
        :type diagnostic_tracing_upto: str

        :param allowed_domains:
            The value to assign to the allowed_domains property of this Setting.
        :type allowed_domains: list[str]

        :param enable_terms_of_use:
            The value to assign to the enable_terms_of_use property of this Setting.
        :type enable_terms_of_use: bool

        :param terms_of_use_url:
            The value to assign to the terms_of_use_url property of this Setting.
        :type terms_of_use_url: str

        :param privacy_policy_url:
            The value to assign to the privacy_policy_url property of this Setting.
        :type privacy_policy_url: str

        :param migration_status:
            The value to assign to the migration_status property of this Setting.
        :type migration_status: str

        :param on_premises_provisioning:
            The value to assign to the on_premises_provisioning property of this Setting.
        :type on_premises_provisioning: bool

        :param allowed_forgot_password_flow_return_urls:
            The value to assign to the allowed_forgot_password_flow_return_urls property of this Setting.
        :type allowed_forgot_password_flow_return_urls: list[str]

        :param allowed_notification_redirect_urls:
            The value to assign to the allowed_notification_redirect_urls property of this Setting.
        :type allowed_notification_redirect_urls: list[str]

        :param audit_event_retention_period:
            The value to assign to the audit_event_retention_period property of this Setting.
        :type audit_event_retention_period: int

        :param is_hosted_page:
            The value to assign to the is_hosted_page property of this Setting.
        :type is_hosted_page: bool

        :param custom_html_location:
            The value to assign to the custom_html_location property of this Setting.
        :type custom_html_location: str

        :param custom_css_location:
            The value to assign to the custom_css_location property of this Setting.
        :type custom_css_location: str

        :param custom_translation:
            The value to assign to the custom_translation property of this Setting.
        :type custom_translation: str

        :param cloud_account_name:
            The value to assign to the cloud_account_name property of this Setting.
        :type cloud_account_name: str

        :param cloud_migration_url_enabled:
            The value to assign to the cloud_migration_url_enabled property of this Setting.
        :type cloud_migration_url_enabled: bool

        :param cloud_migration_custom_url:
            The value to assign to the cloud_migration_custom_url property of this Setting.
        :type cloud_migration_custom_url: str

        :param service_admin_cannot_list_other_users:
            The value to assign to the service_admin_cannot_list_other_users property of this Setting.
        :type service_admin_cannot_list_other_users: bool

        :param max_no_of_app_role_members_to_return:
            The value to assign to the max_no_of_app_role_members_to_return property of this Setting.
        :type max_no_of_app_role_members_to_return: int

        :param max_no_of_app_cmva_to_return:
            The value to assign to the max_no_of_app_cmva_to_return property of this Setting.
        :type max_no_of_app_cmva_to_return: int

        :param iam_upst_session_expiry:
            The value to assign to the iam_upst_session_expiry property of this Setting.
        :type iam_upst_session_expiry: int

        :param cloud_gate_cors_settings:
            The value to assign to the cloud_gate_cors_settings property of this Setting.
        :type cloud_gate_cors_settings: oci.identity_domains.models.SettingsCloudGateCorsSettings

        :param certificate_validation:
            The value to assign to the certificate_validation property of this Setting.
        :type certificate_validation: oci.identity_domains.models.SettingsCertificateValidation

        :param tenant_custom_claims:
            The value to assign to the tenant_custom_claims property of this Setting.
        :type tenant_custom_claims: list[oci.identity_domains.models.SettingsTenantCustomClaims]

        :param purge_configs:
            The value to assign to the purge_configs property of this Setting.
        :type purge_configs: list[oci.identity_domains.models.SettingsPurgeConfigs]

        :param default_company_names:
            The value to assign to the default_company_names property of this Setting.
        :type default_company_names: list[oci.identity_domains.models.SettingsDefaultCompanyNames]

        :param default_login_texts:
            The value to assign to the default_login_texts property of this Setting.
        :type default_login_texts: list[oci.identity_domains.models.SettingsDefaultLoginTexts]

        :param default_images:
            The value to assign to the default_images property of this Setting.
        :type default_images: list[oci.identity_domains.models.SettingsDefaultImages]

        :param company_names:
            The value to assign to the company_names property of this Setting.
        :type company_names: list[oci.identity_domains.models.SettingsCompanyNames]

        :param login_texts:
            The value to assign to the login_texts property of this Setting.
        :type login_texts: list[oci.identity_domains.models.SettingsLoginTexts]

        :param images:
            The value to assign to the images property of this Setting.
        :type images: list[oci.identity_domains.models.SettingsImages]

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'external_id': 'str',
            'contact_emails': 'list[str]',
            'custom_branding': 'bool',
            'preferred_language': 'str',
            'timezone': 'str',
            'diagnostic_record_for_search_identifies_returned_resources': 'bool',
            're_auth_when_changing_my_authentication_factors': 'bool',
            're_auth_factor': 'list[str]',
            'locale': 'str',
            'csr_access': 'str',
            'signing_cert_public_access': 'bool',
            'sub_mapping_attr': 'str',
            'account_always_trust_scope': 'bool',
            'default_trust_scope': 'str',
            'issuer': 'str',
            'prev_issuer': 'str',
            'diagnostic_level': 'int',
            'diagnostic_tracing_upto': 'str',
            'allowed_domains': 'list[str]',
            'enable_terms_of_use': 'bool',
            'terms_of_use_url': 'str',
            'privacy_policy_url': 'str',
            'migration_status': 'str',
            'on_premises_provisioning': 'bool',
            'allowed_forgot_password_flow_return_urls': 'list[str]',
            'allowed_notification_redirect_urls': 'list[str]',
            'audit_event_retention_period': 'int',
            'is_hosted_page': 'bool',
            'custom_html_location': 'str',
            'custom_css_location': 'str',
            'custom_translation': 'str',
            'cloud_account_name': 'str',
            'cloud_migration_url_enabled': 'bool',
            'cloud_migration_custom_url': 'str',
            'service_admin_cannot_list_other_users': 'bool',
            'max_no_of_app_role_members_to_return': 'int',
            'max_no_of_app_cmva_to_return': 'int',
            'iam_upst_session_expiry': 'int',
            'cloud_gate_cors_settings': 'SettingsCloudGateCorsSettings',
            'certificate_validation': 'SettingsCertificateValidation',
            'tenant_custom_claims': 'list[SettingsTenantCustomClaims]',
            'purge_configs': 'list[SettingsPurgeConfigs]',
            'default_company_names': 'list[SettingsDefaultCompanyNames]',
            'default_login_texts': 'list[SettingsDefaultLoginTexts]',
            'default_images': 'list[SettingsDefaultImages]',
            'company_names': 'list[SettingsCompanyNames]',
            'login_texts': 'list[SettingsLoginTexts]',
            'images': 'list[SettingsImages]'
        }
        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'external_id': 'externalId',
            'contact_emails': 'contactEmails',
            'custom_branding': 'customBranding',
            'preferred_language': 'preferredLanguage',
            'timezone': 'timezone',
            'diagnostic_record_for_search_identifies_returned_resources': 'diagnosticRecordForSearchIdentifiesReturnedResources',
            're_auth_when_changing_my_authentication_factors': 'reAuthWhenChangingMyAuthenticationFactors',
            're_auth_factor': 'reAuthFactor',
            'locale': 'locale',
            'csr_access': 'csrAccess',
            'signing_cert_public_access': 'signingCertPublicAccess',
            'sub_mapping_attr': 'subMappingAttr',
            'account_always_trust_scope': 'accountAlwaysTrustScope',
            'default_trust_scope': 'defaultTrustScope',
            'issuer': 'issuer',
            'prev_issuer': 'prevIssuer',
            'diagnostic_level': 'diagnosticLevel',
            'diagnostic_tracing_upto': 'diagnosticTracingUpto',
            'allowed_domains': 'allowedDomains',
            'enable_terms_of_use': 'enableTermsOfUse',
            'terms_of_use_url': 'termsOfUseUrl',
            'privacy_policy_url': 'privacyPolicyUrl',
            'migration_status': 'migrationStatus',
            'on_premises_provisioning': 'onPremisesProvisioning',
            'allowed_forgot_password_flow_return_urls': 'allowedForgotPasswordFlowReturnUrls',
            'allowed_notification_redirect_urls': 'allowedNotificationRedirectUrls',
            'audit_event_retention_period': 'auditEventRetentionPeriod',
            'is_hosted_page': 'isHostedPage',
            'custom_html_location': 'customHtmlLocation',
            'custom_css_location': 'customCssLocation',
            'custom_translation': 'customTranslation',
            'cloud_account_name': 'cloudAccountName',
            'cloud_migration_url_enabled': 'cloudMigrationUrlEnabled',
            'cloud_migration_custom_url': 'cloudMigrationCustomUrl',
            'service_admin_cannot_list_other_users': 'serviceAdminCannotListOtherUsers',
            'max_no_of_app_role_members_to_return': 'maxNoOfAppRoleMembersToReturn',
            'max_no_of_app_cmva_to_return': 'maxNoOfAppCMVAToReturn',
            'iam_upst_session_expiry': 'iamUpstSessionExpiry',
            'cloud_gate_cors_settings': 'cloudGateCorsSettings',
            'certificate_validation': 'certificateValidation',
            'tenant_custom_claims': 'tenantCustomClaims',
            'purge_configs': 'purgeConfigs',
            'default_company_names': 'defaultCompanyNames',
            'default_login_texts': 'defaultLoginTexts',
            'default_images': 'defaultImages',
            'company_names': 'companyNames',
            'login_texts': 'loginTexts',
            'images': 'images'
        }
        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._external_id = None
        self._contact_emails = None
        self._custom_branding = None
        self._preferred_language = None
        self._timezone = None
        self._diagnostic_record_for_search_identifies_returned_resources = None
        self._re_auth_when_changing_my_authentication_factors = None
        self._re_auth_factor = None
        self._locale = None
        self._csr_access = None
        self._signing_cert_public_access = None
        self._sub_mapping_attr = None
        self._account_always_trust_scope = None
        self._default_trust_scope = None
        self._issuer = None
        self._prev_issuer = None
        self._diagnostic_level = None
        self._diagnostic_tracing_upto = None
        self._allowed_domains = None
        self._enable_terms_of_use = None
        self._terms_of_use_url = None
        self._privacy_policy_url = None
        self._migration_status = None
        self._on_premises_provisioning = None
        self._allowed_forgot_password_flow_return_urls = None
        self._allowed_notification_redirect_urls = None
        self._audit_event_retention_period = None
        self._is_hosted_page = None
        self._custom_html_location = None
        self._custom_css_location = None
        self._custom_translation = None
        self._cloud_account_name = None
        self._cloud_migration_url_enabled = None
        self._cloud_migration_custom_url = None
        self._service_admin_cannot_list_other_users = None
        self._max_no_of_app_role_members_to_return = None
        self._max_no_of_app_cmva_to_return = None
        self._iam_upst_session_expiry = None
        self._cloud_gate_cors_settings = None
        self._certificate_validation = None
        self._tenant_custom_claims = None
        self._purge_configs = None
        self._default_company_names = None
        self._default_login_texts = None
        self._default_images = None
        self._company_names = None
        self._login_texts = None
        self._images = None

    @property
    def id(self):
        """
        Gets the id of this Setting.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this Setting.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Setting.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this Setting.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this Setting.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this Setting.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this Setting.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this Setting.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this Setting.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this Setting.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this Setting.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this Setting.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this Setting.

        :return: The meta of this Setting.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this Setting.

        :param meta: The meta of this Setting.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this Setting.

        :return: The idcs_created_by of this Setting.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this Setting.

        :param idcs_created_by: The idcs_created_by of this Setting.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this Setting.

        :return: The idcs_last_modified_by of this Setting.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this Setting.

        :param idcs_last_modified_by: The idcs_last_modified_by of this Setting.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this Setting.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this Setting.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this Setting.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this Setting.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this Setting.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this Setting.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this Setting.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this Setting.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this Setting.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this Setting.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this Setting.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this Setting.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this Setting.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this Setting.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this Setting.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this Setting.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this Setting.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this Setting.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this Setting.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this Setting.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this Setting.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this Setting.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this Setting.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this Setting.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this Setting.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this Setting.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this Setting.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this Setting.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def external_id(self):
        """
        Gets the external_id of this Setting.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The external_id of this Setting.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this Setting.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param external_id: The external_id of this Setting.
        :type: str
        """
        self._external_id = external_id

    @property
    def contact_emails(self):
        """
        Gets the contact_emails of this Setting.
        Contact emails used to notify tenants. Can be one or more user or group alias emails.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The contact_emails of this Setting.
        :rtype: list[str]
        """
        return self._contact_emails

    @contact_emails.setter
    def contact_emails(self, contact_emails):
        """
        Sets the contact_emails of this Setting.
        Contact emails used to notify tenants. Can be one or more user or group alias emails.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param contact_emails: The contact_emails of this Setting.
        :type: list[str]
        """
        self._contact_emails = contact_emails

    @property
    def custom_branding(self):
        """
        Gets the custom_branding of this Setting.
        Indicates if the branding is default or custom

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The custom_branding of this Setting.
        :rtype: bool
        """
        return self._custom_branding

    @custom_branding.setter
    def custom_branding(self, custom_branding):
        """
        Sets the custom_branding of this Setting.
        Indicates if the branding is default or custom

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param custom_branding: The custom_branding of this Setting.
        :type: bool
        """
        self._custom_branding = custom_branding

    @property
    def preferred_language(self):
        """
        Gets the preferred_language of this Setting.
        Preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCanonicalValueSourceFilter: attrName eq \"languages\" and attrValues.value eq \"$(preferredLanguage)\"
         - idcsCanonicalValueSourceResourceType: AllowedValue
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The preferred_language of this Setting.
        :rtype: str
        """
        return self._preferred_language

    @preferred_language.setter
    def preferred_language(self, preferred_language):
        """
        Sets the preferred_language of this Setting.
        Preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCanonicalValueSourceFilter: attrName eq \"languages\" and attrValues.value eq \"$(preferredLanguage)\"
         - idcsCanonicalValueSourceResourceType: AllowedValue
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param preferred_language: The preferred_language of this Setting.
        :type: str
        """
        self._preferred_language = preferred_language

    @property
    def timezone(self):
        """
        Gets the timezone of this Setting.
        User's timezone

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCanonicalValueSourceFilter: attrName eq \"timezones\" and attrValues.value eq \"$(timezone)\"
         - idcsCanonicalValueSourceResourceType: AllowedValue
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The timezone of this Setting.
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """
        Sets the timezone of this Setting.
        User's timezone

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCanonicalValueSourceFilter: attrName eq \"timezones\" and attrValues.value eq \"$(timezone)\"
         - idcsCanonicalValueSourceResourceType: AllowedValue
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param timezone: The timezone of this Setting.
        :type: str
        """
        self._timezone = timezone

    @property
    def diagnostic_record_for_search_identifies_returned_resources(self):
        """
        Gets the diagnostic_record_for_search_identifies_returned_resources of this Setting.
        Controls whether DiagnosticRecords for external search-operations (against SCIM resource-types in the Admin service) identify returned resources.  If true, indicates that for each successful external search-operation at least one DiagnosticRecord will include at least one identifier for each matching resource that is returned in that search-response.  If false, no DiagnosticRecord should be expected to identify returned resources for a search-operation.  The default value is false.

        **Added In:** 2011192329

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The diagnostic_record_for_search_identifies_returned_resources of this Setting.
        :rtype: bool
        """
        return self._diagnostic_record_for_search_identifies_returned_resources

    @diagnostic_record_for_search_identifies_returned_resources.setter
    def diagnostic_record_for_search_identifies_returned_resources(self, diagnostic_record_for_search_identifies_returned_resources):
        """
        Sets the diagnostic_record_for_search_identifies_returned_resources of this Setting.
        Controls whether DiagnosticRecords for external search-operations (against SCIM resource-types in the Admin service) identify returned resources.  If true, indicates that for each successful external search-operation at least one DiagnosticRecord will include at least one identifier for each matching resource that is returned in that search-response.  If false, no DiagnosticRecord should be expected to identify returned resources for a search-operation.  The default value is false.

        **Added In:** 2011192329

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param diagnostic_record_for_search_identifies_returned_resources: The diagnostic_record_for_search_identifies_returned_resources of this Setting.
        :type: bool
        """
        self._diagnostic_record_for_search_identifies_returned_resources = diagnostic_record_for_search_identifies_returned_resources

    @property
    def re_auth_when_changing_my_authentication_factors(self):
        """
        Gets the re_auth_when_changing_my_authentication_factors of this Setting.
        Specifies whether re-authentication is required or not when a user changes one of their security factors such as password or email. Default is true to ensure more secure behavior.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The re_auth_when_changing_my_authentication_factors of this Setting.
        :rtype: bool
        """
        return self._re_auth_when_changing_my_authentication_factors

    @re_auth_when_changing_my_authentication_factors.setter
    def re_auth_when_changing_my_authentication_factors(self, re_auth_when_changing_my_authentication_factors):
        """
        Sets the re_auth_when_changing_my_authentication_factors of this Setting.
        Specifies whether re-authentication is required or not when a user changes one of their security factors such as password or email. Default is true to ensure more secure behavior.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param re_auth_when_changing_my_authentication_factors: The re_auth_when_changing_my_authentication_factors of this Setting.
        :type: bool
        """
        self._re_auth_when_changing_my_authentication_factors = re_auth_when_changing_my_authentication_factors

    @property
    def re_auth_factor(self):
        """
        Gets the re_auth_factor of this Setting.
        If reAuthWhenChangingMyAuthenticationFactors is true (default), this attribute specifies which re-authentication factor to use. Allowed value is \\\"password\\\".

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string

        Allowed values for items in this list are: "password", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The re_auth_factor of this Setting.
        :rtype: list[str]
        """
        return self._re_auth_factor

    @re_auth_factor.setter
    def re_auth_factor(self, re_auth_factor):
        """
        Sets the re_auth_factor of this Setting.
        If reAuthWhenChangingMyAuthenticationFactors is true (default), this attribute specifies which re-authentication factor to use. Allowed value is \\\"password\\\".

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param re_auth_factor: The re_auth_factor of this Setting.
        :type: list[str]
        """
        allowed_values = ["password"]
        if re_auth_factor:
            re_auth_factor[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in re_auth_factor]
        self._re_auth_factor = re_auth_factor

    @property
    def locale(self):
        """
        Gets the locale of this Setting.
        Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCanonicalValueSourceFilter: attrName eq \"locales\" and attrValues.value eq \"$(locale)\"
         - idcsCanonicalValueSourceResourceType: AllowedValue
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The locale of this Setting.
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """
        Sets the locale of this Setting.
        Default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCanonicalValueSourceFilter: attrName eq \"locales\" and attrValues.value eq \"$(locale)\"
         - idcsCanonicalValueSourceResourceType: AllowedValue
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param locale: The locale of this Setting.
        :type: str
        """
        self._locale = locale

    @property
    def csr_access(self):
        """
        **[Required]** Gets the csr_access of this Setting.
        This value indicates whether Customer Service Representatives can login and have readOnly or readWrite access.  A value of 'none' means CSR cannot login to the services.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string

        Allowed values for this property are: "readOnly", "readWrite", "none", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The csr_access of this Setting.
        :rtype: str
        """
        return self._csr_access

    @csr_access.setter
    def csr_access(self, csr_access):
        """
        Sets the csr_access of this Setting.
        This value indicates whether Customer Service Representatives can login and have readOnly or readWrite access.  A value of 'none' means CSR cannot login to the services.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string


        :param csr_access: The csr_access of this Setting.
        :type: str
        """
        allowed_values = ["readOnly", "readWrite", "none"]
        if not value_allowed_none_or_none_sentinel(csr_access, allowed_values):
            csr_access = 'UNKNOWN_ENUM_VALUE'
        self._csr_access = csr_access

    @property
    def signing_cert_public_access(self):
        """
        Gets the signing_cert_public_access of this Setting.
        Indicates if access on SigningCert is allowed to public or not

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The signing_cert_public_access of this Setting.
        :rtype: bool
        """
        return self._signing_cert_public_access

    @signing_cert_public_access.setter
    def signing_cert_public_access(self, signing_cert_public_access):
        """
        Sets the signing_cert_public_access of this Setting.
        Indicates if access on SigningCert is allowed to public or not

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param signing_cert_public_access: The signing_cert_public_access of this Setting.
        :type: bool
        """
        self._signing_cert_public_access = signing_cert_public_access

    @property
    def sub_mapping_attr(self):
        """
        Gets the sub_mapping_attr of this Setting.
        **Added In:** 20.1.3

        **SCIM++ Properties:**
        - caseExact: false
        - multiValued: false
        - mutability: readWrite
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        Subject mapping user profile attribute. The input format should be SCIM compliant. This attribute should be of type String and multivalued to false.


        :return: The sub_mapping_attr of this Setting.
        :rtype: str
        """
        return self._sub_mapping_attr

    @sub_mapping_attr.setter
    def sub_mapping_attr(self, sub_mapping_attr):
        """
        Sets the sub_mapping_attr of this Setting.
        **Added In:** 20.1.3

        **SCIM++ Properties:**
        - caseExact: false
        - multiValued: false
        - mutability: readWrite
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        Subject mapping user profile attribute. The input format should be SCIM compliant. This attribute should be of type String and multivalued to false.


        :param sub_mapping_attr: The sub_mapping_attr of this Setting.
        :type: str
        """
        self._sub_mapping_attr = sub_mapping_attr

    @property
    def account_always_trust_scope(self):
        """
        Gets the account_always_trust_scope of this Setting.
        Indicates whether all the Apps in this customer tenancy should trust each other. A value of true overrides the 'defaultTrustScope' attribute here in Settings, as well as any App-specific 'trustScope' attribute, to force in effect 'trustScope=Account' for every App in this customer tenancy.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The account_always_trust_scope of this Setting.
        :rtype: bool
        """
        return self._account_always_trust_scope

    @account_always_trust_scope.setter
    def account_always_trust_scope(self, account_always_trust_scope):
        """
        Sets the account_always_trust_scope of this Setting.
        Indicates whether all the Apps in this customer tenancy should trust each other. A value of true overrides the 'defaultTrustScope' attribute here in Settings, as well as any App-specific 'trustScope' attribute, to force in effect 'trustScope=Account' for every App in this customer tenancy.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param account_always_trust_scope: The account_always_trust_scope of this Setting.
        :type: bool
        """
        self._account_always_trust_scope = account_always_trust_scope

    @property
    def default_trust_scope(self):
        """
        Gets the default_trust_scope of this Setting.
        **Deprecated Since: 18.3.6**

        **SCIM++ Properties:**
        - multiValued: false
        - mutability: readWrite
        - required: false
        - returned: default
        - type: string
        Indicates the default trust scope for all apps

        Allowed values for this property are: "Explicit", "Account", "Tags", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The default_trust_scope of this Setting.
        :rtype: str
        """
        return self._default_trust_scope

    @default_trust_scope.setter
    def default_trust_scope(self, default_trust_scope):
        """
        Sets the default_trust_scope of this Setting.
        **Deprecated Since: 18.3.6**

        **SCIM++ Properties:**
        - multiValued: false
        - mutability: readWrite
        - required: false
        - returned: default
        - type: string
        Indicates the default trust scope for all apps


        :param default_trust_scope: The default_trust_scope of this Setting.
        :type: str
        """
        allowed_values = ["Explicit", "Account", "Tags"]
        if not value_allowed_none_or_none_sentinel(default_trust_scope, allowed_values):
            default_trust_scope = 'UNKNOWN_ENUM_VALUE'
        self._default_trust_scope = default_trust_scope

    @property
    def issuer(self):
        """
        Gets the issuer of this Setting.
        Tenant issuer.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The issuer of this Setting.
        :rtype: str
        """
        return self._issuer

    @issuer.setter
    def issuer(self, issuer):
        """
        Sets the issuer of this Setting.
        Tenant issuer.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param issuer: The issuer of this Setting.
        :type: str
        """
        self._issuer = issuer

    @property
    def prev_issuer(self):
        """
        Gets the prev_issuer of this Setting.
        Previous Tenant issuer. This is an Oracle Identity Cloud Service internal attribute which is not meant to be directly modified by ID Admin. Even if the request body (Settings) contains this attribute, the actual value will be set according to the Oracle Identity Cloud Service internal logic rather than solely based on the value provided in the request payload.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The prev_issuer of this Setting.
        :rtype: str
        """
        return self._prev_issuer

    @prev_issuer.setter
    def prev_issuer(self, prev_issuer):
        """
        Sets the prev_issuer of this Setting.
        Previous Tenant issuer. This is an Oracle Identity Cloud Service internal attribute which is not meant to be directly modified by ID Admin. Even if the request body (Settings) contains this attribute, the actual value will be set according to the Oracle Identity Cloud Service internal logic rather than solely based on the value provided in the request payload.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param prev_issuer: The prev_issuer of this Setting.
        :type: str
        """
        self._prev_issuer = prev_issuer

    @property
    def diagnostic_level(self):
        """
        Gets the diagnostic_level of this Setting.
        The level of diagnostic logging that is currently in effect. A level of 0 (zero) indicates that diagnostic logging is disabled. A level of 1 (one) indicates that diagnostic logging is enabled.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The diagnostic_level of this Setting.
        :rtype: int
        """
        return self._diagnostic_level

    @diagnostic_level.setter
    def diagnostic_level(self, diagnostic_level):
        """
        Sets the diagnostic_level of this Setting.
        The level of diagnostic logging that is currently in effect. A level of 0 (zero) indicates that diagnostic logging is disabled. A level of 1 (one) indicates that diagnostic logging is enabled.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param diagnostic_level: The diagnostic_level of this Setting.
        :type: int
        """
        self._diagnostic_level = diagnostic_level

    @property
    def diagnostic_tracing_upto(self):
        """
        Gets the diagnostic_tracing_upto of this Setting.
        The end time up to which diagnostic recording is switched on

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: dateTime
         - uniqueness: none


        :return: The diagnostic_tracing_upto of this Setting.
        :rtype: str
        """
        return self._diagnostic_tracing_upto

    @diagnostic_tracing_upto.setter
    def diagnostic_tracing_upto(self, diagnostic_tracing_upto):
        """
        Sets the diagnostic_tracing_upto of this Setting.
        The end time up to which diagnostic recording is switched on

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: dateTime
         - uniqueness: none


        :param diagnostic_tracing_upto: The diagnostic_tracing_upto of this Setting.
        :type: str
        """
        self._diagnostic_tracing_upto = diagnostic_tracing_upto

    @property
    def allowed_domains(self):
        """
        Gets the allowed_domains of this Setting.
        One or more email domains allowed in a user's email field. If unassigned, any domain is allowed.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The allowed_domains of this Setting.
        :rtype: list[str]
        """
        return self._allowed_domains

    @allowed_domains.setter
    def allowed_domains(self, allowed_domains):
        """
        Sets the allowed_domains of this Setting.
        One or more email domains allowed in a user's email field. If unassigned, any domain is allowed.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param allowed_domains: The allowed_domains of this Setting.
        :type: list[str]
        """
        self._allowed_domains = allowed_domains

    @property
    def enable_terms_of_use(self):
        """
        Gets the enable_terms_of_use of this Setting.
        Indicates if Terms of Use is enabled in UI

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The enable_terms_of_use of this Setting.
        :rtype: bool
        """
        return self._enable_terms_of_use

    @enable_terms_of_use.setter
    def enable_terms_of_use(self, enable_terms_of_use):
        """
        Sets the enable_terms_of_use of this Setting.
        Indicates if Terms of Use is enabled in UI

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param enable_terms_of_use: The enable_terms_of_use of this Setting.
        :type: bool
        """
        self._enable_terms_of_use = enable_terms_of_use

    @property
    def terms_of_use_url(self):
        """
        Gets the terms_of_use_url of this Setting.
        Terms of Use URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The terms_of_use_url of this Setting.
        :rtype: str
        """
        return self._terms_of_use_url

    @terms_of_use_url.setter
    def terms_of_use_url(self, terms_of_use_url):
        """
        Sets the terms_of_use_url of this Setting.
        Terms of Use URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param terms_of_use_url: The terms_of_use_url of this Setting.
        :type: str
        """
        self._terms_of_use_url = terms_of_use_url

    @property
    def privacy_policy_url(self):
        """
        Gets the privacy_policy_url of this Setting.
        Privacy Policy URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The privacy_policy_url of this Setting.
        :rtype: str
        """
        return self._privacy_policy_url

    @privacy_policy_url.setter
    def privacy_policy_url(self, privacy_policy_url):
        """
        Sets the privacy_policy_url of this Setting.
        Privacy Policy URL

        **Added In:** 18.2.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param privacy_policy_url: The privacy_policy_url of this Setting.
        :type: str
        """
        self._privacy_policy_url = privacy_policy_url

    @property
    def migration_status(self):
        """
        Gets the migration_status of this Setting.
        Database Migration Status

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The migration_status of this Setting.
        :rtype: str
        """
        return self._migration_status

    @migration_status.setter
    def migration_status(self, migration_status):
        """
        Sets the migration_status of this Setting.
        Database Migration Status

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param migration_status: The migration_status of this Setting.
        :type: str
        """
        self._migration_status = migration_status

    @property
    def on_premises_provisioning(self):
        """
        Gets the on_premises_provisioning of this Setting.
        On-Premises provisioning feature toggle.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The on_premises_provisioning of this Setting.
        :rtype: bool
        """
        return self._on_premises_provisioning

    @on_premises_provisioning.setter
    def on_premises_provisioning(self, on_premises_provisioning):
        """
        Sets the on_premises_provisioning of this Setting.
        On-Premises provisioning feature toggle.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param on_premises_provisioning: The on_premises_provisioning of this Setting.
        :type: bool
        """
        self._on_premises_provisioning = on_premises_provisioning

    @property
    def allowed_forgot_password_flow_return_urls(self):
        """
        Gets the allowed_forgot_password_flow_return_urls of this Setting.
        If specified, indicates the set of Urls which can be returned to after successful forgot password flow

        **Added In:** 19.3.3

        **SCIM++ Properties:**
         - type: string
         - multiValued: true
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false


        :return: The allowed_forgot_password_flow_return_urls of this Setting.
        :rtype: list[str]
        """
        return self._allowed_forgot_password_flow_return_urls

    @allowed_forgot_password_flow_return_urls.setter
    def allowed_forgot_password_flow_return_urls(self, allowed_forgot_password_flow_return_urls):
        """
        Sets the allowed_forgot_password_flow_return_urls of this Setting.
        If specified, indicates the set of Urls which can be returned to after successful forgot password flow

        **Added In:** 19.3.3

        **SCIM++ Properties:**
         - type: string
         - multiValued: true
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false


        :param allowed_forgot_password_flow_return_urls: The allowed_forgot_password_flow_return_urls of this Setting.
        :type: list[str]
        """
        self._allowed_forgot_password_flow_return_urls = allowed_forgot_password_flow_return_urls

    @property
    def allowed_notification_redirect_urls(self):
        """
        Gets the allowed_notification_redirect_urls of this Setting.
        If specified, indicates the set of allowed notification redirect Urls which can be specified as the value of \\\"notificationRedirectUrl\\\" in the POST .../admin/v1/MePasswordResetRequestor request payload, which will then be included in the reset password email notification sent to a user as part of the forgot password / password reset flow.

        **Added In:** 2009041201

        **SCIM++ Properties:**
         - type: string
         - multiValued: true
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false


        :return: The allowed_notification_redirect_urls of this Setting.
        :rtype: list[str]
        """
        return self._allowed_notification_redirect_urls

    @allowed_notification_redirect_urls.setter
    def allowed_notification_redirect_urls(self, allowed_notification_redirect_urls):
        """
        Sets the allowed_notification_redirect_urls of this Setting.
        If specified, indicates the set of allowed notification redirect Urls which can be specified as the value of \\\"notificationRedirectUrl\\\" in the POST .../admin/v1/MePasswordResetRequestor request payload, which will then be included in the reset password email notification sent to a user as part of the forgot password / password reset flow.

        **Added In:** 2009041201

        **SCIM++ Properties:**
         - type: string
         - multiValued: true
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false


        :param allowed_notification_redirect_urls: The allowed_notification_redirect_urls of this Setting.
        :type: list[str]
        """
        self._allowed_notification_redirect_urls = allowed_notification_redirect_urls

    @property
    def audit_event_retention_period(self):
        """
        Gets the audit_event_retention_period of this Setting.
        Audit Event retention period. If set, overrides default of 30 days after which Audit Events will be purged

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The audit_event_retention_period of this Setting.
        :rtype: int
        """
        return self._audit_event_retention_period

    @audit_event_retention_period.setter
    def audit_event_retention_period(self, audit_event_retention_period):
        """
        Sets the audit_event_retention_period of this Setting.
        Audit Event retention period. If set, overrides default of 30 days after which Audit Events will be purged

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param audit_event_retention_period: The audit_event_retention_period of this Setting.
        :type: int
        """
        self._audit_event_retention_period = audit_event_retention_period

    @property
    def is_hosted_page(self):
        """
        Gets the is_hosted_page of this Setting.
        Indicates if 'hosted' option was selected

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The is_hosted_page of this Setting.
        :rtype: bool
        """
        return self._is_hosted_page

    @is_hosted_page.setter
    def is_hosted_page(self, is_hosted_page):
        """
        Sets the is_hosted_page of this Setting.
        Indicates if 'hosted' option was selected

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param is_hosted_page: The is_hosted_page of this Setting.
        :type: bool
        """
        self._is_hosted_page = is_hosted_page

    @property
    def custom_html_location(self):
        """
        Gets the custom_html_location of this Setting.
        Storage URL location where the sanitized custom html is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The custom_html_location of this Setting.
        :rtype: str
        """
        return self._custom_html_location

    @custom_html_location.setter
    def custom_html_location(self, custom_html_location):
        """
        Sets the custom_html_location of this Setting.
        Storage URL location where the sanitized custom html is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param custom_html_location: The custom_html_location of this Setting.
        :type: str
        """
        self._custom_html_location = custom_html_location

    @property
    def custom_css_location(self):
        """
        Gets the custom_css_location of this Setting.
        Storage URL location where the sanitized custom css is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The custom_css_location of this Setting.
        :rtype: str
        """
        return self._custom_css_location

    @custom_css_location.setter
    def custom_css_location(self, custom_css_location):
        """
        Sets the custom_css_location of this Setting.
        Storage URL location where the sanitized custom css is located

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param custom_css_location: The custom_css_location of this Setting.
        :type: str
        """
        self._custom_css_location = custom_css_location

    @property
    def custom_translation(self):
        """
        Gets the custom_translation of this Setting.
        Custom translations (JSON String)

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The custom_translation of this Setting.
        :rtype: str
        """
        return self._custom_translation

    @custom_translation.setter
    def custom_translation(self, custom_translation):
        """
        Sets the custom_translation of this Setting.
        Custom translations (JSON String)

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param custom_translation: The custom_translation of this Setting.
        :type: str
        """
        self._custom_translation = custom_translation

    @property
    def cloud_account_name(self):
        """
        Gets the cloud_account_name of this Setting.
        The attribute to store the cloud account name

        **Deprecated Since: 2011192329**

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The cloud_account_name of this Setting.
        :rtype: str
        """
        return self._cloud_account_name

    @cloud_account_name.setter
    def cloud_account_name(self, cloud_account_name):
        """
        Sets the cloud_account_name of this Setting.
        The attribute to store the cloud account name

        **Deprecated Since: 2011192329**

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param cloud_account_name: The cloud_account_name of this Setting.
        :type: str
        """
        self._cloud_account_name = cloud_account_name

    @property
    def cloud_migration_url_enabled(self):
        """
        Gets the cloud_migration_url_enabled of this Setting.
        CloudAccountMigration: Enable Custom SIM Migrator Url.

        **Added In:** 2012271618

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The cloud_migration_url_enabled of this Setting.
        :rtype: bool
        """
        return self._cloud_migration_url_enabled

    @cloud_migration_url_enabled.setter
    def cloud_migration_url_enabled(self, cloud_migration_url_enabled):
        """
        Sets the cloud_migration_url_enabled of this Setting.
        CloudAccountMigration: Enable Custom SIM Migrator Url.

        **Added In:** 2012271618

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param cloud_migration_url_enabled: The cloud_migration_url_enabled of this Setting.
        :type: bool
        """
        self._cloud_migration_url_enabled = cloud_migration_url_enabled

    @property
    def cloud_migration_custom_url(self):
        """
        Gets the cloud_migration_custom_url of this Setting.
        If specified, indicates the custom SIM Migrator Url which can be used while SIM to Oracle Identity Cloud Service CloudAccount Migration.

        **Added In:** 2012271618

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false


        :return: The cloud_migration_custom_url of this Setting.
        :rtype: str
        """
        return self._cloud_migration_custom_url

    @cloud_migration_custom_url.setter
    def cloud_migration_custom_url(self, cloud_migration_custom_url):
        """
        Sets the cloud_migration_custom_url of this Setting.
        If specified, indicates the custom SIM Migrator Url which can be used while SIM to Oracle Identity Cloud Service CloudAccount Migration.

        **Added In:** 2012271618

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false


        :param cloud_migration_custom_url: The cloud_migration_custom_url of this Setting.
        :type: str
        """
        self._cloud_migration_custom_url = cloud_migration_custom_url

    @property
    def service_admin_cannot_list_other_users(self):
        """
        Gets the service_admin_cannot_list_other_users of this Setting.
        By default, a service admin can list all users in stripe. If true, a service admin cannot list other users.

        **Added In:** 2108190438

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The service_admin_cannot_list_other_users of this Setting.
        :rtype: bool
        """
        return self._service_admin_cannot_list_other_users

    @service_admin_cannot_list_other_users.setter
    def service_admin_cannot_list_other_users(self, service_admin_cannot_list_other_users):
        """
        Sets the service_admin_cannot_list_other_users of this Setting.
        By default, a service admin can list all users in stripe. If true, a service admin cannot list other users.

        **Added In:** 2108190438

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param service_admin_cannot_list_other_users: The service_admin_cannot_list_other_users of this Setting.
        :type: bool
        """
        self._service_admin_cannot_list_other_users = service_admin_cannot_list_other_users

    @property
    def max_no_of_app_role_members_to_return(self):
        """
        Gets the max_no_of_app_role_members_to_return of this Setting.
        Limit the maximum return of members for an AppRole

        **Added In:** 2111112015

        **SCIM++ Properties:**
         - idcsMinValue: 0
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The max_no_of_app_role_members_to_return of this Setting.
        :rtype: int
        """
        return self._max_no_of_app_role_members_to_return

    @max_no_of_app_role_members_to_return.setter
    def max_no_of_app_role_members_to_return(self, max_no_of_app_role_members_to_return):
        """
        Sets the max_no_of_app_role_members_to_return of this Setting.
        Limit the maximum return of members for an AppRole

        **Added In:** 2111112015

        **SCIM++ Properties:**
         - idcsMinValue: 0
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param max_no_of_app_role_members_to_return: The max_no_of_app_role_members_to_return of this Setting.
        :type: int
        """
        self._max_no_of_app_role_members_to_return = max_no_of_app_role_members_to_return

    @property
    def max_no_of_app_cmva_to_return(self):
        """
        Gets the max_no_of_app_cmva_to_return of this Setting.
        Limit the maximum return of CMVA for an App

        **Added In:** 2111112015

        **SCIM++ Properties:**
         - idcsMinValue: 0
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The max_no_of_app_cmva_to_return of this Setting.
        :rtype: int
        """
        return self._max_no_of_app_cmva_to_return

    @max_no_of_app_cmva_to_return.setter
    def max_no_of_app_cmva_to_return(self, max_no_of_app_cmva_to_return):
        """
        Sets the max_no_of_app_cmva_to_return of this Setting.
        Limit the maximum return of CMVA for an App

        **Added In:** 2111112015

        **SCIM++ Properties:**
         - idcsMinValue: 0
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param max_no_of_app_cmva_to_return: The max_no_of_app_cmva_to_return of this Setting.
        :type: int
        """
        self._max_no_of_app_cmva_to_return = max_no_of_app_cmva_to_return

    @property
    def iam_upst_session_expiry(self):
        """
        Gets the iam_upst_session_expiry of this Setting.
        Maximum duration for IAM User Principal Session Token expiry

        **Added In:** 2307071836

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The iam_upst_session_expiry of this Setting.
        :rtype: int
        """
        return self._iam_upst_session_expiry

    @iam_upst_session_expiry.setter
    def iam_upst_session_expiry(self, iam_upst_session_expiry):
        """
        Sets the iam_upst_session_expiry of this Setting.
        Maximum duration for IAM User Principal Session Token expiry

        **Added In:** 2307071836

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param iam_upst_session_expiry: The iam_upst_session_expiry of this Setting.
        :type: int
        """
        self._iam_upst_session_expiry = iam_upst_session_expiry

    @property
    def cloud_gate_cors_settings(self):
        """
        Gets the cloud_gate_cors_settings of this Setting.

        :return: The cloud_gate_cors_settings of this Setting.
        :rtype: oci.identity_domains.models.SettingsCloudGateCorsSettings
        """
        return self._cloud_gate_cors_settings

    @cloud_gate_cors_settings.setter
    def cloud_gate_cors_settings(self, cloud_gate_cors_settings):
        """
        Sets the cloud_gate_cors_settings of this Setting.

        :param cloud_gate_cors_settings: The cloud_gate_cors_settings of this Setting.
        :type: oci.identity_domains.models.SettingsCloudGateCorsSettings
        """
        self._cloud_gate_cors_settings = cloud_gate_cors_settings

    @property
    def certificate_validation(self):
        """
        Gets the certificate_validation of this Setting.

        :return: The certificate_validation of this Setting.
        :rtype: oci.identity_domains.models.SettingsCertificateValidation
        """
        return self._certificate_validation

    @certificate_validation.setter
    def certificate_validation(self, certificate_validation):
        """
        Sets the certificate_validation of this Setting.

        :param certificate_validation: The certificate_validation of this Setting.
        :type: oci.identity_domains.models.SettingsCertificateValidation
        """
        self._certificate_validation = certificate_validation

    @property
    def tenant_custom_claims(self):
        """
        Gets the tenant_custom_claims of this Setting.
        Custom claims associated with the specific tenant

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The tenant_custom_claims of this Setting.
        :rtype: list[oci.identity_domains.models.SettingsTenantCustomClaims]
        """
        return self._tenant_custom_claims

    @tenant_custom_claims.setter
    def tenant_custom_claims(self, tenant_custom_claims):
        """
        Sets the tenant_custom_claims of this Setting.
        Custom claims associated with the specific tenant

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [name]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param tenant_custom_claims: The tenant_custom_claims of this Setting.
        :type: list[oci.identity_domains.models.SettingsTenantCustomClaims]
        """
        self._tenant_custom_claims = tenant_custom_claims

    @property
    def purge_configs(self):
        """
        Gets the purge_configs of this Setting.
        Purge Configs for different Resource Types

        **Deprecated Since: 19.1.6**

        **SCIM++ Properties:**
         - idcsCompositeKey: [resourceName]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The purge_configs of this Setting.
        :rtype: list[oci.identity_domains.models.SettingsPurgeConfigs]
        """
        return self._purge_configs

    @purge_configs.setter
    def purge_configs(self, purge_configs):
        """
        Sets the purge_configs of this Setting.
        Purge Configs for different Resource Types

        **Deprecated Since: 19.1.6**

        **SCIM++ Properties:**
         - idcsCompositeKey: [resourceName]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param purge_configs: The purge_configs of this Setting.
        :type: list[oci.identity_domains.models.SettingsPurgeConfigs]
        """
        self._purge_configs = purge_configs

    @property
    def default_company_names(self):
        """
        Gets the default_company_names of this Setting.
        Default name of the Company in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The default_company_names of this Setting.
        :rtype: list[oci.identity_domains.models.SettingsDefaultCompanyNames]
        """
        return self._default_company_names

    @default_company_names.setter
    def default_company_names(self, default_company_names):
        """
        Sets the default_company_names of this Setting.
        Default name of the Company in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param default_company_names: The default_company_names of this Setting.
        :type: list[oci.identity_domains.models.SettingsDefaultCompanyNames]
        """
        self._default_company_names = default_company_names

    @property
    def default_login_texts(self):
        """
        Gets the default_login_texts of this Setting.
        Default Login text in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The default_login_texts of this Setting.
        :rtype: list[oci.identity_domains.models.SettingsDefaultLoginTexts]
        """
        return self._default_login_texts

    @default_login_texts.setter
    def default_login_texts(self, default_login_texts):
        """
        Sets the default_login_texts of this Setting.
        Default Login text in different locales

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param default_login_texts: The default_login_texts of this Setting.
        :type: list[oci.identity_domains.models.SettingsDefaultLoginTexts]
        """
        self._default_login_texts = default_login_texts

    @property
    def default_images(self):
        """
        Gets the default_images of this Setting.
        References to various images

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [type]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :return: The default_images of this Setting.
        :rtype: list[oci.identity_domains.models.SettingsDefaultImages]
        """
        return self._default_images

    @default_images.setter
    def default_images(self, default_images):
        """
        Sets the default_images of this Setting.
        References to various images

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsCompositeKey: [type]
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: default
         - type: complex


        :param default_images: The default_images of this Setting.
        :type: list[oci.identity_domains.models.SettingsDefaultImages]
        """
        self._default_images = default_images

    @property
    def company_names(self):
        """
        Gets the company_names of this Setting.
        Name of the company in different locales

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The company_names of this Setting.
        :rtype: list[oci.identity_domains.models.SettingsCompanyNames]
        """
        return self._company_names

    @company_names.setter
    def company_names(self, company_names):
        """
        Sets the company_names of this Setting.
        Name of the company in different locales

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param company_names: The company_names of this Setting.
        :type: list[oci.identity_domains.models.SettingsCompanyNames]
        """
        self._company_names = company_names

    @property
    def login_texts(self):
        """
        Gets the login_texts of this Setting.
        Login text in different locales

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The login_texts of this Setting.
        :rtype: list[oci.identity_domains.models.SettingsLoginTexts]
        """
        return self._login_texts

    @login_texts.setter
    def login_texts(self, login_texts):
        """
        Sets the login_texts of this Setting.
        Login text in different locales

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param login_texts: The login_texts of this Setting.
        :type: list[oci.identity_domains.models.SettingsLoginTexts]
        """
        self._login_texts = login_texts

    @property
    def images(self):
        """
        Gets the images of this Setting.
        References to various images

        **SCIM++ Properties:**
         - idcsCompositeKey: [type]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The images of this Setting.
        :rtype: list[oci.identity_domains.models.SettingsImages]
        """
        return self._images

    @images.setter
    def images(self, images):
        """
        Sets the images of this Setting.
        References to various images

        **SCIM++ Properties:**
         - idcsCompositeKey: [type]
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param images: The images of this Setting.
        :type: list[oci.identity_domains.models.SettingsImages]
        """
        self._images = images

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
