# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecalledInfo(object):
    """
    This is the information about data recalled
    """

    #: A constant which can be used with the status property of a RecalledInfo.
    #: This constant has a value of "RECALLED"
    STATUS_RECALLED = "RECALLED"

    #: A constant which can be used with the status property of a RecalledInfo.
    #: This constant has a value of "PENDING"
    STATUS_PENDING = "PENDING"

    #: A constant which can be used with the status property of a RecalledInfo.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a RecalledInfo.
    #: This constant has a value of "PARTIAL_RECALLED"
    STATUS_PARTIAL_RECALLED = "PARTIAL_RECALLED"

    def __init__(self, **kwargs):
        """
        Initializes a new RecalledInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param status:
            The value to assign to the status property of this RecalledInfo.
            Allowed values for this property are: "RECALLED", "PENDING", "FAILED", "PARTIAL_RECALLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param purpose:
            The value to assign to the purpose property of this RecalledInfo.
        :type purpose: str

        :param query_string:
            The value to assign to the query_string property of this RecalledInfo.
        :type query_string: str

        :param log_sets:
            The value to assign to the log_sets property of this RecalledInfo.
        :type log_sets: str

        :param collection_id:
            The value to assign to the collection_id property of this RecalledInfo.
        :type collection_id: int

        :param time_recalled_data_started:
            The value to assign to the time_recalled_data_started property of this RecalledInfo.
        :type time_recalled_data_started: datetime

        :param time_recalled_data_ended:
            The value to assign to the time_recalled_data_ended property of this RecalledInfo.
        :type time_recalled_data_ended: datetime

        """
        self.swagger_types = {
            'status': 'str',
            'purpose': 'str',
            'query_string': 'str',
            'log_sets': 'str',
            'collection_id': 'int',
            'time_recalled_data_started': 'datetime',
            'time_recalled_data_ended': 'datetime'
        }
        self.attribute_map = {
            'status': 'status',
            'purpose': 'purpose',
            'query_string': 'queryString',
            'log_sets': 'logSets',
            'collection_id': 'collectionId',
            'time_recalled_data_started': 'timeRecalledDataStarted',
            'time_recalled_data_ended': 'timeRecalledDataEnded'
        }
        self._status = None
        self._purpose = None
        self._query_string = None
        self._log_sets = None
        self._collection_id = None
        self._time_recalled_data_started = None
        self._time_recalled_data_ended = None

    @property
    def status(self):
        """
        **[Required]** Gets the status of this RecalledInfo.
        This is the status of the recall

        Allowed values for this property are: "RECALLED", "PENDING", "FAILED", "PARTIAL_RECALLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this RecalledInfo.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this RecalledInfo.
        This is the status of the recall


        :param status: The status of this RecalledInfo.
        :type: str
        """
        allowed_values = ["RECALLED", "PENDING", "FAILED", "PARTIAL_RECALLED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def purpose(self):
        """
        **[Required]** Gets the purpose of this RecalledInfo.
        This is the purpose of the recall


        :return: The purpose of this RecalledInfo.
        :rtype: str
        """
        return self._purpose

    @purpose.setter
    def purpose(self, purpose):
        """
        Sets the purpose of this RecalledInfo.
        This is the purpose of the recall


        :param purpose: The purpose of this RecalledInfo.
        :type: str
        """
        self._purpose = purpose

    @property
    def query_string(self):
        """
        **[Required]** Gets the query_string of this RecalledInfo.
        This is the query associated with the recall


        :return: The query_string of this RecalledInfo.
        :rtype: str
        """
        return self._query_string

    @query_string.setter
    def query_string(self, query_string):
        """
        Sets the query_string of this RecalledInfo.
        This is the query associated with the recall


        :param query_string: The query_string of this RecalledInfo.
        :type: str
        """
        self._query_string = query_string

    @property
    def log_sets(self):
        """
        **[Required]** Gets the log_sets of this RecalledInfo.
        This is the list of logsets associated with the recall


        :return: The log_sets of this RecalledInfo.
        :rtype: str
        """
        return self._log_sets

    @log_sets.setter
    def log_sets(self, log_sets):
        """
        Sets the log_sets of this RecalledInfo.
        This is the list of logsets associated with the recall


        :param log_sets: The log_sets of this RecalledInfo.
        :type: str
        """
        self._log_sets = log_sets

    @property
    def collection_id(self):
        """
        **[Required]** Gets the collection_id of this RecalledInfo.
        This is the id for the recalled data collection


        :return: The collection_id of this RecalledInfo.
        :rtype: int
        """
        return self._collection_id

    @collection_id.setter
    def collection_id(self, collection_id):
        """
        Sets the collection_id of this RecalledInfo.
        This is the id for the recalled data collection


        :param collection_id: The collection_id of this RecalledInfo.
        :type: int
        """
        self._collection_id = collection_id

    @property
    def time_recalled_data_started(self):
        """
        **[Required]** Gets the time_recalled_data_started of this RecalledInfo.
        This is the recalled date start time


        :return: The time_recalled_data_started of this RecalledInfo.
        :rtype: datetime
        """
        return self._time_recalled_data_started

    @time_recalled_data_started.setter
    def time_recalled_data_started(self, time_recalled_data_started):
        """
        Sets the time_recalled_data_started of this RecalledInfo.
        This is the recalled date start time


        :param time_recalled_data_started: The time_recalled_data_started of this RecalledInfo.
        :type: datetime
        """
        self._time_recalled_data_started = time_recalled_data_started

    @property
    def time_recalled_data_ended(self):
        """
        **[Required]** Gets the time_recalled_data_ended of this RecalledInfo.
        This is the recalled data end time


        :return: The time_recalled_data_ended of this RecalledInfo.
        :rtype: datetime
        """
        return self._time_recalled_data_ended

    @time_recalled_data_ended.setter
    def time_recalled_data_ended(self, time_recalled_data_ended):
        """
        Sets the time_recalled_data_ended of this RecalledInfo.
        This is the recalled data end time


        :param time_recalled_data_ended: The time_recalled_data_ended of this RecalledInfo.
        :type: datetime
        """
        self._time_recalled_data_ended = time_recalled_data_ended

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
