# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdditionalFilter(object):
    """
    Additional filters for the product
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AdditionalFilter object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AdditionalFilter.
        :type name: str

        :param code:
            The value to assign to the code property of this AdditionalFilter.
        :type code: str

        :param usage_instructions:
            The value to assign to the usage_instructions property of this AdditionalFilter.
        :type usage_instructions: str

        :param is_multi_select:
            The value to assign to the is_multi_select property of this AdditionalFilter.
        :type is_multi_select: bool

        :param is_mandatory:
            The value to assign to the is_mandatory property of this AdditionalFilter.
        :type is_mandatory: bool

        :param properties:
            The value to assign to the properties property of this AdditionalFilter.
        :type properties: list[oci.marketplace_publisher.models.FilterProperty]

        """
        self.swagger_types = {
            'name': 'str',
            'code': 'str',
            'usage_instructions': 'str',
            'is_multi_select': 'bool',
            'is_mandatory': 'bool',
            'properties': 'list[FilterProperty]'
        }
        self.attribute_map = {
            'name': 'name',
            'code': 'code',
            'usage_instructions': 'usageInstructions',
            'is_multi_select': 'isMultiSelect',
            'is_mandatory': 'isMandatory',
            'properties': 'properties'
        }
        self._name = None
        self._code = None
        self._usage_instructions = None
        self._is_multi_select = None
        self._is_mandatory = None
        self._properties = None

    @property
    def name(self):
        """
        Gets the name of this AdditionalFilter.
        Filter name


        :return: The name of this AdditionalFilter.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AdditionalFilter.
        Filter name


        :param name: The name of this AdditionalFilter.
        :type: str
        """
        self._name = name

    @property
    def code(self):
        """
        Gets the code of this AdditionalFilter.
        Filter code


        :return: The code of this AdditionalFilter.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this AdditionalFilter.
        Filter code


        :param code: The code of this AdditionalFilter.
        :type: str
        """
        self._code = code

    @property
    def usage_instructions(self):
        """
        Gets the usage_instructions of this AdditionalFilter.
        Usage instructions for the properties


        :return: The usage_instructions of this AdditionalFilter.
        :rtype: str
        """
        return self._usage_instructions

    @usage_instructions.setter
    def usage_instructions(self, usage_instructions):
        """
        Sets the usage_instructions of this AdditionalFilter.
        Usage instructions for the properties


        :param usage_instructions: The usage_instructions of this AdditionalFilter.
        :type: str
        """
        self._usage_instructions = usage_instructions

    @property
    def is_multi_select(self):
        """
        Gets the is_multi_select of this AdditionalFilter.
        Is multiselect available for product code or not


        :return: The is_multi_select of this AdditionalFilter.
        :rtype: bool
        """
        return self._is_multi_select

    @is_multi_select.setter
    def is_multi_select(self, is_multi_select):
        """
        Sets the is_multi_select of this AdditionalFilter.
        Is multiselect available for product code or not


        :param is_multi_select: The is_multi_select of this AdditionalFilter.
        :type: bool
        """
        self._is_multi_select = is_multi_select

    @property
    def is_mandatory(self):
        """
        Gets the is_mandatory of this AdditionalFilter.
        Is the product code mandatory or not


        :return: The is_mandatory of this AdditionalFilter.
        :rtype: bool
        """
        return self._is_mandatory

    @is_mandatory.setter
    def is_mandatory(self, is_mandatory):
        """
        Sets the is_mandatory of this AdditionalFilter.
        Is the product code mandatory or not


        :param is_mandatory: The is_mandatory of this AdditionalFilter.
        :type: bool
        """
        self._is_mandatory = is_mandatory

    @property
    def properties(self):
        """
        Gets the properties of this AdditionalFilter.
        Additional filters attached to custom filter


        :return: The properties of this AdditionalFilter.
        :rtype: list[oci.marketplace_publisher.models.FilterProperty]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this AdditionalFilter.
        Additional filters attached to custom filter


        :param properties: The properties of this AdditionalFilter.
        :type: list[oci.marketplace_publisher.models.FilterProperty]
        """
        self._properties = properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
