# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201

from .listing_revision import ListingRevision
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciListingRevision(ListingRevision):
    """
    Listing revision details for listings
    """

    #: A constant which can be used with the pricing_type property of a OciListingRevision.
    #: This constant has a value of "FREE"
    PRICING_TYPE_FREE = "FREE"

    #: A constant which can be used with the pricing_type property of a OciListingRevision.
    #: This constant has a value of "BYOL"
    PRICING_TYPE_BYOL = "BYOL"

    #: A constant which can be used with the pricing_type property of a OciListingRevision.
    #: This constant has a value of "PAYGO"
    PRICING_TYPE_PAYGO = "PAYGO"

    def __init__(self, **kwargs):
        """
        Initializes a new OciListingRevision object with values from keyword arguments. The default value of the :py:attr:`~oci.marketplace_publisher.models.OciListingRevision.listing_type` attribute
        of this class is ``OCI_APPLICATION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OciListingRevision.
        :type id: str

        :param listing_id:
            The value to assign to the listing_id property of this OciListingRevision.
        :type listing_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OciListingRevision.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this OciListingRevision.
        :type display_name: str

        :param revision_number:
            The value to assign to the revision_number property of this OciListingRevision.
        :type revision_number: str

        :param headline:
            The value to assign to the headline property of this OciListingRevision.
        :type headline: str

        :param tagline:
            The value to assign to the tagline property of this OciListingRevision.
        :type tagline: str

        :param keywords:
            The value to assign to the keywords property of this OciListingRevision.
        :type keywords: str

        :param short_description:
            The value to assign to the short_description property of this OciListingRevision.
        :type short_description: str

        :param usage_information:
            The value to assign to the usage_information property of this OciListingRevision.
        :type usage_information: str

        :param long_description:
            The value to assign to the long_description property of this OciListingRevision.
        :type long_description: str

        :param time_created:
            The value to assign to the time_created property of this OciListingRevision.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OciListingRevision.
        :type time_updated: datetime

        :param content_language:
            The value to assign to the content_language property of this OciListingRevision.
        :type content_language: oci.marketplace_publisher.models.LanguageItem

        :param supportedlanguages:
            The value to assign to the supportedlanguages property of this OciListingRevision.
        :type supportedlanguages: list[oci.marketplace_publisher.models.LanguageItem]

        :param support_contacts:
            The value to assign to the support_contacts property of this OciListingRevision.
        :type support_contacts: list[oci.marketplace_publisher.models.SupportContact]

        :param support_links:
            The value to assign to the support_links property of this OciListingRevision.
        :type support_links: list[oci.marketplace_publisher.models.NamedLink]

        :param icon:
            The value to assign to the icon property of this OciListingRevision.
        :type icon: oci.marketplace_publisher.models.ListingRevisionIconAttachment

        :param status:
            The value to assign to the status property of this OciListingRevision.
            Allowed values for this property are: "NEW", "PENDING_REVIEW", "REVIEW_IN_PROGRESS", "REJECTED", "APPROVED", "PUBLISH_IN_PROGRESS", "PUBLISH_FAILED", "PUBLISHED", "PUBLISH_AS_PRIVATE_FAILED", "PUBLISHED_AS_PRIVATE", "PUBLISH_AS_PRIVATE_IN_PROGRESS", "UNPUBLISH_IN_PROGRESS", "UNPUBLISHED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param status_notes:
            The value to assign to the status_notes property of this OciListingRevision.
        :type status_notes: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OciListingRevision.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param package_type:
            The value to assign to the package_type property of this OciListingRevision.
            Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type package_type: str

        :param listing_type:
            The value to assign to the listing_type property of this OciListingRevision.
            Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type listing_type: str

        :param extended_metadata:
            The value to assign to the extended_metadata property of this OciListingRevision.
        :type extended_metadata: dict(str, str)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OciListingRevision.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OciListingRevision.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OciListingRevision.
        :type system_tags: dict(str, dict(str, object))

        :param version_details:
            The value to assign to the version_details property of this OciListingRevision.
        :type version_details: oci.marketplace_publisher.models.VersionDetails

        :param system_requirements:
            The value to assign to the system_requirements property of this OciListingRevision.
        :type system_requirements: str

        :param pricing_type:
            The value to assign to the pricing_type property of this OciListingRevision.
            Allowed values for this property are: "FREE", "BYOL", "PAYGO", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type pricing_type: str

        :param products:
            The value to assign to the products property of this OciListingRevision.
        :type products: list[oci.marketplace_publisher.models.ListingProduct]

        :param pricing_plans:
            The value to assign to the pricing_plans property of this OciListingRevision.
        :type pricing_plans: list[oci.marketplace_publisher.models.PricingPlan]

        :param availability_and_pricing_policy:
            The value to assign to the availability_and_pricing_policy property of this OciListingRevision.
        :type availability_and_pricing_policy: str

        :param allowed_tenancies:
            The value to assign to the allowed_tenancies property of this OciListingRevision.
        :type allowed_tenancies: list[str]

        :param vanity_url:
            The value to assign to the vanity_url property of this OciListingRevision.
        :type vanity_url: str

        :param recommended_service_provider_listing_ids:
            The value to assign to the recommended_service_provider_listing_ids property of this OciListingRevision.
        :type recommended_service_provider_listing_ids: list[str]

        :param are_internal_tenancy_launch_allowed:
            The value to assign to the are_internal_tenancy_launch_allowed property of this OciListingRevision.
        :type are_internal_tenancy_launch_allowed: bool

        :param is_rover_exportable:
            The value to assign to the is_rover_exportable property of this OciListingRevision.
        :type is_rover_exportable: bool

        """
        self.swagger_types = {
            'id': 'str',
            'listing_id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'revision_number': 'str',
            'headline': 'str',
            'tagline': 'str',
            'keywords': 'str',
            'short_description': 'str',
            'usage_information': 'str',
            'long_description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'content_language': 'LanguageItem',
            'supportedlanguages': 'list[LanguageItem]',
            'support_contacts': 'list[SupportContact]',
            'support_links': 'list[NamedLink]',
            'icon': 'ListingRevisionIconAttachment',
            'status': 'str',
            'status_notes': 'str',
            'lifecycle_state': 'str',
            'package_type': 'str',
            'listing_type': 'str',
            'extended_metadata': 'dict(str, str)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'version_details': 'VersionDetails',
            'system_requirements': 'str',
            'pricing_type': 'str',
            'products': 'list[ListingProduct]',
            'pricing_plans': 'list[PricingPlan]',
            'availability_and_pricing_policy': 'str',
            'allowed_tenancies': 'list[str]',
            'vanity_url': 'str',
            'recommended_service_provider_listing_ids': 'list[str]',
            'are_internal_tenancy_launch_allowed': 'bool',
            'is_rover_exportable': 'bool'
        }
        self.attribute_map = {
            'id': 'id',
            'listing_id': 'listingId',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'revision_number': 'revisionNumber',
            'headline': 'headline',
            'tagline': 'tagline',
            'keywords': 'keywords',
            'short_description': 'shortDescription',
            'usage_information': 'usageInformation',
            'long_description': 'longDescription',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'content_language': 'contentLanguage',
            'supportedlanguages': 'supportedlanguages',
            'support_contacts': 'supportContacts',
            'support_links': 'supportLinks',
            'icon': 'icon',
            'status': 'status',
            'status_notes': 'statusNotes',
            'lifecycle_state': 'lifecycleState',
            'package_type': 'packageType',
            'listing_type': 'listingType',
            'extended_metadata': 'extendedMetadata',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'version_details': 'versionDetails',
            'system_requirements': 'systemRequirements',
            'pricing_type': 'pricingType',
            'products': 'products',
            'pricing_plans': 'pricingPlans',
            'availability_and_pricing_policy': 'availabilityAndPricingPolicy',
            'allowed_tenancies': 'allowedTenancies',
            'vanity_url': 'vanityUrl',
            'recommended_service_provider_listing_ids': 'recommendedServiceProviderListingIds',
            'are_internal_tenancy_launch_allowed': 'areInternalTenancyLaunchAllowed',
            'is_rover_exportable': 'isRoverExportable'
        }
        self._id = None
        self._listing_id = None
        self._compartment_id = None
        self._display_name = None
        self._revision_number = None
        self._headline = None
        self._tagline = None
        self._keywords = None
        self._short_description = None
        self._usage_information = None
        self._long_description = None
        self._time_created = None
        self._time_updated = None
        self._content_language = None
        self._supportedlanguages = None
        self._support_contacts = None
        self._support_links = None
        self._icon = None
        self._status = None
        self._status_notes = None
        self._lifecycle_state = None
        self._package_type = None
        self._listing_type = None
        self._extended_metadata = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._version_details = None
        self._system_requirements = None
        self._pricing_type = None
        self._products = None
        self._pricing_plans = None
        self._availability_and_pricing_policy = None
        self._allowed_tenancies = None
        self._vanity_url = None
        self._recommended_service_provider_listing_ids = None
        self._are_internal_tenancy_launch_allowed = None
        self._is_rover_exportable = None
        self._listing_type = 'OCI_APPLICATION'

    @property
    def version_details(self):
        """
        Gets the version_details of this OciListingRevision.

        :return: The version_details of this OciListingRevision.
        :rtype: oci.marketplace_publisher.models.VersionDetails
        """
        return self._version_details

    @version_details.setter
    def version_details(self, version_details):
        """
        Sets the version_details of this OciListingRevision.

        :param version_details: The version_details of this OciListingRevision.
        :type: oci.marketplace_publisher.models.VersionDetails
        """
        self._version_details = version_details

    @property
    def system_requirements(self):
        """
        Gets the system_requirements of this OciListingRevision.
        System requirements for the listing revision.


        :return: The system_requirements of this OciListingRevision.
        :rtype: str
        """
        return self._system_requirements

    @system_requirements.setter
    def system_requirements(self, system_requirements):
        """
        Sets the system_requirements of this OciListingRevision.
        System requirements for the listing revision.


        :param system_requirements: The system_requirements of this OciListingRevision.
        :type: str
        """
        self._system_requirements = system_requirements

    @property
    def pricing_type(self):
        """
        **[Required]** Gets the pricing_type of this OciListingRevision.
        The pricing model for the listing revision.

        Allowed values for this property are: "FREE", "BYOL", "PAYGO", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The pricing_type of this OciListingRevision.
        :rtype: str
        """
        return self._pricing_type

    @pricing_type.setter
    def pricing_type(self, pricing_type):
        """
        Sets the pricing_type of this OciListingRevision.
        The pricing model for the listing revision.


        :param pricing_type: The pricing_type of this OciListingRevision.
        :type: str
        """
        allowed_values = ["FREE", "BYOL", "PAYGO"]
        if not value_allowed_none_or_none_sentinel(pricing_type, allowed_values):
            pricing_type = 'UNKNOWN_ENUM_VALUE'
        self._pricing_type = pricing_type

    @property
    def products(self):
        """
        **[Required]** Gets the products of this OciListingRevision.
        List of products subscribed by listing.


        :return: The products of this OciListingRevision.
        :rtype: list[oci.marketplace_publisher.models.ListingProduct]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this OciListingRevision.
        List of products subscribed by listing.


        :param products: The products of this OciListingRevision.
        :type: list[oci.marketplace_publisher.models.ListingProduct]
        """
        self._products = products

    @property
    def pricing_plans(self):
        """
        Gets the pricing_plans of this OciListingRevision.
        List of Pricing Plans provided by publisher.


        :return: The pricing_plans of this OciListingRevision.
        :rtype: list[oci.marketplace_publisher.models.PricingPlan]
        """
        return self._pricing_plans

    @pricing_plans.setter
    def pricing_plans(self, pricing_plans):
        """
        Sets the pricing_plans of this OciListingRevision.
        List of Pricing Plans provided by publisher.


        :param pricing_plans: The pricing_plans of this OciListingRevision.
        :type: list[oci.marketplace_publisher.models.PricingPlan]
        """
        self._pricing_plans = pricing_plans

    @property
    def availability_and_pricing_policy(self):
        """
        Gets the availability_and_pricing_policy of this OciListingRevision.
        Listing availability and Pricing Policy statement.


        :return: The availability_and_pricing_policy of this OciListingRevision.
        :rtype: str
        """
        return self._availability_and_pricing_policy

    @availability_and_pricing_policy.setter
    def availability_and_pricing_policy(self, availability_and_pricing_policy):
        """
        Sets the availability_and_pricing_policy of this OciListingRevision.
        Listing availability and Pricing Policy statement.


        :param availability_and_pricing_policy: The availability_and_pricing_policy of this OciListingRevision.
        :type: str
        """
        self._availability_and_pricing_policy = availability_and_pricing_policy

    @property
    def allowed_tenancies(self):
        """
        Gets the allowed_tenancies of this OciListingRevision.
        Allowed tenancies provided when a listing revision is published as private.


        :return: The allowed_tenancies of this OciListingRevision.
        :rtype: list[str]
        """
        return self._allowed_tenancies

    @allowed_tenancies.setter
    def allowed_tenancies(self, allowed_tenancies):
        """
        Sets the allowed_tenancies of this OciListingRevision.
        Allowed tenancies provided when a listing revision is published as private.


        :param allowed_tenancies: The allowed_tenancies of this OciListingRevision.
        :type: list[str]
        """
        self._allowed_tenancies = allowed_tenancies

    @property
    def vanity_url(self):
        """
        Gets the vanity_url of this OciListingRevision.
        Custom link to the listing


        :return: The vanity_url of this OciListingRevision.
        :rtype: str
        """
        return self._vanity_url

    @vanity_url.setter
    def vanity_url(self, vanity_url):
        """
        Sets the vanity_url of this OciListingRevision.
        Custom link to the listing


        :param vanity_url: The vanity_url of this OciListingRevision.
        :type: str
        """
        self._vanity_url = vanity_url

    @property
    def recommended_service_provider_listing_ids(self):
        """
        Gets the recommended_service_provider_listing_ids of this OciListingRevision.
        OCIDs of service listings attached to lead gen listing


        :return: The recommended_service_provider_listing_ids of this OciListingRevision.
        :rtype: list[str]
        """
        return self._recommended_service_provider_listing_ids

    @recommended_service_provider_listing_ids.setter
    def recommended_service_provider_listing_ids(self, recommended_service_provider_listing_ids):
        """
        Sets the recommended_service_provider_listing_ids of this OciListingRevision.
        OCIDs of service listings attached to lead gen listing


        :param recommended_service_provider_listing_ids: The recommended_service_provider_listing_ids of this OciListingRevision.
        :type: list[str]
        """
        self._recommended_service_provider_listing_ids = recommended_service_provider_listing_ids

    @property
    def are_internal_tenancy_launch_allowed(self):
        """
        Gets the are_internal_tenancy_launch_allowed of this OciListingRevision.
        Identifies whether publisher allows internal tenancy launches for the listing revision.


        :return: The are_internal_tenancy_launch_allowed of this OciListingRevision.
        :rtype: bool
        """
        return self._are_internal_tenancy_launch_allowed

    @are_internal_tenancy_launch_allowed.setter
    def are_internal_tenancy_launch_allowed(self, are_internal_tenancy_launch_allowed):
        """
        Sets the are_internal_tenancy_launch_allowed of this OciListingRevision.
        Identifies whether publisher allows internal tenancy launches for the listing revision.


        :param are_internal_tenancy_launch_allowed: The are_internal_tenancy_launch_allowed of this OciListingRevision.
        :type: bool
        """
        self._are_internal_tenancy_launch_allowed = are_internal_tenancy_launch_allowed

    @property
    def is_rover_exportable(self):
        """
        Gets the is_rover_exportable of this OciListingRevision.
        Is this listing rover exportable


        :return: The is_rover_exportable of this OciListingRevision.
        :rtype: bool
        """
        return self._is_rover_exportable

    @is_rover_exportable.setter
    def is_rover_exportable(self, is_rover_exportable):
        """
        Sets the is_rover_exportable of this OciListingRevision.
        Is this listing rover exportable


        :param is_rover_exportable: The is_rover_exportable of this OciListingRevision.
        :type: bool
        """
        self._is_rover_exportable = is_rover_exportable

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
