# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SupportDocSummary(object):
    """
    The model for the supportDoc metadata.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SupportDocSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this SupportDocSummary.
        :type name: str

        :param code:
            The value to assign to the code property of this SupportDocSummary.
        :type code: str

        :param support_doc_group:
            The value to assign to the support_doc_group property of this SupportDocSummary.
        :type support_doc_group: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SupportDocSummary.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this SupportDocSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this SupportDocSummary.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'name': 'str',
            'code': 'str',
            'support_doc_group': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'name': 'name',
            'code': 'code',
            'support_doc_group': 'supportDocGroup',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._name = None
        self._code = None
        self._support_doc_group = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SupportDocSummary.
        The name for the supportDoc.


        :return: The name of this SupportDocSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SupportDocSummary.
        The name for the supportDoc.


        :param name: The name of this SupportDocSummary.
        :type: str
        """
        self._name = name

    @property
    def code(self):
        """
        **[Required]** Gets the code of this SupportDocSummary.
        The code for the supportDoc.


        :return: The code of this SupportDocSummary.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this SupportDocSummary.
        The code for the supportDoc.


        :param code: The code of this SupportDocSummary.
        :type: str
        """
        self._code = code

    @property
    def support_doc_group(self):
        """
        **[Required]** Gets the support_doc_group of this SupportDocSummary.
        The supportDoc group for the supportDoc.


        :return: The support_doc_group of this SupportDocSummary.
        :rtype: str
        """
        return self._support_doc_group

    @support_doc_group.setter
    def support_doc_group(self, support_doc_group):
        """
        Sets the support_doc_group of this SupportDocSummary.
        The supportDoc group for the supportDoc.


        :param support_doc_group: The support_doc_group of this SupportDocSummary.
        :type: str
        """
        self._support_doc_group = support_doc_group

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SupportDocSummary.
        The current state for the supportDoc.


        :return: The lifecycle_state of this SupportDocSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SupportDocSummary.
        The current state for the supportDoc.


        :param lifecycle_state: The lifecycle_state of this SupportDocSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this SupportDocSummary.
        The date and time the supportDoc was created, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this SupportDocSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this SupportDocSummary.
        The date and time the supportDoc was created, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this SupportDocSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this SupportDocSummary.
        The date and time the product was updated, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this SupportDocSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this SupportDocSummary.
        The date and time the product was updated, in the format defined by `RFC3339`__.

        Example: `2022-09-15T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this SupportDocSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
