# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NetworkAnchorSummary(object):
    """
    Summary information about a NetworkAnchor.
    """

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "CONNECTED"
    NETWORK_ANCHOR_CONNECTION_STATUS_CONNECTED = "CONNECTED"

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "DISCONNECTED"
    NETWORK_ANCHOR_CONNECTION_STATUS_DISCONNECTED = "DISCONNECTED"

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "CONNECTING"
    NETWORK_ANCHOR_CONNECTION_STATUS_CONNECTING = "CONNECTING"

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "ACTIVE"
    NETWORK_ANCHOR_CONNECTION_STATUS_ACTIVE = "ACTIVE"

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "ERROR"
    NETWORK_ANCHOR_CONNECTION_STATUS_ERROR = "ERROR"

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "UPDATING"
    NETWORK_ANCHOR_CONNECTION_STATUS_UPDATING = "UPDATING"

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "NEEDS_ATTENTION"
    NETWORK_ANCHOR_CONNECTION_STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "FAILED"
    NETWORK_ANCHOR_CONNECTION_STATUS_FAILED = "FAILED"

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "DELETING"
    NETWORK_ANCHOR_CONNECTION_STATUS_DELETING = "DELETING"

    #: A constant which can be used with the network_anchor_connection_status property of a NetworkAnchorSummary.
    #: This constant has a value of "DELETED"
    NETWORK_ANCHOR_CONNECTION_STATUS_DELETED = "DELETED"

    #: A constant which can be used with the subscription_type property of a NetworkAnchorSummary.
    #: This constant has a value of "ORACLEDBATAZURE"
    SUBSCRIPTION_TYPE_ORACLEDBATAZURE = "ORACLEDBATAZURE"

    #: A constant which can be used with the subscription_type property of a NetworkAnchorSummary.
    #: This constant has a value of "ORACLEDBATGOOGLE"
    SUBSCRIPTION_TYPE_ORACLEDBATGOOGLE = "ORACLEDBATGOOGLE"

    #: A constant which can be used with the subscription_type property of a NetworkAnchorSummary.
    #: This constant has a value of "ORACLEDBATAWS"
    SUBSCRIPTION_TYPE_ORACLEDBATAWS = "ORACLEDBATAWS"

    def __init__(self, **kwargs):
        """
        Initializes a new NetworkAnchorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this NetworkAnchorSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this NetworkAnchorSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this NetworkAnchorSummary.
        :type compartment_id: str

        :param resource_anchor_id:
            The value to assign to the resource_anchor_id property of this NetworkAnchorSummary.
        :type resource_anchor_id: str

        :param vcn_id:
            The value to assign to the vcn_id property of this NetworkAnchorSummary.
        :type vcn_id: str

        :param vcn_name:
            The value to assign to the vcn_name property of this NetworkAnchorSummary.
        :type vcn_name: str

        :param network_anchor_connection_status:
            The value to assign to the network_anchor_connection_status property of this NetworkAnchorSummary.
            Allowed values for this property are: "CONNECTED", "DISCONNECTED", "CONNECTING", "ACTIVE", "ERROR", "UPDATING", "NEEDS_ATTENTION", "FAILED", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type network_anchor_connection_status: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this NetworkAnchorSummary.
        :type cluster_placement_group_id: str

        :param time_created:
            The value to assign to the time_created property of this NetworkAnchorSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this NetworkAnchorSummary.
        :type time_updated: datetime

        :param csp_additional_properties:
            The value to assign to the csp_additional_properties property of this NetworkAnchorSummary.
        :type csp_additional_properties: dict(str, str)

        :param csp_network_anchor_id:
            The value to assign to the csp_network_anchor_id property of this NetworkAnchorSummary.
        :type csp_network_anchor_id: str

        :param network_anchor_uri:
            The value to assign to the network_anchor_uri property of this NetworkAnchorSummary.
        :type network_anchor_uri: str

        :param network_anchor_lifecycle_state:
            The value to assign to the network_anchor_lifecycle_state property of this NetworkAnchorSummary.
        :type network_anchor_lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this NetworkAnchorSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this NetworkAnchorSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this NetworkAnchorSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this NetworkAnchorSummary.
        :type system_tags: dict(str, dict(str, object))

        :param subscription_type:
            The value to assign to the subscription_type property of this NetworkAnchorSummary.
            Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type subscription_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'resource_anchor_id': 'str',
            'vcn_id': 'str',
            'vcn_name': 'str',
            'network_anchor_connection_status': 'str',
            'cluster_placement_group_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'csp_additional_properties': 'dict(str, str)',
            'csp_network_anchor_id': 'str',
            'network_anchor_uri': 'str',
            'network_anchor_lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'subscription_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'resource_anchor_id': 'resourceAnchorId',
            'vcn_id': 'vcnId',
            'vcn_name': 'vcnName',
            'network_anchor_connection_status': 'networkAnchorConnectionStatus',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'csp_additional_properties': 'cspAdditionalProperties',
            'csp_network_anchor_id': 'cspNetworkAnchorId',
            'network_anchor_uri': 'networkAnchorUri',
            'network_anchor_lifecycle_state': 'networkAnchorLifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'subscription_type': 'subscriptionType'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._resource_anchor_id = None
        self._vcn_id = None
        self._vcn_name = None
        self._network_anchor_connection_status = None
        self._cluster_placement_group_id = None
        self._time_created = None
        self._time_updated = None
        self._csp_additional_properties = None
        self._csp_network_anchor_id = None
        self._network_anchor_uri = None
        self._network_anchor_lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._subscription_type = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this NetworkAnchorSummary.
        The `OCID`__ of the NetworkAnchor.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NetworkAnchorSummary.
        The `OCID`__ of the NetworkAnchor.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this NetworkAnchorSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this NetworkAnchorSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this NetworkAnchorSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this NetworkAnchorSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this NetworkAnchorSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this NetworkAnchorSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this NetworkAnchorSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_anchor_id(self):
        """
        **[Required]** Gets the resource_anchor_id of this NetworkAnchorSummary.
        OCI resource anchor Id (OCID).


        :return: The resource_anchor_id of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._resource_anchor_id

    @resource_anchor_id.setter
    def resource_anchor_id(self, resource_anchor_id):
        """
        Sets the resource_anchor_id of this NetworkAnchorSummary.
        OCI resource anchor Id (OCID).


        :param resource_anchor_id: The resource_anchor_id of this NetworkAnchorSummary.
        :type: str
        """
        self._resource_anchor_id = resource_anchor_id

    @property
    def vcn_id(self):
        """
        Gets the vcn_id of this NetworkAnchorSummary.
        OCI resource Id of VCN.


        :return: The vcn_id of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this NetworkAnchorSummary.
        OCI resource Id of VCN.


        :param vcn_id: The vcn_id of this NetworkAnchorSummary.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def vcn_name(self):
        """
        Gets the vcn_name of this NetworkAnchorSummary.
        Name of the VCN associated to the Network Anchor.


        :return: The vcn_name of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._vcn_name

    @vcn_name.setter
    def vcn_name(self, vcn_name):
        """
        Sets the vcn_name of this NetworkAnchorSummary.
        Name of the VCN associated to the Network Anchor.


        :param vcn_name: The vcn_name of this NetworkAnchorSummary.
        :type: str
        """
        self._vcn_name = vcn_name

    @property
    def network_anchor_connection_status(self):
        """
        **[Required]** Gets the network_anchor_connection_status of this NetworkAnchorSummary.
        Defines status of the Network Anchor.

        Allowed values for this property are: "CONNECTED", "DISCONNECTED", "CONNECTING", "ACTIVE", "ERROR", "UPDATING", "NEEDS_ATTENTION", "FAILED", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The network_anchor_connection_status of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._network_anchor_connection_status

    @network_anchor_connection_status.setter
    def network_anchor_connection_status(self, network_anchor_connection_status):
        """
        Sets the network_anchor_connection_status of this NetworkAnchorSummary.
        Defines status of the Network Anchor.


        :param network_anchor_connection_status: The network_anchor_connection_status of this NetworkAnchorSummary.
        :type: str
        """
        allowed_values = ["CONNECTED", "DISCONNECTED", "CONNECTING", "ACTIVE", "ERROR", "UPDATING", "NEEDS_ATTENTION", "FAILED", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(network_anchor_connection_status, allowed_values):
            network_anchor_connection_status = 'UNKNOWN_ENUM_VALUE'
        self._network_anchor_connection_status = network_anchor_connection_status

    @property
    def cluster_placement_group_id(self):
        """
        Gets the cluster_placement_group_id of this NetworkAnchorSummary.
        The CPG ID in which Network Anchor will be created.


        :return: The cluster_placement_group_id of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._cluster_placement_group_id

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, cluster_placement_group_id):
        """
        Sets the cluster_placement_group_id of this NetworkAnchorSummary.
        The CPG ID in which Network Anchor will be created.


        :param cluster_placement_group_id: The cluster_placement_group_id of this NetworkAnchorSummary.
        :type: str
        """
        self._cluster_placement_group_id = cluster_placement_group_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this NetworkAnchorSummary.
        The date and time the NetworkAnchor was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this NetworkAnchorSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this NetworkAnchorSummary.
        The date and time the NetworkAnchor was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this NetworkAnchorSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this NetworkAnchorSummary.
        The date and time the NetworkAnchor was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this NetworkAnchorSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this NetworkAnchorSummary.
        The date and time the NetworkAnchor was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this NetworkAnchorSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def csp_additional_properties(self):
        """
        Gets the csp_additional_properties of this NetworkAnchorSummary.
        CSP Specific Additional Properties, AzureSubnetId for Azure


        :return: The csp_additional_properties of this NetworkAnchorSummary.
        :rtype: dict(str, str)
        """
        return self._csp_additional_properties

    @csp_additional_properties.setter
    def csp_additional_properties(self, csp_additional_properties):
        """
        Sets the csp_additional_properties of this NetworkAnchorSummary.
        CSP Specific Additional Properties, AzureSubnetId for Azure


        :param csp_additional_properties: The csp_additional_properties of this NetworkAnchorSummary.
        :type: dict(str, str)
        """
        self._csp_additional_properties = csp_additional_properties

    @property
    def csp_network_anchor_id(self):
        """
        Gets the csp_network_anchor_id of this NetworkAnchorSummary.
        Network Anchor Id in the Cloud Service Provider.


        :return: The csp_network_anchor_id of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._csp_network_anchor_id

    @csp_network_anchor_id.setter
    def csp_network_anchor_id(self, csp_network_anchor_id):
        """
        Sets the csp_network_anchor_id of this NetworkAnchorSummary.
        Network Anchor Id in the Cloud Service Provider.


        :param csp_network_anchor_id: The csp_network_anchor_id of this NetworkAnchorSummary.
        :type: str
        """
        self._csp_network_anchor_id = csp_network_anchor_id

    @property
    def network_anchor_uri(self):
        """
        Gets the network_anchor_uri of this NetworkAnchorSummary.
        CSP network anchor Uri


        :return: The network_anchor_uri of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._network_anchor_uri

    @network_anchor_uri.setter
    def network_anchor_uri(self, network_anchor_uri):
        """
        Sets the network_anchor_uri of this NetworkAnchorSummary.
        CSP network anchor Uri


        :param network_anchor_uri: The network_anchor_uri of this NetworkAnchorSummary.
        :type: str
        """
        self._network_anchor_uri = network_anchor_uri

    @property
    def network_anchor_lifecycle_state(self):
        """
        **[Required]** Gets the network_anchor_lifecycle_state of this NetworkAnchorSummary.
        The current state of the NetworkAnchor.


        :return: The network_anchor_lifecycle_state of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._network_anchor_lifecycle_state

    @network_anchor_lifecycle_state.setter
    def network_anchor_lifecycle_state(self, network_anchor_lifecycle_state):
        """
        Sets the network_anchor_lifecycle_state of this NetworkAnchorSummary.
        The current state of the NetworkAnchor.


        :param network_anchor_lifecycle_state: The network_anchor_lifecycle_state of this NetworkAnchorSummary.
        :type: str
        """
        self._network_anchor_lifecycle_state = network_anchor_lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this NetworkAnchorSummary.
        A message that describes the current state of the NetworkAnchor in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this NetworkAnchorSummary.
        A message that describes the current state of the NetworkAnchor in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this NetworkAnchorSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this NetworkAnchorSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this NetworkAnchorSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this NetworkAnchorSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this NetworkAnchorSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this NetworkAnchorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this NetworkAnchorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this NetworkAnchorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this NetworkAnchorSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this NetworkAnchorSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this NetworkAnchorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this NetworkAnchorSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this NetworkAnchorSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def subscription_type(self):
        """
        Gets the subscription_type of this NetworkAnchorSummary.
        Oracle Cloud Infrastructure Subscription Type.

        Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The subscription_type of this NetworkAnchorSummary.
        :rtype: str
        """
        return self._subscription_type

    @subscription_type.setter
    def subscription_type(self, subscription_type):
        """
        Sets the subscription_type of this NetworkAnchorSummary.
        Oracle Cloud Infrastructure Subscription Type.


        :param subscription_type: The subscription_type of this NetworkAnchorSummary.
        :type: str
        """
        allowed_values = ["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]
        if not value_allowed_none_or_none_sentinel(subscription_type, allowed_values):
            subscription_type = 'UNKNOWN_ENUM_VALUE'
        self._subscription_type = subscription_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
