# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupValidationDetails(object):
    """
    Backup validation details.
    """

    #: A constant which can be used with the validation_status property of a BackupValidationDetails.
    #: This constant has a value of "NOT_VALIDATED"
    VALIDATION_STATUS_NOT_VALIDATED = "NOT_VALIDATED"

    #: A constant which can be used with the validation_status property of a BackupValidationDetails.
    #: This constant has a value of "VALIDATED"
    VALIDATION_STATUS_VALIDATED = "VALIDATED"

    #: A constant which can be used with the validation_status property of a BackupValidationDetails.
    #: This constant has a value of "NEEDS_ATTENTION"
    VALIDATION_STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the validation_status property of a BackupValidationDetails.
    #: This constant has a value of "FAILED"
    VALIDATION_STATUS_FAILED = "FAILED"

    #: A constant which can be used with the backup_preparation_status property of a BackupValidationDetails.
    #: This constant has a value of "PREPARED"
    BACKUP_PREPARATION_STATUS_PREPARED = "PREPARED"

    #: A constant which can be used with the backup_preparation_status property of a BackupValidationDetails.
    #: This constant has a value of "NOT_PREPARED"
    BACKUP_PREPARATION_STATUS_NOT_PREPARED = "NOT_PREPARED"

    def __init__(self, **kwargs):
        """
        Initializes a new BackupValidationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param validation_status:
            The value to assign to the validation_status property of this BackupValidationDetails.
            Allowed values for this property are: "NOT_VALIDATED", "VALIDATED", "NEEDS_ATTENTION", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type validation_status: str

        :param time_last_validated:
            The value to assign to the time_last_validated property of this BackupValidationDetails.
        :type time_last_validated: datetime

        :param estimated_restore_duration:
            The value to assign to the estimated_restore_duration property of this BackupValidationDetails.
        :type estimated_restore_duration: str

        :param error_message:
            The value to assign to the error_message property of this BackupValidationDetails.
        :type error_message: str

        :param backup_preparation_status:
            The value to assign to the backup_preparation_status property of this BackupValidationDetails.
            Allowed values for this property are: "PREPARED", "NOT_PREPARED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type backup_preparation_status: str

        :param prepared_backup_details:
            The value to assign to the prepared_backup_details property of this BackupValidationDetails.
        :type prepared_backup_details: oci.mysql.models.PreparedBackupDetails

        """
        self.swagger_types = {
            'validation_status': 'str',
            'time_last_validated': 'datetime',
            'estimated_restore_duration': 'str',
            'error_message': 'str',
            'backup_preparation_status': 'str',
            'prepared_backup_details': 'PreparedBackupDetails'
        }
        self.attribute_map = {
            'validation_status': 'validationStatus',
            'time_last_validated': 'timeLastValidated',
            'estimated_restore_duration': 'estimatedRestoreDuration',
            'error_message': 'errorMessage',
            'backup_preparation_status': 'backupPreparationStatus',
            'prepared_backup_details': 'preparedBackupDetails'
        }
        self._validation_status = None
        self._time_last_validated = None
        self._estimated_restore_duration = None
        self._error_message = None
        self._backup_preparation_status = None
        self._prepared_backup_details = None

    @property
    def validation_status(self):
        """
        Gets the validation_status of this BackupValidationDetails.
        The status of backup validation:
        NOT_VALIDATED (Default): The backup has not been validated.
        VALIDATED: The backup has been validated successfully.
        NEEDS_ATTENTION: The backup validation failed due to a transient issue. Validation should be retried.
        FAILED: The backup cannot be restored.

        Allowed values for this property are: "NOT_VALIDATED", "VALIDATED", "NEEDS_ATTENTION", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The validation_status of this BackupValidationDetails.
        :rtype: str
        """
        return self._validation_status

    @validation_status.setter
    def validation_status(self, validation_status):
        """
        Sets the validation_status of this BackupValidationDetails.
        The status of backup validation:
        NOT_VALIDATED (Default): The backup has not been validated.
        VALIDATED: The backup has been validated successfully.
        NEEDS_ATTENTION: The backup validation failed due to a transient issue. Validation should be retried.
        FAILED: The backup cannot be restored.


        :param validation_status: The validation_status of this BackupValidationDetails.
        :type: str
        """
        allowed_values = ["NOT_VALIDATED", "VALIDATED", "NEEDS_ATTENTION", "FAILED"]
        if not value_allowed_none_or_none_sentinel(validation_status, allowed_values):
            validation_status = 'UNKNOWN_ENUM_VALUE'
        self._validation_status = validation_status

    @property
    def time_last_validated(self):
        """
        Gets the time_last_validated of this BackupValidationDetails.
        The date and time of the most recent validation performed on the backup.


        :return: The time_last_validated of this BackupValidationDetails.
        :rtype: datetime
        """
        return self._time_last_validated

    @time_last_validated.setter
    def time_last_validated(self, time_last_validated):
        """
        Sets the time_last_validated of this BackupValidationDetails.
        The date and time of the most recent validation performed on the backup.


        :param time_last_validated: The time_last_validated of this BackupValidationDetails.
        :type: datetime
        """
        self._time_last_validated = time_last_validated

    @property
    def estimated_restore_duration(self):
        """
        Gets the estimated_restore_duration of this BackupValidationDetails.
        The estimated restore duration of the backup.


        :return: The estimated_restore_duration of this BackupValidationDetails.
        :rtype: str
        """
        return self._estimated_restore_duration

    @estimated_restore_duration.setter
    def estimated_restore_duration(self, estimated_restore_duration):
        """
        Sets the estimated_restore_duration of this BackupValidationDetails.
        The estimated restore duration of the backup.


        :param estimated_restore_duration: The estimated_restore_duration of this BackupValidationDetails.
        :type: str
        """
        self._estimated_restore_duration = estimated_restore_duration

    @property
    def error_message(self):
        """
        Gets the error_message of this BackupValidationDetails.
        Error message if the backup validation has failed.


        :return: The error_message of this BackupValidationDetails.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this BackupValidationDetails.
        Error message if the backup validation has failed.


        :param error_message: The error_message of this BackupValidationDetails.
        :type: str
        """
        self._error_message = error_message

    @property
    def backup_preparation_status(self):
        """
        Gets the backup_preparation_status of this BackupValidationDetails.
        Indicates whether the backup has been prepared successfully.
        PREPARED: The backup is prepared one.
        NOT_PREPARED: The backup is not prepared.

        Allowed values for this property are: "PREPARED", "NOT_PREPARED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The backup_preparation_status of this BackupValidationDetails.
        :rtype: str
        """
        return self._backup_preparation_status

    @backup_preparation_status.setter
    def backup_preparation_status(self, backup_preparation_status):
        """
        Sets the backup_preparation_status of this BackupValidationDetails.
        Indicates whether the backup has been prepared successfully.
        PREPARED: The backup is prepared one.
        NOT_PREPARED: The backup is not prepared.


        :param backup_preparation_status: The backup_preparation_status of this BackupValidationDetails.
        :type: str
        """
        allowed_values = ["PREPARED", "NOT_PREPARED"]
        if not value_allowed_none_or_none_sentinel(backup_preparation_status, allowed_values):
            backup_preparation_status = 'UNKNOWN_ENUM_VALUE'
        self._backup_preparation_status = backup_preparation_status

    @property
    def prepared_backup_details(self):
        """
        Gets the prepared_backup_details of this BackupValidationDetails.

        :return: The prepared_backup_details of this BackupValidationDetails.
        :rtype: oci.mysql.models.PreparedBackupDetails
        """
        return self._prepared_backup_details

    @prepared_backup_details.setter
    def prepared_backup_details(self, prepared_backup_details):
        """
        Sets the prepared_backup_details of this BackupValidationDetails.

        :param prepared_backup_details: The prepared_backup_details of this BackupValidationDetails.
        :type: oci.mysql.models.PreparedBackupDetails
        """
        self._prepared_backup_details = prepared_backup_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
