# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchDeleteObjectIdentifier(object):
    """
    Delete object details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BatchDeleteObjectIdentifier object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param object_name:
            The value to assign to the object_name property of this BatchDeleteObjectIdentifier.
        :type object_name: str

        :param if_match:
            The value to assign to the if_match property of this BatchDeleteObjectIdentifier.
        :type if_match: str

        """
        self.swagger_types = {
            'object_name': 'str',
            'if_match': 'str'
        }
        self.attribute_map = {
            'object_name': 'objectName',
            'if_match': 'ifMatch'
        }
        self._object_name = None
        self._if_match = None

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this BatchDeleteObjectIdentifier.
        The name of the object to delete. Avoid entering confidential information.
        Example: test/object1.log


        :return: The object_name of this BatchDeleteObjectIdentifier.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this BatchDeleteObjectIdentifier.
        The name of the object to delete. Avoid entering confidential information.
        Example: test/object1.log


        :param object_name: The object_name of this BatchDeleteObjectIdentifier.
        :type: str
        """
        self._object_name = object_name

    @property
    def if_match(self):
        """
        Gets the if_match of this BatchDeleteObjectIdentifier.
        The entity tag (ETag) to match. Avoid entering confidential information.
        Example: etag1


        :return: The if_match of this BatchDeleteObjectIdentifier.
        :rtype: str
        """
        return self._if_match

    @if_match.setter
    def if_match(self, if_match):
        """
        Sets the if_match of this BatchDeleteObjectIdentifier.
        The entity tag (ETag) to match. Avoid entering confidential information.
        Example: etag1


        :param if_match: The if_match of this BatchDeleteObjectIdentifier.
        :type: str
        """
        self._if_match = if_match

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
