# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchDeleteObjectsDetails(object):
    """
    Batch delete request details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BatchDeleteObjectsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param objects:
            The value to assign to the objects property of this BatchDeleteObjectsDetails.
        :type objects: list[oci.object_storage.models.BatchDeleteObjectIdentifier]

        :param is_skip_deleted_result:
            The value to assign to the is_skip_deleted_result property of this BatchDeleteObjectsDetails.
        :type is_skip_deleted_result: bool

        """
        self.swagger_types = {
            'objects': 'list[BatchDeleteObjectIdentifier]',
            'is_skip_deleted_result': 'bool'
        }
        self.attribute_map = {
            'objects': 'objects',
            'is_skip_deleted_result': 'isSkipDeletedResult'
        }
        self._objects = None
        self._is_skip_deleted_result = None

    @property
    def objects(self):
        """
        **[Required]** Gets the objects of this BatchDeleteObjectsDetails.
        The list of the objects to delete.


        :return: The objects of this BatchDeleteObjectsDetails.
        :rtype: list[oci.object_storage.models.BatchDeleteObjectIdentifier]
        """
        return self._objects

    @objects.setter
    def objects(self, objects):
        """
        Sets the objects of this BatchDeleteObjectsDetails.
        The list of the objects to delete.


        :param objects: The objects of this BatchDeleteObjectsDetails.
        :type: list[oci.object_storage.models.BatchDeleteObjectIdentifier]
        """
        self._objects = objects

    @property
    def is_skip_deleted_result(self):
        """
        Gets the is_skip_deleted_result of this BatchDeleteObjectsDetails.
        Specifies whether to skip the details of successfully deleted objects in the response. If specified true
        then only the details of failed deletes will be available in the response. Defaults to false.


        :return: The is_skip_deleted_result of this BatchDeleteObjectsDetails.
        :rtype: bool
        """
        return self._is_skip_deleted_result

    @is_skip_deleted_result.setter
    def is_skip_deleted_result(self, is_skip_deleted_result):
        """
        Sets the is_skip_deleted_result of this BatchDeleteObjectsDetails.
        Specifies whether to skip the details of successfully deleted objects in the response. If specified true
        then only the details of failed deletes will be available in the response. Defaults to false.


        :param is_skip_deleted_result: The is_skip_deleted_result of this BatchDeleteObjectsDetails.
        :type: bool
        """
        self._is_skip_deleted_result = is_skip_deleted_result

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
