# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchDeleteObjectsResult(object):
    """
    Result of a batch delete operation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BatchDeleteObjectsResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param deleted:
            The value to assign to the deleted property of this BatchDeleteObjectsResult.
        :type deleted: list[oci.object_storage.models.DeletedObjectResult]

        :param failed:
            The value to assign to the failed property of this BatchDeleteObjectsResult.
        :type failed: list[oci.object_storage.models.FailedObjectResult]

        """
        self.swagger_types = {
            'deleted': 'list[DeletedObjectResult]',
            'failed': 'list[FailedObjectResult]'
        }
        self.attribute_map = {
            'deleted': 'deleted',
            'failed': 'failed'
        }
        self._deleted = None
        self._failed = None

    @property
    def deleted(self):
        """
        **[Required]** Gets the deleted of this BatchDeleteObjectsResult.
        Details of successfully deleted objects.


        :return: The deleted of this BatchDeleteObjectsResult.
        :rtype: list[oci.object_storage.models.DeletedObjectResult]
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """
        Sets the deleted of this BatchDeleteObjectsResult.
        Details of successfully deleted objects.


        :param deleted: The deleted of this BatchDeleteObjectsResult.
        :type: list[oci.object_storage.models.DeletedObjectResult]
        """
        self._deleted = deleted

    @property
    def failed(self):
        """
        Gets the failed of this BatchDeleteObjectsResult.
        Details of failed delete operations.


        :return: The failed of this BatchDeleteObjectsResult.
        :rtype: list[oci.object_storage.models.FailedObjectResult]
        """
        return self._failed

    @failed.setter
    def failed(self, failed):
        """
        Sets the failed of this BatchDeleteObjectsResult.
        Details of failed delete operations.


        :param failed: The failed of this BatchDeleteObjectsResult.
        :type: list[oci.object_storage.models.FailedObjectResult]
        """
        self._failed = failed

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
