# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaintenanceDetails(object):
    """
    Details for the maintenance activity.
    """

    #: A constant which can be used with the state property of a MaintenanceDetails.
    #: This constant has a value of "SCHEDULED"
    STATE_SCHEDULED = "SCHEDULED"

    #: A constant which can be used with the state property of a MaintenanceDetails.
    #: This constant has a value of "RESCHEDULED"
    STATE_RESCHEDULED = "RESCHEDULED"

    #: A constant which can be used with the state property of a MaintenanceDetails.
    #: This constant has a value of "TO_BE_SCHEDULED"
    STATE_TO_BE_SCHEDULED = "TO_BE_SCHEDULED"

    def __init__(self, **kwargs):
        """
        Initializes a new MaintenanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param state:
            The value to assign to the state property of this MaintenanceDetails.
            Allowed values for this property are: "SCHEDULED", "RESCHEDULED", "TO_BE_SCHEDULED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param start_time:
            The value to assign to the start_time property of this MaintenanceDetails.
        :type start_time: datetime

        :param end_time:
            The value to assign to the end_time property of this MaintenanceDetails.
        :type end_time: datetime

        :param notification_email_ids:
            The value to assign to the notification_email_ids property of this MaintenanceDetails.
        :type notification_email_ids: list[str]

        """
        self.swagger_types = {
            'state': 'str',
            'start_time': 'datetime',
            'end_time': 'datetime',
            'notification_email_ids': 'list[str]'
        }
        self.attribute_map = {
            'state': 'state',
            'start_time': 'startTime',
            'end_time': 'endTime',
            'notification_email_ids': 'notificationEmailIds'
        }
        self._state = None
        self._start_time = None
        self._end_time = None
        self._notification_email_ids = None

    @property
    def state(self):
        """
        **[Required]** Gets the state of this MaintenanceDetails.
        State of the maintenance activity

        Allowed values for this property are: "SCHEDULED", "RESCHEDULED", "TO_BE_SCHEDULED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this MaintenanceDetails.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this MaintenanceDetails.
        State of the maintenance activity


        :param state: The state of this MaintenanceDetails.
        :type: str
        """
        allowed_values = ["SCHEDULED", "RESCHEDULED", "TO_BE_SCHEDULED"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def start_time(self):
        """
        Gets the start_time of this MaintenanceDetails.
        Start time of the maintenance activity


        :return: The start_time of this MaintenanceDetails.
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this MaintenanceDetails.
        Start time of the maintenance activity


        :param start_time: The start_time of this MaintenanceDetails.
        :type: datetime
        """
        self._start_time = start_time

    @property
    def end_time(self):
        """
        Gets the end_time of this MaintenanceDetails.
        End time of the maintenance activity


        :return: The end_time of this MaintenanceDetails.
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """
        Sets the end_time of this MaintenanceDetails.
        End time of the maintenance activity


        :param end_time: The end_time of this MaintenanceDetails.
        :type: datetime
        """
        self._end_time = end_time

    @property
    def notification_email_ids(self):
        """
        Gets the notification_email_ids of this MaintenanceDetails.
        The Email Ids given the by customer to get notified about maintenance activities


        :return: The notification_email_ids of this MaintenanceDetails.
        :rtype: list[str]
        """
        return self._notification_email_ids

    @notification_email_ids.setter
    def notification_email_ids(self, notification_email_ids):
        """
        Sets the notification_email_ids of this MaintenanceDetails.
        The Email Ids given the by customer to get notified about maintenance activities


        :param notification_email_ids: The notification_email_ids of this MaintenanceDetails.
        :type: list[str]
        """
        self._notification_email_ids = notification_email_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
