# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttachedOciCacheUser(object):
    """
    OciCacheUser attached to the OciCacheCluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AttachedOciCacheUser object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param oci_cache_user_id:
            The value to assign to the oci_cache_user_id property of this AttachedOciCacheUser.
        :type oci_cache_user_id: str

        """
        self.swagger_types = {
            'oci_cache_user_id': 'str'
        }
        self.attribute_map = {
            'oci_cache_user_id': 'ociCacheUserId'
        }
        self._oci_cache_user_id = None

    @property
    def oci_cache_user_id(self):
        """
        **[Required]** Gets the oci_cache_user_id of this AttachedOciCacheUser.
        OCID of the OciCacheUser


        :return: The oci_cache_user_id of this AttachedOciCacheUser.
        :rtype: str
        """
        return self._oci_cache_user_id

    @oci_cache_user_id.setter
    def oci_cache_user_id(self, oci_cache_user_id):
        """
        Sets the oci_cache_user_id of this AttachedOciCacheUser.
        OCID of the OciCacheUser


        :param oci_cache_user_id: The oci_cache_user_id of this AttachedOciCacheUser.
        :type: str
        """
        self._oci_cache_user_id = oci_cache_user_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
