# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOciCacheUserDetails(object):
    """
    Details required to create a new OCI cache user.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOciCacheUserDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateOciCacheUserDetails.
        :type name: str

        :param description:
            The value to assign to the description property of this CreateOciCacheUserDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOciCacheUserDetails.
        :type compartment_id: str

        :param authentication_mode:
            The value to assign to the authentication_mode property of this CreateOciCacheUserDetails.
        :type authentication_mode: oci.redis.models.AuthenticationMode

        :param acl_string:
            The value to assign to the acl_string property of this CreateOciCacheUserDetails.
        :type acl_string: str

        :param status:
            The value to assign to the status property of this CreateOciCacheUserDetails.
        :type status: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOciCacheUserDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOciCacheUserDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'authentication_mode': 'AuthenticationMode',
            'acl_string': 'str',
            'status': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'authentication_mode': 'authenticationMode',
            'acl_string': 'aclString',
            'status': 'status',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._name = None
        self._description = None
        self._compartment_id = None
        self._authentication_mode = None
        self._acl_string = None
        self._status = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateOciCacheUserDetails.
        OCI cache user name is required to connect to an OCI cache cluster.


        :return: The name of this CreateOciCacheUserDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateOciCacheUserDetails.
        OCI cache user name is required to connect to an OCI cache cluster.


        :param name: The name of this CreateOciCacheUserDetails.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this CreateOciCacheUserDetails.
        Description of OCI cache user.


        :return: The description of this CreateOciCacheUserDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateOciCacheUserDetails.
        Description of OCI cache user.


        :param description: The description of this CreateOciCacheUserDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateOciCacheUserDetails.
        OCI cache user compartment ID.


        :return: The compartment_id of this CreateOciCacheUserDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateOciCacheUserDetails.
        OCI cache user compartment ID.


        :param compartment_id: The compartment_id of this CreateOciCacheUserDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def authentication_mode(self):
        """
        **[Required]** Gets the authentication_mode of this CreateOciCacheUserDetails.

        :return: The authentication_mode of this CreateOciCacheUserDetails.
        :rtype: oci.redis.models.AuthenticationMode
        """
        return self._authentication_mode

    @authentication_mode.setter
    def authentication_mode(self, authentication_mode):
        """
        Sets the authentication_mode of this CreateOciCacheUserDetails.

        :param authentication_mode: The authentication_mode of this CreateOciCacheUserDetails.
        :type: oci.redis.models.AuthenticationMode
        """
        self._authentication_mode = authentication_mode

    @property
    def acl_string(self):
        """
        **[Required]** Gets the acl_string of this CreateOciCacheUserDetails.
        ACL string of OCI cache user.


        :return: The acl_string of this CreateOciCacheUserDetails.
        :rtype: str
        """
        return self._acl_string

    @acl_string.setter
    def acl_string(self, acl_string):
        """
        Sets the acl_string of this CreateOciCacheUserDetails.
        ACL string of OCI cache user.


        :param acl_string: The acl_string of this CreateOciCacheUserDetails.
        :type: str
        """
        self._acl_string = acl_string

    @property
    def status(self):
        """
        Gets the status of this CreateOciCacheUserDetails.
        OCI cache user status. ON enables and OFF disables the OCI cache user to login to the associated clusters. Default value is ON.


        :return: The status of this CreateOciCacheUserDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this CreateOciCacheUserDetails.
        OCI cache user status. ON enables and OFF disables the OCI cache user to login to the associated clusters. Default value is ON.


        :param status: The status of this CreateOciCacheUserDetails.
        :type: str
        """
        self._status = status

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateOciCacheUserDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateOciCacheUserDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateOciCacheUserDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateOciCacheUserDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateOciCacheUserDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateOciCacheUserDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateOciCacheUserDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateOciCacheUserDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
