# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciCacheDefaultConfigSetSummary(object):
    """
    Summary of information about an OCI Cache Default Config Set.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciCacheDefaultConfigSetSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OciCacheDefaultConfigSetSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this OciCacheDefaultConfigSetSummary.
        :type display_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OciCacheDefaultConfigSetSummary.
        :type lifecycle_state: str

        :param software_version:
            The value to assign to the software_version property of this OciCacheDefaultConfigSetSummary.
        :type software_version: str

        :param time_created:
            The value to assign to the time_created property of this OciCacheDefaultConfigSetSummary.
        :type time_created: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'lifecycle_state': 'str',
            'software_version': 'str',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'lifecycle_state': 'lifecycleState',
            'software_version': 'softwareVersion',
            'time_created': 'timeCreated'
        }
        self._id = None
        self._display_name = None
        self._lifecycle_state = None
        self._software_version = None
        self._time_created = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OciCacheDefaultConfigSetSummary.
        The `OCID`__ of the OCI Cache Default Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :return: The id of this OciCacheDefaultConfigSetSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OciCacheDefaultConfigSetSummary.
        The `OCID`__ of the OCI Cache Default Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :param id: The id of this OciCacheDefaultConfigSetSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this OciCacheDefaultConfigSetSummary.
        A user-friendly name of the OCI Cache Default Config Set.


        :return: The display_name of this OciCacheDefaultConfigSetSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OciCacheDefaultConfigSetSummary.
        A user-friendly name of the OCI Cache Default Config Set.


        :param display_name: The display_name of this OciCacheDefaultConfigSetSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this OciCacheDefaultConfigSetSummary.
        The current state of the OCI Cache Default Config Set.


        :return: The lifecycle_state of this OciCacheDefaultConfigSetSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OciCacheDefaultConfigSetSummary.
        The current state of the OCI Cache Default Config Set.


        :param lifecycle_state: The lifecycle_state of this OciCacheDefaultConfigSetSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def software_version(self):
        """
        **[Required]** Gets the software_version of this OciCacheDefaultConfigSetSummary.
        The engine version of the OCI Cache Default Config Set.


        :return: The software_version of this OciCacheDefaultConfigSetSummary.
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        """
        Sets the software_version of this OciCacheDefaultConfigSetSummary.
        The engine version of the OCI Cache Default Config Set.


        :param software_version: The software_version of this OciCacheDefaultConfigSetSummary.
        :type: str
        """
        self._software_version = software_version

    @property
    def time_created(self):
        """
        Gets the time_created of this OciCacheDefaultConfigSetSummary.
        The date and time the configuration was created. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this OciCacheDefaultConfigSetSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OciCacheDefaultConfigSetSummary.
        The date and time the configuration was created. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this OciCacheDefaultConfigSetSummary.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
