# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315

from .authentication_mode import AuthenticationMode
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PasswordAuthenticationMode(AuthenticationMode):
    """
    child class of AuthenticationMode.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PasswordAuthenticationMode object with values from keyword arguments. The default value of the :py:attr:`~oci.redis.models.PasswordAuthenticationMode.authentication_type` attribute
        of this class is ``PASSWORD`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param authentication_type:
            The value to assign to the authentication_type property of this PasswordAuthenticationMode.
            Allowed values for this property are: "IAM", "PASSWORD"
        :type authentication_type: str

        :param hashed_passwords:
            The value to assign to the hashed_passwords property of this PasswordAuthenticationMode.
        :type hashed_passwords: list[str]

        """
        self.swagger_types = {
            'authentication_type': 'str',
            'hashed_passwords': 'list[str]'
        }
        self.attribute_map = {
            'authentication_type': 'authenticationType',
            'hashed_passwords': 'hashedPasswords'
        }
        self._authentication_type = None
        self._hashed_passwords = None
        self._authentication_type = 'PASSWORD'

    @property
    def hashed_passwords(self):
        """
        **[Required]** Gets the hashed_passwords of this PasswordAuthenticationMode.
        SHA-256 hashed passwords for OCI Cache user,required if authenticationType is set to PASSWORD.


        :return: The hashed_passwords of this PasswordAuthenticationMode.
        :rtype: list[str]
        """
        return self._hashed_passwords

    @hashed_passwords.setter
    def hashed_passwords(self, hashed_passwords):
        """
        Sets the hashed_passwords of this PasswordAuthenticationMode.
        SHA-256 hashed passwords for OCI Cache user,required if authenticationType is set to PASSWORD.


        :param hashed_passwords: The hashed_passwords of this PasswordAuthenticationMode.
        :type: list[str]
        """
        self._hashed_passwords = hashed_passwords

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
