# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceTypeConfigDetails(object):
    """
    Resource type configuration details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceTypeConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_type:
            The value to assign to the resource_type property of this ResourceTypeConfigDetails.
        :type resource_type: str

        :param availability_metrics_config:
            The value to assign to the availability_metrics_config property of this ResourceTypeConfigDetails.
        :type availability_metrics_config: oci.stack_monitoring.models.AvailabilityMetricsDetails

        :param handler_config:
            The value to assign to the handler_config property of this ResourceTypeConfigDetails.
        :type handler_config: oci.stack_monitoring.models.AgentExtensionHandlerConfiguration

        """
        self.swagger_types = {
            'resource_type': 'str',
            'availability_metrics_config': 'AvailabilityMetricsDetails',
            'handler_config': 'AgentExtensionHandlerConfiguration'
        }
        self.attribute_map = {
            'resource_type': 'resourceType',
            'availability_metrics_config': 'availabilityMetricsConfig',
            'handler_config': 'handlerConfig'
        }
        self._resource_type = None
        self._availability_metrics_config = None
        self._handler_config = None

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this ResourceTypeConfigDetails.
        Resource type.


        :return: The resource_type of this ResourceTypeConfigDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this ResourceTypeConfigDetails.
        Resource type.


        :param resource_type: The resource_type of this ResourceTypeConfigDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def availability_metrics_config(self):
        """
        Gets the availability_metrics_config of this ResourceTypeConfigDetails.

        :return: The availability_metrics_config of this ResourceTypeConfigDetails.
        :rtype: oci.stack_monitoring.models.AvailabilityMetricsDetails
        """
        return self._availability_metrics_config

    @availability_metrics_config.setter
    def availability_metrics_config(self, availability_metrics_config):
        """
        Sets the availability_metrics_config of this ResourceTypeConfigDetails.

        :param availability_metrics_config: The availability_metrics_config of this ResourceTypeConfigDetails.
        :type: oci.stack_monitoring.models.AvailabilityMetricsDetails
        """
        self._availability_metrics_config = availability_metrics_config

    @property
    def handler_config(self):
        """
        Gets the handler_config of this ResourceTypeConfigDetails.

        :return: The handler_config of this ResourceTypeConfigDetails.
        :rtype: oci.stack_monitoring.models.AgentExtensionHandlerConfiguration
        """
        return self._handler_config

    @handler_config.setter
    def handler_config(self, handler_config):
        """
        Sets the handler_config of this ResourceTypeConfigDetails.

        :param handler_config: The handler_config of this ResourceTypeConfigDetails.
        :type: oci.stack_monitoring.models.AgentExtensionHandlerConfiguration
        """
        self._handler_config = handler_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
