# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TelegrafResourceNameConfigurationDetails(object):
    """
    Resource name generation overriding configurations for telegraf resource types.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TelegrafResourceNameConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_use_tags_only:
            The value to assign to the is_use_tags_only property of this TelegrafResourceNameConfigurationDetails.
        :type is_use_tags_only: bool

        :param include_tags:
            The value to assign to the include_tags property of this TelegrafResourceNameConfigurationDetails.
        :type include_tags: list[str]

        :param exclude_tags:
            The value to assign to the exclude_tags property of this TelegrafResourceNameConfigurationDetails.
        :type exclude_tags: list[str]

        """
        self.swagger_types = {
            'is_use_tags_only': 'bool',
            'include_tags': 'list[str]',
            'exclude_tags': 'list[str]'
        }
        self.attribute_map = {
            'is_use_tags_only': 'isUseTagsOnly',
            'include_tags': 'includeTags',
            'exclude_tags': 'excludeTags'
        }
        self._is_use_tags_only = None
        self._include_tags = None
        self._exclude_tags = None

    @property
    def is_use_tags_only(self):
        """
        Gets the is_use_tags_only of this TelegrafResourceNameConfigurationDetails.
        Flag to indicate if only tags will be used for resource name generation.


        :return: The is_use_tags_only of this TelegrafResourceNameConfigurationDetails.
        :rtype: bool
        """
        return self._is_use_tags_only

    @is_use_tags_only.setter
    def is_use_tags_only(self, is_use_tags_only):
        """
        Sets the is_use_tags_only of this TelegrafResourceNameConfigurationDetails.
        Flag to indicate if only tags will be used for resource name generation.


        :param is_use_tags_only: The is_use_tags_only of this TelegrafResourceNameConfigurationDetails.
        :type: bool
        """
        self._is_use_tags_only = is_use_tags_only

    @property
    def include_tags(self):
        """
        Gets the include_tags of this TelegrafResourceNameConfigurationDetails.
        List of tag names to be included.


        :return: The include_tags of this TelegrafResourceNameConfigurationDetails.
        :rtype: list[str]
        """
        return self._include_tags

    @include_tags.setter
    def include_tags(self, include_tags):
        """
        Sets the include_tags of this TelegrafResourceNameConfigurationDetails.
        List of tag names to be included.


        :param include_tags: The include_tags of this TelegrafResourceNameConfigurationDetails.
        :type: list[str]
        """
        self._include_tags = include_tags

    @property
    def exclude_tags(self):
        """
        Gets the exclude_tags of this TelegrafResourceNameConfigurationDetails.
        List of tag names to be excluded.


        :return: The exclude_tags of this TelegrafResourceNameConfigurationDetails.
        :rtype: list[str]
        """
        return self._exclude_tags

    @exclude_tags.setter
    def exclude_tags(self, exclude_tags):
        """
        Sets the exclude_tags of this TelegrafResourceNameConfigurationDetails.
        List of tag names to be excluded.


        :param exclude_tags: The exclude_tags of this TelegrafResourceNameConfigurationDetails.
        :type: list[str]
        """
        self._exclude_tags = exclude_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
