# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180608

from .secret_generation_context import SecretGenerationContext
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PassphraseGenerationContext(SecretGenerationContext):
    """
    Generates Passphrase type secrets. By default, passphrase type secrets have no structure. The generated content is stored in Base64 format.
    The SecretTemplate must have the %GENERATED_PASSPHRASE% keyword, which is later replaced with the generated content, if provided.
    """

    #: A constant which can be used with the generation_template property of a PassphraseGenerationContext.
    #: This constant has a value of "SECRETS_DEFAULT_PASSWORD"
    GENERATION_TEMPLATE_SECRETS_DEFAULT_PASSWORD = "SECRETS_DEFAULT_PASSWORD"

    #: A constant which can be used with the generation_template property of a PassphraseGenerationContext.
    #: This constant has a value of "DBAAS_DEFAULT_PASSWORD"
    GENERATION_TEMPLATE_DBAAS_DEFAULT_PASSWORD = "DBAAS_DEFAULT_PASSWORD"

    def __init__(self, **kwargs):
        """
        Initializes a new PassphraseGenerationContext object with values from keyword arguments. The default value of the :py:attr:`~oci.vault.models.PassphraseGenerationContext.generation_type` attribute
        of this class is ``PASSPHRASE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param generation_type:
            The value to assign to the generation_type property of this PassphraseGenerationContext.
            Allowed values for this property are: "PASSPHRASE", "SSH_KEY", "BYTES", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type generation_type: str

        :param secret_template:
            The value to assign to the secret_template property of this PassphraseGenerationContext.
        :type secret_template: str

        :param generation_template:
            The value to assign to the generation_template property of this PassphraseGenerationContext.
            Allowed values for this property are: "SECRETS_DEFAULT_PASSWORD", "DBAAS_DEFAULT_PASSWORD", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type generation_template: str

        :param passphrase_length:
            The value to assign to the passphrase_length property of this PassphraseGenerationContext.
        :type passphrase_length: int

        """
        self.swagger_types = {
            'generation_type': 'str',
            'secret_template': 'str',
            'generation_template': 'str',
            'passphrase_length': 'int'
        }
        self.attribute_map = {
            'generation_type': 'generationType',
            'secret_template': 'secretTemplate',
            'generation_template': 'generationTemplate',
            'passphrase_length': 'passphraseLength'
        }
        self._generation_type = None
        self._secret_template = None
        self._generation_template = None
        self._passphrase_length = None
        self._generation_type = 'PASSPHRASE'

    @property
    def generation_template(self):
        """
        **[Required]** Gets the generation_template of this PassphraseGenerationContext.
        Name of passphrase generation template to generate passphrase type secret.

        Allowed values for this property are: "SECRETS_DEFAULT_PASSWORD", "DBAAS_DEFAULT_PASSWORD", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The generation_template of this PassphraseGenerationContext.
        :rtype: str
        """
        return self._generation_template

    @generation_template.setter
    def generation_template(self, generation_template):
        """
        Sets the generation_template of this PassphraseGenerationContext.
        Name of passphrase generation template to generate passphrase type secret.


        :param generation_template: The generation_template of this PassphraseGenerationContext.
        :type: str
        """
        allowed_values = ["SECRETS_DEFAULT_PASSWORD", "DBAAS_DEFAULT_PASSWORD"]
        if not value_allowed_none_or_none_sentinel(generation_template, allowed_values):
            generation_template = 'UNKNOWN_ENUM_VALUE'
        self._generation_template = generation_template

    @property
    def passphrase_length(self):
        """
        Gets the passphrase_length of this PassphraseGenerationContext.
        Length of the passphrase to be generated


        :return: The passphrase_length of this PassphraseGenerationContext.
        :rtype: int
        """
        return self._passphrase_length

    @passphrase_length.setter
    def passphrase_length(self, passphrase_length):
        """
        Sets the passphrase_length of this PassphraseGenerationContext.
        Length of the passphrase to be generated


        :param passphrase_length: The passphrase_length of this PassphraseGenerationContext.
        :type: int
        """
        self._passphrase_length = passphrase_length

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
