# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_create_details import DrgAttachmentNetworkCreateDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LoopBackDrgAttachmentNetworkCreateDetails(DrgAttachmentNetworkCreateDetails):
    """
    Specifies the Loopback attachment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LoopBackDrgAttachmentNetworkCreateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.LoopBackDrgAttachmentNetworkCreateDetails.type` attribute
        of this class is ``LOOPBACK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this LoopBackDrgAttachmentNetworkCreateDetails.
            Allowed values for this property are: "VCN", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "IPSEC_TUNNEL", "LOOPBACK", "FLEX_TUNNEL", "INTERNET"
        :type type: str

        :param id:
            The value to assign to the id property of this LoopBackDrgAttachmentNetworkCreateDetails.
        :type id: str

        :param loop_back_ip:
            The value to assign to the loop_back_ip property of this LoopBackDrgAttachmentNetworkCreateDetails.
        :type loop_back_ip: str

        :param ids:
            The value to assign to the ids property of this LoopBackDrgAttachmentNetworkCreateDetails.
        :type ids: list[str]

        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str',
            'loop_back_ip': 'str',
            'ids': 'list[str]'
        }
        self.attribute_map = {
            'type': 'type',
            'id': 'id',
            'loop_back_ip': 'loopBackIp',
            'ids': 'ids'
        }
        self._type = None
        self._id = None
        self._loop_back_ip = None
        self._ids = None
        self._type = 'LOOPBACK'

    @property
    def loop_back_ip(self):
        """
        **[Required]** Gets the loop_back_ip of this LoopBackDrgAttachmentNetworkCreateDetails.
        the oracle ip address of the tunnel headend.


        :return: The loop_back_ip of this LoopBackDrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._loop_back_ip

    @loop_back_ip.setter
    def loop_back_ip(self, loop_back_ip):
        """
        Sets the loop_back_ip of this LoopBackDrgAttachmentNetworkCreateDetails.
        the oracle ip address of the tunnel headend.


        :param loop_back_ip: The loop_back_ip of this LoopBackDrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._loop_back_ip = loop_back_ip

    @property
    def ids(self):
        """
        **[Required]** Gets the ids of this LoopBackDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of the network attached to the DRG.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The ids of this LoopBackDrgAttachmentNetworkCreateDetails.
        :rtype: list[str]
        """
        return self._ids

    @ids.setter
    def ids(self, ids):
        """
        Sets the ids of this LoopBackDrgAttachmentNetworkCreateDetails.
        The `OCID`__ of the network attached to the DRG.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param ids: The ids of this LoopBackDrgAttachmentNetworkCreateDetails.
        :type: list[str]
        """
        self._ids = ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
