/* This file is autogenerated by tracetool, do not edit. */
/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef TRACE_HW_PCI_GENERATED_TRACERS_H
#define TRACE_HW_PCI_GENERATED_TRACERS_H

#include "trace/control.h"

extern TraceEvent _TRACE_PCI_PM_BAD_TRANSITION_EVENT;
extern TraceEvent _TRACE_PCI_PM_TRANSITION_EVENT;
extern TraceEvent _TRACE_PCI_UPDATE_MAPPINGS_DEL_EVENT;
extern TraceEvent _TRACE_PCI_UPDATE_MAPPINGS_ADD_EVENT;
extern TraceEvent _TRACE_PCI_ROUTE_IRQ_EVENT;
extern TraceEvent _TRACE_PCI_BAD_ROM_MAGIC_EVENT;
extern TraceEvent _TRACE_PCI_BAD_PCIR_OFFSET_EVENT;
extern TraceEvent _TRACE_PCI_ROM_AND_PCI_IDS_EVENT;
extern TraceEvent _TRACE_PCI_ROM_CHECKSUM_CHANGE_EVENT;
extern TraceEvent _TRACE_PCI_CFG_READ_EVENT;
extern TraceEvent _TRACE_PCI_CFG_WRITE_EVENT;
extern TraceEvent _TRACE_MSIX_WRITE_CONFIG_EVENT;
extern TraceEvent _TRACE_SRIOV_REGISTER_VFS_EVENT;
extern TraceEvent _TRACE_SRIOV_UNREGISTER_VFS_EVENT;
extern TraceEvent _TRACE_SRIOV_CONFIG_WRITE_EVENT;
extern TraceEvent _TRACE_PCIE_CAP_SLOT_WRITE_CONFIG_EVENT;
extern TraceEvent _TRACE_SHPC_SLOT_COMMAND_EVENT;
extern uint16_t _TRACE_PCI_PM_BAD_TRANSITION_DSTATE;
extern uint16_t _TRACE_PCI_PM_TRANSITION_DSTATE;
extern uint16_t _TRACE_PCI_UPDATE_MAPPINGS_DEL_DSTATE;
extern uint16_t _TRACE_PCI_UPDATE_MAPPINGS_ADD_DSTATE;
extern uint16_t _TRACE_PCI_ROUTE_IRQ_DSTATE;
extern uint16_t _TRACE_PCI_BAD_ROM_MAGIC_DSTATE;
extern uint16_t _TRACE_PCI_BAD_PCIR_OFFSET_DSTATE;
extern uint16_t _TRACE_PCI_ROM_AND_PCI_IDS_DSTATE;
extern uint16_t _TRACE_PCI_ROM_CHECKSUM_CHANGE_DSTATE;
extern uint16_t _TRACE_PCI_CFG_READ_DSTATE;
extern uint16_t _TRACE_PCI_CFG_WRITE_DSTATE;
extern uint16_t _TRACE_MSIX_WRITE_CONFIG_DSTATE;
extern uint16_t _TRACE_SRIOV_REGISTER_VFS_DSTATE;
extern uint16_t _TRACE_SRIOV_UNREGISTER_VFS_DSTATE;
extern uint16_t _TRACE_SRIOV_CONFIG_WRITE_DSTATE;
extern uint16_t _TRACE_PCIE_CAP_SLOT_WRITE_CONFIG_DSTATE;
extern uint16_t _TRACE_SHPC_SLOT_COMMAND_DSTATE;
#define TRACE_PCI_PM_BAD_TRANSITION_ENABLED 1
#define TRACE_PCI_PM_TRANSITION_ENABLED 1
#define TRACE_PCI_UPDATE_MAPPINGS_DEL_ENABLED 1
#define TRACE_PCI_UPDATE_MAPPINGS_ADD_ENABLED 1
#define TRACE_PCI_ROUTE_IRQ_ENABLED 1
#define TRACE_PCI_BAD_ROM_MAGIC_ENABLED 1
#define TRACE_PCI_BAD_PCIR_OFFSET_ENABLED 1
#define TRACE_PCI_ROM_AND_PCI_IDS_ENABLED 1
#define TRACE_PCI_ROM_CHECKSUM_CHANGE_ENABLED 1
#define TRACE_PCI_CFG_READ_ENABLED 1
#define TRACE_PCI_CFG_WRITE_ENABLED 1
#define TRACE_MSIX_WRITE_CONFIG_ENABLED 1
#define TRACE_SRIOV_REGISTER_VFS_ENABLED 1
#define TRACE_SRIOV_UNREGISTER_VFS_ENABLED 1
#define TRACE_SRIOV_CONFIG_WRITE_ENABLED 1
#define TRACE_PCIE_CAP_SLOT_WRITE_CONFIG_ENABLED 1
#define TRACE_SHPC_SLOT_COMMAND_ENABLED 1
#include "qemu/log-for-trace.h"


#define TRACE_PCI_PM_BAD_TRANSITION_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_PM_BAD_TRANSITION) || \
    false)

static inline void trace_pci_pm_bad_transition(const char *dev, uint32_t bus, uint32_t slot, uint32_t func, uint8_t old, uint8_t new)
{
    if (trace_event_get_state(TRACE_PCI_PM_BAD_TRANSITION)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 4 "../hw/pci/trace-events"
            qemu_log("pci_pm_bad_transition " "%s %02x:%02x.%x REJECTED PM transition D%d->D%d" "\n", dev, bus, slot, func, old, new);
#line 74 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_PM_TRANSITION_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_PM_TRANSITION) || \
    false)

static inline void trace_pci_pm_transition(const char *dev, uint32_t bus, uint32_t slot, uint32_t func, uint8_t old, uint8_t new)
{
    if (trace_event_get_state(TRACE_PCI_PM_TRANSITION)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 5 "../hw/pci/trace-events"
            qemu_log("pci_pm_transition " "%s %02x:%02x.%x PM transition D%d->D%d" "\n", dev, bus, slot, func, old, new);
#line 89 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_UPDATE_MAPPINGS_DEL_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_UPDATE_MAPPINGS_DEL) || \
    false)

static inline void trace_pci_update_mappings_del(const char *dev, uint32_t bus, uint32_t slot, uint32_t func, int bar, uint64_t addr, uint64_t size)
{
    if (trace_event_get_state(TRACE_PCI_UPDATE_MAPPINGS_DEL)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 6 "../hw/pci/trace-events"
            qemu_log("pci_update_mappings_del " "%s %02x:%02x.%x %d,0x%"PRIx64"+0x%"PRIx64 "\n", dev, bus, slot, func, bar, addr, size);
#line 104 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_UPDATE_MAPPINGS_ADD_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_UPDATE_MAPPINGS_ADD) || \
    false)

static inline void trace_pci_update_mappings_add(const char *dev, uint32_t bus, uint32_t slot, uint32_t func, int bar, uint64_t addr, uint64_t size)
{
    if (trace_event_get_state(TRACE_PCI_UPDATE_MAPPINGS_ADD)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 7 "../hw/pci/trace-events"
            qemu_log("pci_update_mappings_add " "%s %02x:%02x.%x %d,0x%"PRIx64"+0x%"PRIx64 "\n", dev, bus, slot, func, bar, addr, size);
#line 119 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_ROUTE_IRQ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_ROUTE_IRQ) || \
    false)

static inline void trace_pci_route_irq(int dev_irq, const char *dev_path, int parent_irq, const char *parent_path)
{
    if (trace_event_get_state(TRACE_PCI_ROUTE_IRQ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 8 "../hw/pci/trace-events"
            qemu_log("pci_route_irq " "IRQ %d @%s -> IRQ %d @%s" "\n", dev_irq, dev_path, parent_irq, parent_path);
#line 134 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_BAD_ROM_MAGIC_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_BAD_ROM_MAGIC) || \
    false)

static inline void trace_pci_bad_rom_magic(uint16_t bad_rom_magic, uint16_t good_rom_magic)
{
    if (trace_event_get_state(TRACE_PCI_BAD_ROM_MAGIC)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 9 "../hw/pci/trace-events"
            qemu_log("pci_bad_rom_magic " "Bad ROM magic number: %04"PRIX16". Should be: %04"PRIX16 "\n", bad_rom_magic, good_rom_magic);
#line 149 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_BAD_PCIR_OFFSET_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_BAD_PCIR_OFFSET) || \
    false)

static inline void trace_pci_bad_pcir_offset(uint16_t pcir_offset)
{
    if (trace_event_get_state(TRACE_PCI_BAD_PCIR_OFFSET)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 10 "../hw/pci/trace-events"
            qemu_log("pci_bad_pcir_offset " "Bad PCIR offset 0x%"PRIx16" or signature" "\n", pcir_offset);
#line 164 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_ROM_AND_PCI_IDS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_ROM_AND_PCI_IDS) || \
    false)

static inline void trace_pci_rom_and_pci_ids(char *romfile, uint16_t vendor_id, uint16_t device_id, uint16_t rom_vendor_id, uint16_t rom_device_id)
{
    if (trace_event_get_state(TRACE_PCI_ROM_AND_PCI_IDS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 11 "../hw/pci/trace-events"
            qemu_log("pci_rom_and_pci_ids " "%s: ROM ID %04"PRIx16":%04"PRIx16" | PCI ID %04"PRIx16":%04"PRIx16 "\n", romfile, vendor_id, device_id, rom_vendor_id, rom_device_id);
#line 179 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_ROM_CHECKSUM_CHANGE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_ROM_CHECKSUM_CHANGE) || \
    false)

static inline void trace_pci_rom_checksum_change(uint8_t old_checksum, uint8_t new_checksum)
{
    if (trace_event_get_state(TRACE_PCI_ROM_CHECKSUM_CHANGE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 12 "../hw/pci/trace-events"
            qemu_log("pci_rom_checksum_change " "ROM checksum changed from %02"PRIx8" to %02"PRIx8 "\n", old_checksum, new_checksum);
#line 194 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_CFG_READ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_CFG_READ) || \
    false)

static inline void trace_pci_cfg_read(const char *dev, uint32_t bus, uint32_t slot, uint32_t func, unsigned offs, unsigned val)
{
    if (trace_event_get_state(TRACE_PCI_CFG_READ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 15 "../hw/pci/trace-events"
            qemu_log("pci_cfg_read " "%s %02x:%02x.%x @0x%x -> 0x%x" "\n", dev, bus, slot, func, offs, val);
#line 209 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCI_CFG_WRITE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCI_CFG_WRITE) || \
    false)

static inline void trace_pci_cfg_write(const char *dev, uint32_t bus, uint32_t slot, uint32_t func, unsigned offs, unsigned val)
{
    if (trace_event_get_state(TRACE_PCI_CFG_WRITE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 16 "../hw/pci/trace-events"
            qemu_log("pci_cfg_write " "%s %02x:%02x.%x @0x%x <- 0x%x" "\n", dev, bus, slot, func, offs, val);
#line 224 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_MSIX_WRITE_CONFIG_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_MSIX_WRITE_CONFIG) || \
    false)

static inline void trace_msix_write_config(char *name, bool enabled, bool masked)
{
    if (trace_event_get_state(TRACE_MSIX_WRITE_CONFIG)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 19 "../hw/pci/trace-events"
            qemu_log("msix_write_config " "dev %s enabled %d masked %d" "\n", name, enabled, masked);
#line 239 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_SRIOV_REGISTER_VFS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_SRIOV_REGISTER_VFS) || \
    false)

static inline void trace_sriov_register_vfs(const char *name, int slot, int function, int num_vfs)
{
    if (trace_event_get_state(TRACE_SRIOV_REGISTER_VFS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 22 "../hw/pci/trace-events"
            qemu_log("sriov_register_vfs " "%s %02x:%x: creating %d vf devs" "\n", name, slot, function, num_vfs);
#line 254 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_SRIOV_UNREGISTER_VFS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_SRIOV_UNREGISTER_VFS) || \
    false)

static inline void trace_sriov_unregister_vfs(const char *name, int slot, int function)
{
    if (trace_event_get_state(TRACE_SRIOV_UNREGISTER_VFS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 23 "../hw/pci/trace-events"
            qemu_log("sriov_unregister_vfs " "%s %02x:%x: Unregistering vf devs" "\n", name, slot, function);
#line 269 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_SRIOV_CONFIG_WRITE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_SRIOV_CONFIG_WRITE) || \
    false)

static inline void trace_sriov_config_write(const char *name, int slot, int fun, uint32_t offset, uint32_t val, uint32_t len)
{
    if (trace_event_get_state(TRACE_SRIOV_CONFIG_WRITE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 24 "../hw/pci/trace-events"
            qemu_log("sriov_config_write " "%s %02x:%x: sriov offset 0x%x val 0x%x len %d" "\n", name, slot, fun, offset, val, len);
#line 284 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_PCIE_CAP_SLOT_WRITE_CONFIG_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_PCIE_CAP_SLOT_WRITE_CONFIG) || \
    false)

static inline void trace_pcie_cap_slot_write_config(const char *parent, const char *child, const char *pds, const char *old_pic, const char *new_pic, const char *old_aic, const char *new_aic, const char *old_power, const char *new_power)
{
    if (trace_event_get_state(TRACE_PCIE_CAP_SLOT_WRITE_CONFIG)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 27 "../hw/pci/trace-events"
            qemu_log("pcie_cap_slot_write_config " "%s > %s: pds: %s, pic: %s->%s, aic: %s->%s, power: %s->%s" "\n", parent, child, pds, old_pic, new_pic, old_aic, new_aic, old_power, new_power);
#line 299 "trace/trace-hw_pci.h"
        }
    }
}

#define TRACE_SHPC_SLOT_COMMAND_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_SHPC_SLOT_COMMAND) || \
    false)

static inline void trace_shpc_slot_command(const char *parent, int pci_slot, const char *child, const char *old_pic, const char *new_pic, const char *old_aic, const char *new_aic, const char *old_state, const char *new_state)
{
    if (trace_event_get_state(TRACE_SHPC_SLOT_COMMAND)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 30 "../hw/pci/trace-events"
            qemu_log("shpc_slot_command " "%s[%d] > %s: pic: %s->%s, aic: %s->%s, state: %s->%s" "\n", parent, pci_slot, child, old_pic, new_pic, old_aic, new_aic, old_state, new_state);
#line 314 "trace/trace-hw_pci.h"
        }
    }
}
#endif /* TRACE_HW_PCI_GENERATED_TRACERS_H */
