#pragma once

// libHttp = 0x80710001 - 0x80710fff
// libHttps = 0x80710a01 - 0x80710aff

enum
{
	CELL_HTTP_MAX_USERNAME = 256,
	CELL_HTTP_MAX_PASSWORD = 256,
};

enum
{
	CELL_HTTP_NET_ERROR_TYPE_MASK = 0xffffff00,
	CELL_HTTP_NET_ERROR_MASK      = 0xff,

	CELL_HTTP_ERROR_NET_RESOLVER = 0x80710100,
	CELL_HTTP_ERROR_NET_ABORT    = 0x80710200,
	CELL_HTTP_ERROR_NET_OPTION   = 0x80710300,
	CELL_HTTP_ERROR_NET_SOCKET   = 0x80710400,
	CELL_HTTP_ERROR_NET_CONNECT  = 0x80710500,
	CELL_HTTP_ERROR_NET_SEND     = 0x80710600,
	CELL_HTTP_ERROR_NET_RECV     = 0x80710700,
	CELL_HTTP_ERROR_NET_SELECT   = 0x80710800,

	// CELL_HTTP_NET_ERROR
	// CELL_HTTP_IS_NET_RESOLVER_ERROR
};

// Error Codes - Http
enum CellHttpError
{
	CELL_HTTP_ERROR_ALREADY_INITIALIZED       = 0x80710001,
	CELL_HTTP_ERROR_NOT_INITIALIZED           = 0x80710002,
	CELL_HTTP_ERROR_NO_MEMORY                 = 0x80710003,
	CELL_HTTP_ERROR_NO_BUFFER                 = 0x80710004,
	CELL_HTTP_ERROR_NO_STRING                 = 0x80710005,
	CELL_HTTP_ERROR_INSUFFICIENT              = 0x80710006,
	CELL_HTTP_ERROR_INVALID_URI               = 0x80710007,
	CELL_HTTP_ERROR_INVALID_HEADER            = 0x80710008,
	CELL_HTTP_ERROR_BAD_METHOD                = 0x80710009,
	CELL_HTTP_ERROR_BAD_CLIENT                = 0x80710010,
	CELL_HTTP_ERROR_BAD_TRANS                 = 0x80710011,
	CELL_HTTP_ERROR_NO_CONNECTION             = 0x80710012,
	CELL_HTTP_ERROR_NO_REQUEST_SENT           = 0x80710013,
	CELL_HTTP_ERROR_ALREADY_BUILT             = 0x80710014,
	CELL_HTTP_ERROR_ALREADY_SENT              = 0x80710015,
	CELL_HTTP_ERROR_NO_HEADER                 = 0x80710016,
	CELL_HTTP_ERROR_NO_CONTENT_LENGTH         = 0x80710017,
	CELL_HTTP_ERROR_TOO_MANY_REDIRECTS        = 0x80710018,
	CELL_HTTP_ERROR_TOO_MANY_AUTHS            = 0x80710019,
	CELL_HTTP_ERROR_TRANS_NO_CONNECTION       = 0x80710020,
	CELL_HTTP_ERROR_CB_FAILED                 = 0x80710021,
	CELL_HTTP_ERROR_NOT_PIPED                 = 0x80710022,
	CELL_HTTP_ERROR_OUT_OF_ORDER_PIPE         = 0x80710023,
	CELL_HTTP_ERROR_TRANS_ABORTED             = 0x80710024,
	CELL_HTTP_ERROR_BROKEN_PIPELINE           = 0x80710025,
	CELL_HTTP_ERROR_UNAVAILABLE               = 0x80710026,
	CELL_HTTP_ERROR_INVALID_VALUE             = 0x80710027,
	CELL_HTTP_ERROR_CANNOT_AUTHENTICATE       = 0x80710028,
	CELL_HTTP_ERROR_COOKIE_NOT_FOUND          = 0x80710041,
	CELL_HTTP_ERROR_COOKIE_INVALID_DOMAIN     = 0x80710042,
	CELL_HTTP_ERROR_CACHE_ALREADY_INITIALIZED = 0x80710043,
	CELL_HTTP_ERROR_CACHE_NOT_INITIALIZED     = 0x80710044,
	CELL_HTTP_ERROR_LINE_EXCEEDS_MAX          = 0x80710045,
	CELL_HTTP_ERROR_REQUIRES_BASIC_AUTH       = 0x80710046,

	CELL_HTTP_ERROR_UNKNOWN              = 0x80710051,
	CELL_HTTP_ERROR_INTERNAL             = 0x80710052,
	CELL_HTTP_ERROR_NONREMOVABLE         = 0x80710053,
	CELL_HTTP_ERROR_BAD_CONN             = 0x80710054,
	CELL_HTTP_ERROR_BAD_MAN              = 0x80710055,
	CELL_HTTP_ERROR_NO_POOL              = 0x80710056,
	CELL_HTTP_ERROR_NO_REQUEST           = 0x80710057,
	CELL_HTTP_ERROR_LOCK_FAILED          = 0x80710058,
	CELL_HTTP_ERROR_INVALID_DATA         = 0x80710059,
	CELL_HTTP_ERROR_BROKEN_CHUNK         = 0x8071005a,
	CELL_HTTP_ERROR_DECODE_SETUP         = 0x8071005b,
	CELL_HTTP_ERROR_DECODE_STREAM        = 0x8071005c,
	CELL_HTTP_ERROR_BROKEN_DECODE_STREAM = 0x8071005d,

	CELL_HTTP_ERROR_INVALID_DCACHE_PATH          = 0x80710060,
	CELL_HTTP_ERROR_DCACHE_ALREADY_INITIALIZED   = 0x80710061,
	CELL_HTTP_ERROR_DCACHE_NOT_INITIALIZED       = 0x80710062,
	CELL_HTTP_ERROR_TOO_MANY_DCACHE_ENTRY        = 0x80710063,
	CELL_HTTP_ERROR_DUP_DCACHE_ENTRY             = 0x80710064,
	CELL_HTTP_ERROR_WRITE_DCACHE                 = 0x80710065,
	CELL_HTTP_ERROR_READ_DCACHE                  = 0x80710066,
	CELL_HTTP_ERROR_CACHE_TOO_LARGE              = 0x80710067,
	CELL_HTTP_ERROR_INVALID_DCACHE_VERSION       = 0x80710068,
	CELL_HTTP_ERROR_DCACHE_FILE_BROKEN           = 0x80710069,
	CELL_HTTP_ERROR_DCACHE_EXCEEDS_MAX           = 0x8071006a,
	CELL_HTTP_ERROR_DCACHE_BUSY                  = 0x8071006b,
	CELL_HTTP_ERROR_DCACHE_INDEX_BROKEN          = 0x8071006c,
	CELL_HTTP_ERROR_INVALID_DCACHE_INDEX_NODE    = 0x8071006d,
	CELL_HTTP_ERROR_DCACHE_FILE_INCONSISTENCY    = 0x8071006e,
	CELL_HTTP_ERROR_DCACHE_URI_TOO_LONG          = 0x8071006f,
	CELL_HTTP_ERROR_READ_DCACHE_EOF              = 0x80710070,
	CELL_HTTP_ERROR_END_OF_DCACHE_INDEX_NODE     = 0x80710071,
	CELL_HTTP_ERROR_NO_CACHE_MEMORY              = 0x80710072,
	CELL_HTTP_ERROR_DCACHE_BROKEN                = 0x80710073,
	CELL_HTTP_ERROR_DCACHE_TOO_MANY_WRITE        = 0x80710074,
	CELL_HTTP_ERROR_DCACHE_TOO_MANY_READ         = 0x80710075,
	CELL_HTTP_ERROR_DCACHE_FATAL                 = 0x80710076,
	CELL_HTTP_ERROR_DCACHE_UNSUPPORTED_FEATURE   = 0x80710077,
	CELL_HTTP_ERROR_DCACHE_INDEX_IS_ALREADY_OPEN = 0x80710078,
	CELL_HTTP_ERROR_DCACHE_INDEX_IS_OPENING      = 0x80710079,
	CELL_HTTP_ERROR_DCACHE_UNKNOWN               = 0x80710080,
	CELL_HTTP_ERROR_DCACHE_INDEX_IS_CLOSED       = 0x80710081,
	CELL_HTTP_ERROR_DCACHE_ABORTED               = 0x80710082,
	CELL_HTTP_ERROR_DCACHE_INDEX_IS_CLOSING      = 0x80710083,
	CELL_HTTP_ERROR_DCACHE_UNKNOWN_INDEX_STATE   = 0x80710084,

	CELL_HTTP_ERROR_NET_FIN             = 0x80710091,
	CELL_HTTP_ERROR_NET_CONNECT_TIMEOUT = 0x80710092,
	CELL_HTTP_ERROR_NET_SELECT_TIMEOUT  = 0x80710093,
	CELL_HTTP_ERROR_NET_SEND_TIMEOUT    = 0x80710094,
};

// Error Codes - Https
enum CellHttpsError : u32
{
	CELL_HTTPS_ERROR_CERTIFICATE_LOAD    = 0x80710a01,
	CELL_HTTPS_ERROR_BAD_MEMORY          = 0x80710a02,
	CELL_HTTPS_ERROR_CONTEXT_CREATION    = 0x80710a03,
	CELL_HTTPS_ERROR_CONNECTION_CREATION = 0x80710a04,
	CELL_HTTPS_ERROR_SOCKET_ASSOCIATION  = 0x80710a05,
	CELL_HTTPS_ERROR_HANDSHAKE           = 0x80710a06,
	CELL_HTTPS_ERROR_LOOKUP_CERTIFICATE  = 0x80710a07,
	CELL_HTTPS_ERROR_NO_SSL              = 0x80710a08,
	CELL_HTTPS_ERROR_KEY_LOAD            = 0x80710a09,
	CELL_HTTPS_ERROR_CERT_KEY_MISMATCH   = 0x80710a0a,
	CELL_HTTPS_ERROR_KEY_NEEDS_CERT      = 0x80710a0b,
	CELL_HTTPS_ERROR_CERT_NEEDS_KEY      = 0x80710a0c,
	CELL_HTTPS_ERROR_RETRY_CONNECTION    = 0x80710a0d,
	CELL_HTTPS_ERROR_NET_SSL_CONNECT     = 0x80710b00,
	CELL_HTTPS_ERROR_NET_SSL_SEND        = 0x80710c00,
	CELL_HTTPS_ERROR_NET_SSL_RECV        = 0x80710d00,
};

enum CellHttpErrorNet
{
	CELL_HTTP_ERROR_NET_RESOLVER_NETDB_INTERNAL = 0x807101ff,
	CELL_HTTP_ERROR_NET_RESOLVER_HOST_NOT_FOUND = 0x80710101,
	CELL_HTTP_ERROR_NET_RESOLVER_TRY_AGAIN      = 0x80710102,
	CELL_HTTP_ERROR_NET_RESOLVER_NO_RECOVERY    = 0x80710103,
	CELL_HTTP_ERROR_NET_RESOLVER_NO_DATA        = 0x80710104,
	CELL_HTTP_ERROR_NET_RESOLVER_NO_ADDRESS     = 0x80710104,

	CELL_HTTP_ERROR_NET_ABORT_EPERM           = 0x80710201,
	CELL_HTTP_ERROR_NET_ABORT_ENOENT          = 0x80710202,
	CELL_HTTP_ERROR_NET_ABORT_ESRCH           = 0x80710203,
	CELL_HTTP_ERROR_NET_ABORT_EINTR           = 0x80710204,
	CELL_HTTP_ERROR_NET_ABORT_EIO             = 0x80710205,
	CELL_HTTP_ERROR_NET_ABORT_ENXIO           = 0x80710206,
	CELL_HTTP_ERROR_NET_ABORT_E2BIG           = 0x80710207,
	CELL_HTTP_ERROR_NET_ABORT_ENOEXC          = 0x80710208,
	CELL_HTTP_ERROR_NET_ABORT_EBADF           = 0x80710209,
	CELL_HTTP_ERROR_NET_ABORT_ECHILD          = 0x8071020a,
	CELL_HTTP_ERROR_NET_ABORT_EDEADLK         = 0x8071020b,
	CELL_HTTP_ERROR_NET_ABORT_ENOMEM          = 0x8071020c,
	CELL_HTTP_ERROR_NET_ABORT_EACCES          = 0x8071020d,
	CELL_HTTP_ERROR_NET_ABORT_EFAULT          = 0x8071020e,
	CELL_HTTP_ERROR_NET_ABORT_ENOTBLK         = 0x8071020f,
	CELL_HTTP_ERROR_NET_ABORT_EBUSY           = 0x80710210,
	CELL_HTTP_ERROR_NET_ABORT_EEXIST          = 0x80710211,
	CELL_HTTP_ERROR_NET_ABORT_EXDEV           = 0x80710212,
	CELL_HTTP_ERROR_NET_ABORT_ENODEV          = 0x80710213,
	CELL_HTTP_ERROR_NET_ABORT_ENOTDIR         = 0x80710214,
	CELL_HTTP_ERROR_NET_ABORT_EISDIR          = 0x80710215,
	CELL_HTTP_ERROR_NET_ABORT_EINVAL          = 0x80710216,
	CELL_HTTP_ERROR_NET_ABORT_ENFILE          = 0x80710217,
	CELL_HTTP_ERROR_NET_ABORT_EMFILE          = 0x80710218,
	CELL_HTTP_ERROR_NET_ABORT_ENOTTY          = 0x80710219,
	CELL_HTTP_ERROR_NET_ABORT_ETXTBSY         = 0x8071021a,
	CELL_HTTP_ERROR_NET_ABORT_EFBIG           = 0x8071021b,
	CELL_HTTP_ERROR_NET_ABORT_ENOSPC          = 0x8071021c,
	CELL_HTTP_ERROR_NET_ABORT_ESPIPE          = 0x8071021d,
	CELL_HTTP_ERROR_NET_ABORT_EROFS           = 0x8071021e,
	CELL_HTTP_ERROR_NET_ABORT_EMLINK          = 0x8071021f,
	CELL_HTTP_ERROR_NET_ABORT_EPIPE           = 0x80710220,
	CELL_HTTP_ERROR_NET_ABORT_EDOM            = 0x80710221,
	CELL_HTTP_ERROR_NET_ABORT_ERANGE          = 0x80710222,
	CELL_HTTP_ERROR_NET_ABORT_EAGAIN          = 0x80710223,
	CELL_HTTP_ERROR_NET_ABORT_EWOULDBLOCK     = 0x80710223,
	CELL_HTTP_ERROR_NET_ABORT_EINPROGRESS     = 0x80710224,
	CELL_HTTP_ERROR_NET_ABORT_EALREADY        = 0x80710225,
	CELL_HTTP_ERROR_NET_ABORT_ENOTSOCK        = 0x80710226,
	CELL_HTTP_ERROR_NET_ABORT_EDESTADDRREQ    = 0x80710227,
	CELL_HTTP_ERROR_NET_ABORT_EMSGSIZE        = 0x80710228,
	CELL_HTTP_ERROR_NET_ABORT_EPROTOTYPE      = 0x80710229,
	CELL_HTTP_ERROR_NET_ABORT_ENOPROTOOPT     = 0x8071022a,
	CELL_HTTP_ERROR_NET_ABORT_EPROTONOSUPPORT = 0x8071022b,
	CELL_HTTP_ERROR_NET_ABORT_ESOCKTNOSUPPORT = 0x8071022c,
	CELL_HTTP_ERROR_NET_ABORT_EOPNOTSUPP      = 0x8071022d,
	CELL_HTTP_ERROR_NET_ABORT_EPFNOSUPPORT    = 0x8071022e,
	CELL_HTTP_ERROR_NET_ABORT_EAFNOSUPPORT    = 0x8071022f,
	CELL_HTTP_ERROR_NET_ABORT_EADDRINUSE      = 0x80710230,
	CELL_HTTP_ERROR_NET_ABORT_EADDRNOTAVAIL   = 0x80710231,
	CELL_HTTP_ERROR_NET_ABORT_ENETDOWN        = 0x80710232,
	CELL_HTTP_ERROR_NET_ABORT_ENETUNREACH     = 0x80710233,
	CELL_HTTP_ERROR_NET_ABORT_ENETRESET       = 0x80710234,
	CELL_HTTP_ERROR_NET_ABORT_ECONNABORTED    = 0x80710235,
	CELL_HTTP_ERROR_NET_ABORT_ECONNRESET      = 0x80710236,
	CELL_HTTP_ERROR_NET_ABORT_ENOBUFS         = 0x80710237,
	CELL_HTTP_ERROR_NET_ABORT_EISCONN         = 0x80710238,
	CELL_HTTP_ERROR_NET_ABORT_ENOTCONN        = 0x80710239,
	CELL_HTTP_ERROR_NET_ABORT_ESHUTDOWN       = 0x8071023a,
	CELL_HTTP_ERROR_NET_ABORT_ETOOMANYREFS    = 0x8071023b,
	CELL_HTTP_ERROR_NET_ABORT_ETIMEDOUT       = 0x8071023c,
	CELL_HTTP_ERROR_NET_ABORT_ECONNREFUSED    = 0x8071023d,
	CELL_HTTP_ERROR_NET_ABORT_ELOOP           = 0x8071023e,
	CELL_HTTP_ERROR_NET_ABORT_ENAMETOOLONG    = 0x8071023f,
	CELL_HTTP_ERROR_NET_ABORT_EHOSTDOWN       = 0x80710240,
	CELL_HTTP_ERROR_NET_ABORT_EHOSTUNREACH    = 0x80710241,
	CELL_HTTP_ERROR_NET_ABORT_ENOTEMPTY       = 0x80710242,
	CELL_HTTP_ERROR_NET_ABORT_EPROCLIM        = 0x80710243,
	CELL_HTTP_ERROR_NET_ABORT_EUSERS          = 0x80710244,
	CELL_HTTP_ERROR_NET_ABORT_EDQUOT          = 0x80710245,
	CELL_HTTP_ERROR_NET_ABORT_ESTALE          = 0x80710246,
	CELL_HTTP_ERROR_NET_ABORT_EREMOTE         = 0x80710247,
	CELL_HTTP_ERROR_NET_ABORT_EBADRPC         = 0x80710248,
	CELL_HTTP_ERROR_NET_ABORT_ERPCMISMATCH    = 0x80710249,
	CELL_HTTP_ERROR_NET_ABORT_EPROGUNAVAIL    = 0x8071024a,
	CELL_HTTP_ERROR_NET_ABORT_EPROGMISMATCH   = 0x8071024b,
	CELL_HTTP_ERROR_NET_ABORT_EPROCUNAVAIL    = 0x8071024c,
	CELL_HTTP_ERROR_NET_ABORT_ENOLCK          = 0x8071024d,
	CELL_HTTP_ERROR_NET_ABORT_ENOSYS          = 0x8071024e,
	CELL_HTTP_ERROR_NET_ABORT_EFTYPE          = 0x8071024f,
	CELL_HTTP_ERROR_NET_ABORT_EAUTH           = 0x80710250,
	CELL_HTTP_ERROR_NET_ABORT_ENEEDAUTH       = 0x80710251,
	CELL_HTTP_ERROR_NET_ABORT_EIDRM           = 0x80710252,
	CELL_HTTP_ERROR_NET_ABORT_ENOMSG          = 0x80710253,
	CELL_HTTP_ERROR_NET_ABORT_EOVERFLOW       = 0x80710254,
	CELL_HTTP_ERROR_NET_ABORT_EILSEQ          = 0x80710255,
	CELL_HTTP_ERROR_NET_ABORT_ENOTSUP         = 0x80710256,
	CELL_HTTP_ERROR_NET_ABORT_ECANCELED       = 0x80710257,
	CELL_HTTP_ERROR_NET_ABORT_EBADMSG         = 0x80710258,
	CELL_HTTP_ERROR_NET_ABORT_ENODATA         = 0x80710259,
	CELL_HTTP_ERROR_NET_ABORT_ENOSR           = 0x8071025a,
	CELL_HTTP_ERROR_NET_ABORT_ENOSTR          = 0x8071025b,
	CELL_HTTP_ERROR_NET_ABORT_ETIME           = 0x8071025c,

	CELL_HTTP_ERROR_NET_OPTION_EPERM           = 0x80710301,
	CELL_HTTP_ERROR_NET_OPTION_ENOENT          = 0x80710302,
	CELL_HTTP_ERROR_NET_OPTION_ESRCH           = 0x80710303,
	CELL_HTTP_ERROR_NET_OPTION_EINTR           = 0x80710304,
	CELL_HTTP_ERROR_NET_OPTION_EIO             = 0x80710305,
	CELL_HTTP_ERROR_NET_OPTION_ENXIO           = 0x80710306,
	CELL_HTTP_ERROR_NET_OPTION_E2BIG           = 0x80710307,
	CELL_HTTP_ERROR_NET_OPTION_ENOEXC          = 0x80710308,
	CELL_HTTP_ERROR_NET_OPTION_EBADF           = 0x80710309,
	CELL_HTTP_ERROR_NET_OPTION_ECHILD          = 0x8071030a,
	CELL_HTTP_ERROR_NET_OPTION_EDEADLK         = 0x8071030b,
	CELL_HTTP_ERROR_NET_OPTION_ENOMEM          = 0x8071030c,
	CELL_HTTP_ERROR_NET_OPTION_EACCES          = 0x8071030d,
	CELL_HTTP_ERROR_NET_OPTION_EFAULT          = 0x8071030e,
	CELL_HTTP_ERROR_NET_OPTION_ENOTBLK         = 0x8071030f,
	CELL_HTTP_ERROR_NET_OPTION_EBUSY           = 0x80710310,
	CELL_HTTP_ERROR_NET_OPTION_EEXIST          = 0x80710311,
	CELL_HTTP_ERROR_NET_OPTION_EXDEV           = 0x80710312,
	CELL_HTTP_ERROR_NET_OPTION_ENODEV          = 0x80710313,
	CELL_HTTP_ERROR_NET_OPTION_ENOTDIR         = 0x80710314,
	CELL_HTTP_ERROR_NET_OPTION_EISDIR          = 0x80710315,
	CELL_HTTP_ERROR_NET_OPTION_EINVAL          = 0x80710316,
	CELL_HTTP_ERROR_NET_OPTION_ENFILE          = 0x80710317,
	CELL_HTTP_ERROR_NET_OPTION_EMFILE          = 0x80710318,
	CELL_HTTP_ERROR_NET_OPTION_ENOTTY          = 0x80710319,
	CELL_HTTP_ERROR_NET_OPTION_ETXTBSY         = 0x8071031a,
	CELL_HTTP_ERROR_NET_OPTION_EFBIG           = 0x8071031b,
	CELL_HTTP_ERROR_NET_OPTION_ENOSPC          = 0x8071031c,
	CELL_HTTP_ERROR_NET_OPTION_ESPIPE          = 0x8071031d,
	CELL_HTTP_ERROR_NET_OPTION_EROFS           = 0x8071031e,
	CELL_HTTP_ERROR_NET_OPTION_EMLINK          = 0x8071031f,
	CELL_HTTP_ERROR_NET_OPTION_EPIPE           = 0x80710320,
	CELL_HTTP_ERROR_NET_OPTION_EDOM            = 0x80710321,
	CELL_HTTP_ERROR_NET_OPTION_ERANGE          = 0x80710322,
	CELL_HTTP_ERROR_NET_OPTION_EAGAIN          = 0x80710323,
	CELL_HTTP_ERROR_NET_OPTION_EWOULDBLOCK     = 0x80710323,
	CELL_HTTP_ERROR_NET_OPTION_EINPROGRESS     = 0x80710324,
	CELL_HTTP_ERROR_NET_OPTION_EALREADY        = 0x80710325,
	CELL_HTTP_ERROR_NET_OPTION_ENOTSOCK        = 0x80710326,
	CELL_HTTP_ERROR_NET_OPTION_EDESTADDRREQ    = 0x80710327,
	CELL_HTTP_ERROR_NET_OPTION_EMSGSIZE        = 0x80710328,
	CELL_HTTP_ERROR_NET_OPTION_EPROTOTYPE      = 0x80710329,
	CELL_HTTP_ERROR_NET_OPTION_ENOPROTOOPT     = 0x8071032a,
	CELL_HTTP_ERROR_NET_OPTION_EPROTONOSUPPORT = 0x8071032b,
	CELL_HTTP_ERROR_NET_OPTION_ESOCKTNOSUPPORT = 0x8071032c,
	CELL_HTTP_ERROR_NET_OPTION_EOPNOTSUPP      = 0x8071032d,
	CELL_HTTP_ERROR_NET_OPTION_EPFNOSUPPORT    = 0x8071032e,
	CELL_HTTP_ERROR_NET_OPTION_EAFNOSUPPORT    = 0x8071032f,
	CELL_HTTP_ERROR_NET_OPTION_EADDRINUSE      = 0x80710330,
	CELL_HTTP_ERROR_NET_OPTION_EADDRNOTAVAIL   = 0x80710331,
	CELL_HTTP_ERROR_NET_OPTION_ENETDOWN        = 0x80710332,
	CELL_HTTP_ERROR_NET_OPTION_ENETUNREACH     = 0x80710333,
	CELL_HTTP_ERROR_NET_OPTION_ENETRESET       = 0x80710334,
	CELL_HTTP_ERROR_NET_OPTION_ECONNABORTED    = 0x80710335,
	CELL_HTTP_ERROR_NET_OPTION_ECONNRESET      = 0x80710336,
	CELL_HTTP_ERROR_NET_OPTION_ENOBUFS         = 0x80710337,
	CELL_HTTP_ERROR_NET_OPTION_EISCONN         = 0x80710338,
	CELL_HTTP_ERROR_NET_OPTION_ENOTCONN        = 0x80710339,
	CELL_HTTP_ERROR_NET_OPTION_ESHUTDOWN       = 0x8071033a,
	CELL_HTTP_ERROR_NET_OPTION_ETOOMANYREFS    = 0x8071033b,
	CELL_HTTP_ERROR_NET_OPTION_ETIMEDOUT       = 0x8071033c,
	CELL_HTTP_ERROR_NET_OPTION_ECONNREFUSED    = 0x8071033d,
	CELL_HTTP_ERROR_NET_OPTION_ELOOP           = 0x8071033e,
	CELL_HTTP_ERROR_NET_OPTION_ENAMETOOLONG    = 0x8071033f,
	CELL_HTTP_ERROR_NET_OPTION_EHOSTDOWN       = 0x80710340,
	CELL_HTTP_ERROR_NET_OPTION_EHOSTUNREACH    = 0x80710341,
	CELL_HTTP_ERROR_NET_OPTION_ENOTEMPTY       = 0x80710342,
	CELL_HTTP_ERROR_NET_OPTION_EPROCLIM        = 0x80710343,
	CELL_HTTP_ERROR_NET_OPTION_EUSERS          = 0x80710344,
	CELL_HTTP_ERROR_NET_OPTION_EDQUOT          = 0x80710345,
	CELL_HTTP_ERROR_NET_OPTION_ESTALE          = 0x80710346,
	CELL_HTTP_ERROR_NET_OPTION_EREMOTE         = 0x80710347,
	CELL_HTTP_ERROR_NET_OPTION_EBADRPC         = 0x80710348,
	CELL_HTTP_ERROR_NET_OPTION_ERPCMISMATCH    = 0x80710349,
	CELL_HTTP_ERROR_NET_OPTION_EPROGUNAVAIL    = 0x8071034a,
	CELL_HTTP_ERROR_NET_OPTION_EPROGMISMATCH   = 0x8071034b,
	CELL_HTTP_ERROR_NET_OPTION_EPROCUNAVAIL    = 0x8071034c,
	CELL_HTTP_ERROR_NET_OPTION_ENOLCK          = 0x8071034d,
	CELL_HTTP_ERROR_NET_OPTION_ENOSYS          = 0x8071034e,
	CELL_HTTP_ERROR_NET_OPTION_EFTYPE          = 0x8071034f,
	CELL_HTTP_ERROR_NET_OPTION_EAUTH           = 0x80710350,
	CELL_HTTP_ERROR_NET_OPTION_ENEEDAUTH       = 0x80710351,
	CELL_HTTP_ERROR_NET_OPTION_EIDRM           = 0x80710352,
	CELL_HTTP_ERROR_NET_OPTION_ENOMSG          = 0x80710353,
	CELL_HTTP_ERROR_NET_OPTION_EOVERFLOW       = 0x80710354,
	CELL_HTTP_ERROR_NET_OPTION_EILSEQ          = 0x80710355,
	CELL_HTTP_ERROR_NET_OPTION_ENOTSUP         = 0x80710356,
	CELL_HTTP_ERROR_NET_OPTION_ECANCELED       = 0x80710357,
	CELL_HTTP_ERROR_NET_OPTION_EBADMSG         = 0x80710358,
	CELL_HTTP_ERROR_NET_OPTION_ENODATA         = 0x80710359,
	CELL_HTTP_ERROR_NET_OPTION_ENOSR           = 0x8071035a,
	CELL_HTTP_ERROR_NET_OPTION_ENOSTR          = 0x8071035b,
	CELL_HTTP_ERROR_NET_OPTION_ETIME           = 0x8071035c,

	CELL_HTTP_ERROR_NET_SOCKET_EPERM           = 0x80710401,
	CELL_HTTP_ERROR_NET_SOCKET_ENOENT          = 0x80710402,
	CELL_HTTP_ERROR_NET_SOCKET_ESRCH           = 0x80710403,
	CELL_HTTP_ERROR_NET_SOCKET_EINTR           = 0x80710404,
	CELL_HTTP_ERROR_NET_SOCKET_EIO             = 0x80710405,
	CELL_HTTP_ERROR_NET_SOCKET_ENXIO           = 0x80710406,
	CELL_HTTP_ERROR_NET_SOCKET_E2BIG           = 0x80710407,
	CELL_HTTP_ERROR_NET_SOCKET_ENOEXC          = 0x80710408,
	CELL_HTTP_ERROR_NET_SOCKET_EBADF           = 0x80710409,
	CELL_HTTP_ERROR_NET_SOCKET_ECHILD          = 0x8071040a,
	CELL_HTTP_ERROR_NET_SOCKET_EDEADLK         = 0x8071040b,
	CELL_HTTP_ERROR_NET_SOCKET_ENOMEM          = 0x8071040c,
	CELL_HTTP_ERROR_NET_SOCKET_EACCES          = 0x8071040d,
	CELL_HTTP_ERROR_NET_SOCKET_EFAULT          = 0x8071040e,
	CELL_HTTP_ERROR_NET_SOCKET_ENOTBLK         = 0x8071040f,
	CELL_HTTP_ERROR_NET_SOCKET_EBUSY           = 0x80710410,
	CELL_HTTP_ERROR_NET_SOCKET_EEXIST          = 0x80710411,
	CELL_HTTP_ERROR_NET_SOCKET_EXDEV           = 0x80710412,
	CELL_HTTP_ERROR_NET_SOCKET_ENODEV          = 0x80710413,
	CELL_HTTP_ERROR_NET_SOCKET_ENOTDIR         = 0x80710414,
	CELL_HTTP_ERROR_NET_SOCKET_EISDIR          = 0x80710415,
	CELL_HTTP_ERROR_NET_SOCKET_EINVAL          = 0x80710416,
	CELL_HTTP_ERROR_NET_SOCKET_ENFILE          = 0x80710417,
	CELL_HTTP_ERROR_NET_SOCKET_EMFILE          = 0x80710418,
	CELL_HTTP_ERROR_NET_SOCKET_ENOTTY          = 0x80710419,
	CELL_HTTP_ERROR_NET_SOCKET_ETXTBSY         = 0x8071041a,
	CELL_HTTP_ERROR_NET_SOCKET_EFBIG           = 0x8071041b,
	CELL_HTTP_ERROR_NET_SOCKET_ENOSPC          = 0x8071041c,
	CELL_HTTP_ERROR_NET_SOCKET_ESPIPE          = 0x8071041d,
	CELL_HTTP_ERROR_NET_SOCKET_EROFS           = 0x8071041e,
	CELL_HTTP_ERROR_NET_SOCKET_EMLINK          = 0x8071041f,
	CELL_HTTP_ERROR_NET_SOCKET_EPIPE           = 0x80710420,
	CELL_HTTP_ERROR_NET_SOCKET_EDOM            = 0x80710421,
	CELL_HTTP_ERROR_NET_SOCKET_ERANGE          = 0x80710422,
	CELL_HTTP_ERROR_NET_SOCKET_EAGAIN          = 0x80710423,
	CELL_HTTP_ERROR_NET_SOCKET_EWOULDBLOCK     = 0x80710423,
	CELL_HTTP_ERROR_NET_SOCKET_EINPROGRESS     = 0x80710424,
	CELL_HTTP_ERROR_NET_SOCKET_EALREADY        = 0x80710425,
	CELL_HTTP_ERROR_NET_SOCKET_ENOTSOCK        = 0x80710426,
	CELL_HTTP_ERROR_NET_SOCKET_EDESTADDRREQ    = 0x80710427,
	CELL_HTTP_ERROR_NET_SOCKET_EMSGSIZE        = 0x80710428,
	CELL_HTTP_ERROR_NET_SOCKET_EPROTOTYPE      = 0x80710429,
	CELL_HTTP_ERROR_NET_SOCKET_ENOPROTOOPT     = 0x8071042a,
	CELL_HTTP_ERROR_NET_SOCKET_EPROTONOSUPPORT = 0x8071042b,
	CELL_HTTP_ERROR_NET_SOCKET_ESOCKTNOSUPPORT = 0x8071042c,
	CELL_HTTP_ERROR_NET_SOCKET_EOPNOTSUPP      = 0x8071042d,
	CELL_HTTP_ERROR_NET_SOCKET_EPFNOSUPPORT    = 0x8071042e,
	CELL_HTTP_ERROR_NET_SOCKET_EAFNOSUPPORT    = 0x8071042f,
	CELL_HTTP_ERROR_NET_SOCKET_EADDRINUSE      = 0x80710430,
	CELL_HTTP_ERROR_NET_SOCKET_EADDRNOTAVAIL   = 0x80710431,
	CELL_HTTP_ERROR_NET_SOCKET_ENETDOWN        = 0x80710432,
	CELL_HTTP_ERROR_NET_SOCKET_ENETUNREACH     = 0x80710433,
	CELL_HTTP_ERROR_NET_SOCKET_ENETRESET       = 0x80710434,
	CELL_HTTP_ERROR_NET_SOCKET_ECONNABORTED    = 0x80710435,
	CELL_HTTP_ERROR_NET_SOCKET_ECONNRESET      = 0x80710436,
	CELL_HTTP_ERROR_NET_SOCKET_ENOBUFS         = 0x80710437,
	CELL_HTTP_ERROR_NET_SOCKET_EISCONN         = 0x80710438,
	CELL_HTTP_ERROR_NET_SOCKET_ENOTCONN        = 0x80710439,
	CELL_HTTP_ERROR_NET_SOCKET_ESHUTDOWN       = 0x8071043a,
	CELL_HTTP_ERROR_NET_SOCKET_ETOOMANYREFS    = 0x8071043b,
	CELL_HTTP_ERROR_NET_SOCKET_ETIMEDOUT       = 0x8071043c,
	CELL_HTTP_ERROR_NET_SOCKET_ECONNREFUSED    = 0x8071043d,
	CELL_HTTP_ERROR_NET_SOCKET_ELOOP           = 0x8071043e,
	CELL_HTTP_ERROR_NET_SOCKET_ENAMETOOLONG    = 0x8071043f,
	CELL_HTTP_ERROR_NET_SOCKET_EHOSTDOWN       = 0x80710440,
	CELL_HTTP_ERROR_NET_SOCKET_EHOSTUNREACH    = 0x80710441,
	CELL_HTTP_ERROR_NET_SOCKET_ENOTEMPTY       = 0x80710442,
	CELL_HTTP_ERROR_NET_SOCKET_EPROCLIM        = 0x80710443,
	CELL_HTTP_ERROR_NET_SOCKET_EUSERS          = 0x80710444,
	CELL_HTTP_ERROR_NET_SOCKET_EDQUOT          = 0x80710445,
	CELL_HTTP_ERROR_NET_SOCKET_ESTALE          = 0x80710446,
	CELL_HTTP_ERROR_NET_SOCKET_EREMOTE         = 0x80710447,
	CELL_HTTP_ERROR_NET_SOCKET_EBADRPC         = 0x80710448,
	CELL_HTTP_ERROR_NET_SOCKET_ERPCMISMATCH    = 0x80710449,
	CELL_HTTP_ERROR_NET_SOCKET_EPROGUNAVAIL    = 0x8071044a,
	CELL_HTTP_ERROR_NET_SOCKET_EPROGMISMATCH   = 0x8071044b,
	CELL_HTTP_ERROR_NET_SOCKET_EPROCUNAVAIL    = 0x8071044c,
	CELL_HTTP_ERROR_NET_SOCKET_ENOLCK          = 0x8071044d,
	CELL_HTTP_ERROR_NET_SOCKET_ENOSYS          = 0x8071044e,
	CELL_HTTP_ERROR_NET_SOCKET_EFTYPE          = 0x8071044f,
	CELL_HTTP_ERROR_NET_SOCKET_EAUTH           = 0x80710450,
	CELL_HTTP_ERROR_NET_SOCKET_ENEEDAUTH       = 0x80710451,
	CELL_HTTP_ERROR_NET_SOCKET_EIDRM           = 0x80710452,
	CELL_HTTP_ERROR_NET_SOCKET_ENOMSG          = 0x80710453,
	CELL_HTTP_ERROR_NET_SOCKET_EOVERFLOW       = 0x80710454,
	CELL_HTTP_ERROR_NET_SOCKET_EILSEQ          = 0x80710455,
	CELL_HTTP_ERROR_NET_SOCKET_ENOTSUP         = 0x80710456,
	CELL_HTTP_ERROR_NET_SOCKET_ECANCELED       = 0x80710457,
	CELL_HTTP_ERROR_NET_SOCKET_EBADMSG         = 0x80710458,
	CELL_HTTP_ERROR_NET_SOCKET_ENODATA         = 0x80710459,
	CELL_HTTP_ERROR_NET_SOCKET_ENOSR           = 0x8071045a,
	CELL_HTTP_ERROR_NET_SOCKET_ENOSTR          = 0x8071045b,
	CELL_HTTP_ERROR_NET_SOCKET_ETIME           = 0x8071045c,

	CELL_HTTP_ERROR_NET_CONNECT_EPERM           = 0x80710501,
	CELL_HTTP_ERROR_NET_CONNECT_ENOENT          = 0x80710502,
	CELL_HTTP_ERROR_NET_CONNECT_ESRCH           = 0x80710503,
	CELL_HTTP_ERROR_NET_CONNECT_EINTR           = 0x80710504,
	CELL_HTTP_ERROR_NET_CONNECT_EIO             = 0x80710505,
	CELL_HTTP_ERROR_NET_CONNECT_ENXIO           = 0x80710506,
	CELL_HTTP_ERROR_NET_CONNECT_E2BIG           = 0x80710507,
	CELL_HTTP_ERROR_NET_CONNECT_ENOEXC          = 0x80710508,
	CELL_HTTP_ERROR_NET_CONNECT_EBADF           = 0x80710509,
	CELL_HTTP_ERROR_NET_CONNECT_ECHILD          = 0x8071050a,
	CELL_HTTP_ERROR_NET_CONNECT_EDEADLK         = 0x8071050b,
	CELL_HTTP_ERROR_NET_CONNECT_ENOMEM          = 0x8071050c,
	CELL_HTTP_ERROR_NET_CONNECT_EACCES          = 0x8071050d,
	CELL_HTTP_ERROR_NET_CONNECT_EFAULT          = 0x8071050e,
	CELL_HTTP_ERROR_NET_CONNECT_ENOTBLK         = 0x8071050f,
	CELL_HTTP_ERROR_NET_CONNECT_EBUSY           = 0x80710510,
	CELL_HTTP_ERROR_NET_CONNECT_EEXIST          = 0x80710511,
	CELL_HTTP_ERROR_NET_CONNECT_EXDEV           = 0x80710512,
	CELL_HTTP_ERROR_NET_CONNECT_ENODEV          = 0x80710513,
	CELL_HTTP_ERROR_NET_CONNECT_ENOTDIR         = 0x80710514,
	CELL_HTTP_ERROR_NET_CONNECT_EISDIR          = 0x80710515,
	CELL_HTTP_ERROR_NET_CONNECT_EINVAL          = 0x80710516,
	CELL_HTTP_ERROR_NET_CONNECT_ENFILE          = 0x80710517,
	CELL_HTTP_ERROR_NET_CONNECT_EMFILE          = 0x80710518,
	CELL_HTTP_ERROR_NET_CONNECT_ENOTTY          = 0x80710519,
	CELL_HTTP_ERROR_NET_CONNECT_ETXTBSY         = 0x8071051a,
	CELL_HTTP_ERROR_NET_CONNECT_EFBIG           = 0x8071051b,
	CELL_HTTP_ERROR_NET_CONNECT_ENOSPC          = 0x8071051c,
	CELL_HTTP_ERROR_NET_CONNECT_ESPIPE          = 0x8071051d,
	CELL_HTTP_ERROR_NET_CONNECT_EROFS           = 0x8071051e,
	CELL_HTTP_ERROR_NET_CONNECT_EMLINK          = 0x8071051f,
	CELL_HTTP_ERROR_NET_CONNECT_EPIPE           = 0x80710520,
	CELL_HTTP_ERROR_NET_CONNECT_EDOM            = 0x80710521,
	CELL_HTTP_ERROR_NET_CONNECT_ERANGE          = 0x80710522,
	CELL_HTTP_ERROR_NET_CONNECT_EAGAIN          = 0x80710523,
	CELL_HTTP_ERROR_NET_CONNECT_EWOULDBLOCK     = 0x80710523,
	CELL_HTTP_ERROR_NET_CONNECT_EINPROGRESS     = 0x80710524,
	CELL_HTTP_ERROR_NET_CONNECT_EALREADY        = 0x80710525,
	CELL_HTTP_ERROR_NET_CONNECT_ENOTSOCK        = 0x80710526,
	CELL_HTTP_ERROR_NET_CONNECT_EDESTADDRREQ    = 0x80710527,
	CELL_HTTP_ERROR_NET_CONNECT_EMSGSIZE        = 0x80710528,
	CELL_HTTP_ERROR_NET_CONNECT_EPROTOTYPE      = 0x80710529,
	CELL_HTTP_ERROR_NET_CONNECT_ENOPROTOOPT     = 0x8071052a,
	CELL_HTTP_ERROR_NET_CONNECT_EPROTONOSUPPORT = 0x8071052b,
	CELL_HTTP_ERROR_NET_CONNECT_ESOCKTNOSUPPORT = 0x8071052c,
	CELL_HTTP_ERROR_NET_CONNECT_EOPNOTSUPP      = 0x8071052d,
	CELL_HTTP_ERROR_NET_CONNECT_EPFNOSUPPORT    = 0x8071052e,
	CELL_HTTP_ERROR_NET_CONNECT_EAFNOSUPPORT    = 0x8071052f,
	CELL_HTTP_ERROR_NET_CONNECT_EADDRINUSE      = 0x80710530,
	CELL_HTTP_ERROR_NET_CONNECT_EADDRNOTAVAIL   = 0x80710531,
	CELL_HTTP_ERROR_NET_CONNECT_ENETDOWN        = 0x80710532,
	CELL_HTTP_ERROR_NET_CONNECT_ENETUNREACH     = 0x80710533,
	CELL_HTTP_ERROR_NET_CONNECT_ENETRESET       = 0x80710534,
	CELL_HTTP_ERROR_NET_CONNECT_ECONNABORTED    = 0x80710535,
	CELL_HTTP_ERROR_NET_CONNECT_ECONNRESET      = 0x80710536,
	CELL_HTTP_ERROR_NET_CONNECT_ENOBUFS         = 0x80710537,
	CELL_HTTP_ERROR_NET_CONNECT_EISCONN         = 0x80710538,
	CELL_HTTP_ERROR_NET_CONNECT_ENOTCONN        = 0x80710539,
	CELL_HTTP_ERROR_NET_CONNECT_ESHUTDOWN       = 0x8071053a,
	CELL_HTTP_ERROR_NET_CONNECT_ETOOMANYREFS    = 0x8071053b,
	CELL_HTTP_ERROR_NET_CONNECT_ETIMEDOUT       = 0x8071053c,
	CELL_HTTP_ERROR_NET_CONNECT_ECONNREFUSED    = 0x8071053d,
	CELL_HTTP_ERROR_NET_CONNECT_ELOOP           = 0x8071053e,
	CELL_HTTP_ERROR_NET_CONNECT_ENAMETOOLONG    = 0x8071053f,
	CELL_HTTP_ERROR_NET_CONNECT_EHOSTDOWN       = 0x80710540,
	CELL_HTTP_ERROR_NET_CONNECT_EHOSTUNREACH    = 0x80710541,
	CELL_HTTP_ERROR_NET_CONNECT_ENOTEMPTY       = 0x80710542,
	CELL_HTTP_ERROR_NET_CONNECT_EPROCLIM        = 0x80710543,
	CELL_HTTP_ERROR_NET_CONNECT_EUSERS          = 0x80710544,
	CELL_HTTP_ERROR_NET_CONNECT_EDQUOT          = 0x80710545,
	CELL_HTTP_ERROR_NET_CONNECT_ESTALE          = 0x80710546,
	CELL_HTTP_ERROR_NET_CONNECT_EREMOTE         = 0x80710547,
	CELL_HTTP_ERROR_NET_CONNECT_EBADRPC         = 0x80710548,
	CELL_HTTP_ERROR_NET_CONNECT_ERPCMISMATCH    = 0x80710549,
	CELL_HTTP_ERROR_NET_CONNECT_EPROGUNAVAIL    = 0x8071054a,
	CELL_HTTP_ERROR_NET_CONNECT_EPROGMISMATCH   = 0x8071054b,
	CELL_HTTP_ERROR_NET_CONNECT_EPROCUNAVAIL    = 0x8071054c,
	CELL_HTTP_ERROR_NET_CONNECT_ENOLCK          = 0x8071054d,
	CELL_HTTP_ERROR_NET_CONNECT_ENOSYS          = 0x8071054e,
	CELL_HTTP_ERROR_NET_CONNECT_EFTYPE          = 0x8071054f,
	CELL_HTTP_ERROR_NET_CONNECT_EAUTH           = 0x80710550,
	CELL_HTTP_ERROR_NET_CONNECT_ENEEDAUTH       = 0x80710551,
	CELL_HTTP_ERROR_NET_CONNECT_EIDRM           = 0x80710552,
	CELL_HTTP_ERROR_NET_CONNECT_ENOMSG          = 0x80710553,
	CELL_HTTP_ERROR_NET_CONNECT_EOVERFLOW       = 0x80710554,
	CELL_HTTP_ERROR_NET_CONNECT_EILSEQ          = 0x80710555,
	CELL_HTTP_ERROR_NET_CONNECT_ENOTSUP         = 0x80710556,
	CELL_HTTP_ERROR_NET_CONNECT_ECANCELED       = 0x80710557,
	CELL_HTTP_ERROR_NET_CONNECT_EBADMSG         = 0x80710558,
	CELL_HTTP_ERROR_NET_CONNECT_ENODATA         = 0x80710559,
	CELL_HTTP_ERROR_NET_CONNECT_ENOSR           = 0x8071055a,
	CELL_HTTP_ERROR_NET_CONNECT_ENOSTR          = 0x8071055b,
	CELL_HTTP_ERROR_NET_CONNECT_ETIME           = 0x8071055c,

	CELL_HTTP_ERROR_NET_SEND_EPERM           = 0x80710601,
	CELL_HTTP_ERROR_NET_SEND_ENOENT          = 0x80710602,
	CELL_HTTP_ERROR_NET_SEND_ESRCH           = 0x80710603,
	CELL_HTTP_ERROR_NET_SEND_EINTR           = 0x80710604,
	CELL_HTTP_ERROR_NET_SEND_EIO             = 0x80710605,
	CELL_HTTP_ERROR_NET_SEND_ENXIO           = 0x80710606,
	CELL_HTTP_ERROR_NET_SEND_E2BIG           = 0x80710607,
	CELL_HTTP_ERROR_NET_SEND_ENOEXC          = 0x80710608,
	CELL_HTTP_ERROR_NET_SEND_EBADF           = 0x80710609,
	CELL_HTTP_ERROR_NET_SEND_ECHILD          = 0x8071060a,
	CELL_HTTP_ERROR_NET_SEND_EDEADLK         = 0x8071060b,
	CELL_HTTP_ERROR_NET_SEND_ENOMEM          = 0x8071060c,
	CELL_HTTP_ERROR_NET_SEND_EACCES          = 0x8071060d,
	CELL_HTTP_ERROR_NET_SEND_EFAULT          = 0x8071060e,
	CELL_HTTP_ERROR_NET_SEND_ENOTBLK         = 0x8071060f,
	CELL_HTTP_ERROR_NET_SEND_EBUSY           = 0x80710610,
	CELL_HTTP_ERROR_NET_SEND_EEXIST          = 0x80710611,
	CELL_HTTP_ERROR_NET_SEND_EXDEV           = 0x80710612,
	CELL_HTTP_ERROR_NET_SEND_ENODEV          = 0x80710613,
	CELL_HTTP_ERROR_NET_SEND_ENOTDIR         = 0x80710614,
	CELL_HTTP_ERROR_NET_SEND_EISDIR          = 0x80710615,
	CELL_HTTP_ERROR_NET_SEND_EINVAL          = 0x80710616,
	CELL_HTTP_ERROR_NET_SEND_ENFILE          = 0x80710617,
	CELL_HTTP_ERROR_NET_SEND_EMFILE          = 0x80710618,
	CELL_HTTP_ERROR_NET_SEND_ENOTTY          = 0x80710619,
	CELL_HTTP_ERROR_NET_SEND_ETXTBSY         = 0x8071061a,
	CELL_HTTP_ERROR_NET_SEND_EFBIG           = 0x8071061b,
	CELL_HTTP_ERROR_NET_SEND_ENOSPC          = 0x8071061c,
	CELL_HTTP_ERROR_NET_SEND_ESPIPE          = 0x8071061d,
	CELL_HTTP_ERROR_NET_SEND_EROFS           = 0x8071061e,
	CELL_HTTP_ERROR_NET_SEND_EMLINK          = 0x8071061f,
	CELL_HTTP_ERROR_NET_SEND_EPIPE           = 0x80710620,
	CELL_HTTP_ERROR_NET_SEND_EDOM            = 0x80710621,
	CELL_HTTP_ERROR_NET_SEND_ERANGE          = 0x80710622,
	CELL_HTTP_ERROR_NET_SEND_EAGAIN          = 0x80710623,
	CELL_HTTP_ERROR_NET_SEND_EWOULDBLOCK     = 0x80710623,
	CELL_HTTP_ERROR_NET_SEND_EINPROGRESS     = 0x80710624,
	CELL_HTTP_ERROR_NET_SEND_EALREADY        = 0x80710625,
	CELL_HTTP_ERROR_NET_SEND_ENOTSOCK        = 0x80710626,
	CELL_HTTP_ERROR_NET_SEND_EDESTADDRREQ    = 0x80710627,
	CELL_HTTP_ERROR_NET_SEND_EMSGSIZE        = 0x80710628,
	CELL_HTTP_ERROR_NET_SEND_EPROTOTYPE      = 0x80710629,
	CELL_HTTP_ERROR_NET_SEND_ENOPROTOOPT     = 0x8071062a,
	CELL_HTTP_ERROR_NET_SEND_EPROTONOSUPPORT = 0x8071062b,
	CELL_HTTP_ERROR_NET_SEND_ESOCKTNOSUPPORT = 0x8071062c,
	CELL_HTTP_ERROR_NET_SEND_EOPNOTSUPP      = 0x8071062d,
	CELL_HTTP_ERROR_NET_SEND_EPFNOSUPPORT    = 0x8071062e,
	CELL_HTTP_ERROR_NET_SEND_EAFNOSUPPORT    = 0x8071062f,
	CELL_HTTP_ERROR_NET_SEND_EADDRINUSE      = 0x80710630,
	CELL_HTTP_ERROR_NET_SEND_EADDRNOTAVAIL   = 0x80710631,
	CELL_HTTP_ERROR_NET_SEND_ENETDOWN        = 0x80710632,
	CELL_HTTP_ERROR_NET_SEND_ENETUNREACH     = 0x80710633,
	CELL_HTTP_ERROR_NET_SEND_ENETRESET       = 0x80710634,
	CELL_HTTP_ERROR_NET_SEND_ECONNABORTED    = 0x80710635,
	CELL_HTTP_ERROR_NET_SEND_ECONNRESET      = 0x80710636,
	CELL_HTTP_ERROR_NET_SEND_ENOBUFS         = 0x80710637,
	CELL_HTTP_ERROR_NET_SEND_EISCONN         = 0x80710638,
	CELL_HTTP_ERROR_NET_SEND_ENOTCONN        = 0x80710639,
	CELL_HTTP_ERROR_NET_SEND_ESHUTDOWN       = 0x8071063a,
	CELL_HTTP_ERROR_NET_SEND_ETOOMANYREFS    = 0x8071063b,
	CELL_HTTP_ERROR_NET_SEND_ETIMEDOUT       = 0x8071063c,
	CELL_HTTP_ERROR_NET_SEND_ECONNREFUSED    = 0x8071063d,
	CELL_HTTP_ERROR_NET_SEND_ELOOP           = 0x8071063e,
	CELL_HTTP_ERROR_NET_SEND_ENAMETOOLONG    = 0x8071063f,
	CELL_HTTP_ERROR_NET_SEND_EHOSTDOWN       = 0x80710640,
	CELL_HTTP_ERROR_NET_SEND_EHOSTUNREACH    = 0x80710641,
	CELL_HTTP_ERROR_NET_SEND_ENOTEMPTY       = 0x80710642,
	CELL_HTTP_ERROR_NET_SEND_EPROCLIM        = 0x80710643,
	CELL_HTTP_ERROR_NET_SEND_EUSERS          = 0x80710644,
	CELL_HTTP_ERROR_NET_SEND_EDQUOT          = 0x80710645,
	CELL_HTTP_ERROR_NET_SEND_ESTALE          = 0x80710646,
	CELL_HTTP_ERROR_NET_SEND_EREMOTE         = 0x80710647,
	CELL_HTTP_ERROR_NET_SEND_EBADRPC         = 0x80710648,
	CELL_HTTP_ERROR_NET_SEND_ERPCMISMATCH    = 0x80710649,
	CELL_HTTP_ERROR_NET_SEND_EPROGUNAVAIL    = 0x8071064a,
	CELL_HTTP_ERROR_NET_SEND_EPROGMISMATCH   = 0x8071064b,
	CELL_HTTP_ERROR_NET_SEND_EPROCUNAVAIL    = 0x8071064c,
	CELL_HTTP_ERROR_NET_SEND_ENOLCK          = 0x8071064d,
	CELL_HTTP_ERROR_NET_SEND_ENOSYS          = 0x8071064e,
	CELL_HTTP_ERROR_NET_SEND_EFTYPE          = 0x8071064f,
	CELL_HTTP_ERROR_NET_SEND_EAUTH           = 0x80710650,
	CELL_HTTP_ERROR_NET_SEND_ENEEDAUTH       = 0x80710651,
	CELL_HTTP_ERROR_NET_SEND_EIDRM           = 0x80710652,
	CELL_HTTP_ERROR_NET_SEND_ENOMSG          = 0x80710653,
	CELL_HTTP_ERROR_NET_SEND_EOVERFLOW       = 0x80710654,
	CELL_HTTP_ERROR_NET_SEND_EILSEQ          = 0x80710655,
	CELL_HTTP_ERROR_NET_SEND_ENOTSUP         = 0x80710656,
	CELL_HTTP_ERROR_NET_SEND_ECANCELED       = 0x80710657,
	CELL_HTTP_ERROR_NET_SEND_EBADMSG         = 0x80710658,
	CELL_HTTP_ERROR_NET_SEND_ENODATA         = 0x80710659,
	CELL_HTTP_ERROR_NET_SEND_ENOSR           = 0x8071065a,
	CELL_HTTP_ERROR_NET_SEND_ENOSTR          = 0x8071065b,
	CELL_HTTP_ERROR_NET_SEND_ETIME           = 0x8071065c,

	CELL_HTTP_ERROR_NET_RECV_EPERM           = 0x80710701,
	CELL_HTTP_ERROR_NET_RECV_ENOENT          = 0x80710702,
	CELL_HTTP_ERROR_NET_RECV_ESRCH           = 0x80710703,
	CELL_HTTP_ERROR_NET_RECV_EINTR           = 0x80710704,
	CELL_HTTP_ERROR_NET_RECV_EIO             = 0x80710705,
	CELL_HTTP_ERROR_NET_RECV_ENXIO           = 0x80710706,
	CELL_HTTP_ERROR_NET_RECV_E2BIG           = 0x80710707,
	CELL_HTTP_ERROR_NET_RECV_ENOEXC          = 0x80710708,
	CELL_HTTP_ERROR_NET_RECV_EBADF           = 0x80710709,
	CELL_HTTP_ERROR_NET_RECV_ECHILD          = 0x8071070a,
	CELL_HTTP_ERROR_NET_RECV_EDEADLK         = 0x8071070b,
	CELL_HTTP_ERROR_NET_RECV_ENOMEM          = 0x8071070c,
	CELL_HTTP_ERROR_NET_RECV_EACCES          = 0x8071070d,
	CELL_HTTP_ERROR_NET_RECV_EFAULT          = 0x8071070e,
	CELL_HTTP_ERROR_NET_RECV_ENOTBLK         = 0x8071070f,
	CELL_HTTP_ERROR_NET_RECV_EBUSY           = 0x80710710,
	CELL_HTTP_ERROR_NET_RECV_EEXIST          = 0x80710711,
	CELL_HTTP_ERROR_NET_RECV_EXDEV           = 0x80710712,
	CELL_HTTP_ERROR_NET_RECV_ENODEV          = 0x80710713,
	CELL_HTTP_ERROR_NET_RECV_ENOTDIR         = 0x80710714,
	CELL_HTTP_ERROR_NET_RECV_EISDIR          = 0x80710715,
	CELL_HTTP_ERROR_NET_RECV_EINVAL          = 0x80710716,
	CELL_HTTP_ERROR_NET_RECV_ENFILE          = 0x80710717,
	CELL_HTTP_ERROR_NET_RECV_EMFILE          = 0x80710718,
	CELL_HTTP_ERROR_NET_RECV_ENOTTY          = 0x80710719,
	CELL_HTTP_ERROR_NET_RECV_ETXTBSY         = 0x8071071a,
	CELL_HTTP_ERROR_NET_RECV_EFBIG           = 0x8071071b,
	CELL_HTTP_ERROR_NET_RECV_ENOSPC          = 0x8071071c,
	CELL_HTTP_ERROR_NET_RECV_ESPIPE          = 0x8071071d,
	CELL_HTTP_ERROR_NET_RECV_EROFS           = 0x8071071e,
	CELL_HTTP_ERROR_NET_RECV_EMLINK          = 0x8071071f,
	CELL_HTTP_ERROR_NET_RECV_EPIPE           = 0x80710720,
	CELL_HTTP_ERROR_NET_RECV_EDOM            = 0x80710721,
	CELL_HTTP_ERROR_NET_RECV_ERANGE          = 0x80710722,
	CELL_HTTP_ERROR_NET_RECV_EAGAIN          = 0x80710723,
	CELL_HTTP_ERROR_NET_RECV_EWOULDBLOCK     = 0x80710723,
	CELL_HTTP_ERROR_NET_RECV_EINPROGRESS     = 0x80710724,
	CELL_HTTP_ERROR_NET_RECV_EALREADY        = 0x80710725,
	CELL_HTTP_ERROR_NET_RECV_ENOTSOCK        = 0x80710726,
	CELL_HTTP_ERROR_NET_RECV_EDESTADDRREQ    = 0x80710727,
	CELL_HTTP_ERROR_NET_RECV_EMSGSIZE        = 0x80710728,
	CELL_HTTP_ERROR_NET_RECV_EPROTOTYPE      = 0x80710729,
	CELL_HTTP_ERROR_NET_RECV_ENOPROTOOPT     = 0x8071072a,
	CELL_HTTP_ERROR_NET_RECV_EPROTONOSUPPORT = 0x8071072b,
	CELL_HTTP_ERROR_NET_RECV_ESOCKTNOSUPPORT = 0x8071072c,
	CELL_HTTP_ERROR_NET_RECV_EOPNOTSUPP      = 0x8071072d,
	CELL_HTTP_ERROR_NET_RECV_EPFNOSUPPORT    = 0x8071072e,
	CELL_HTTP_ERROR_NET_RECV_EAFNOSUPPORT    = 0x8071072f,
	CELL_HTTP_ERROR_NET_RECV_EADDRINUSE      = 0x80710730,
	CELL_HTTP_ERROR_NET_RECV_EADDRNOTAVAIL   = 0x80710731,
	CELL_HTTP_ERROR_NET_RECV_ENETDOWN        = 0x80710732,
	CELL_HTTP_ERROR_NET_RECV_ENETUNREACH     = 0x80710733,
	CELL_HTTP_ERROR_NET_RECV_ENETRESET       = 0x80710734,
	CELL_HTTP_ERROR_NET_RECV_ECONNABORTED    = 0x80710735,
	CELL_HTTP_ERROR_NET_RECV_ECONNRESET      = 0x80710736,
	CELL_HTTP_ERROR_NET_RECV_ENOBUFS         = 0x80710737,
	CELL_HTTP_ERROR_NET_RECV_EISCONN         = 0x80710738,
	CELL_HTTP_ERROR_NET_RECV_ENOTCONN        = 0x80710739,
	CELL_HTTP_ERROR_NET_RECV_ESHUTDOWN       = 0x8071073a,
	CELL_HTTP_ERROR_NET_RECV_ETOOMANYREFS    = 0x8071073b,
	CELL_HTTP_ERROR_NET_RECV_ETIMEDOUT       = 0x8071073c,
	CELL_HTTP_ERROR_NET_RECV_ECONNREFUSED    = 0x8071073d,
	CELL_HTTP_ERROR_NET_RECV_ELOOP           = 0x8071073e,
	CELL_HTTP_ERROR_NET_RECV_ENAMETOOLONG    = 0x8071073f,
	CELL_HTTP_ERROR_NET_RECV_EHOSTDOWN       = 0x80710740,
	CELL_HTTP_ERROR_NET_RECV_EHOSTUNREACH    = 0x80710741,
	CELL_HTTP_ERROR_NET_RECV_ENOTEMPTY       = 0x80710742,
	CELL_HTTP_ERROR_NET_RECV_EPROCLIM        = 0x80710743,
	CELL_HTTP_ERROR_NET_RECV_EUSERS          = 0x80710744,
	CELL_HTTP_ERROR_NET_RECV_EDQUOT          = 0x80710745,
	CELL_HTTP_ERROR_NET_RECV_ESTALE          = 0x80710746,
	CELL_HTTP_ERROR_NET_RECV_EREMOTE         = 0x80710747,
	CELL_HTTP_ERROR_NET_RECV_EBADRPC         = 0x80710748,
	CELL_HTTP_ERROR_NET_RECV_ERPCMISMATCH    = 0x80710749,
	CELL_HTTP_ERROR_NET_RECV_EPROGUNAVAIL    = 0x8071074a,
	CELL_HTTP_ERROR_NET_RECV_EPROGMISMATCH   = 0x8071074b,
	CELL_HTTP_ERROR_NET_RECV_EPROCUNAVAIL    = 0x8071074c,
	CELL_HTTP_ERROR_NET_RECV_ENOLCK          = 0x8071074d,
	CELL_HTTP_ERROR_NET_RECV_ENOSYS          = 0x8071074e,
	CELL_HTTP_ERROR_NET_RECV_EFTYPE          = 0x8071074f,
	CELL_HTTP_ERROR_NET_RECV_EAUTH           = 0x80710750,
	CELL_HTTP_ERROR_NET_RECV_ENEEDAUTH       = 0x80710751,
	CELL_HTTP_ERROR_NET_RECV_EIDRM           = 0x80710752,
	CELL_HTTP_ERROR_NET_RECV_ENOMSG          = 0x80710753,
	CELL_HTTP_ERROR_NET_RECV_EOVERFLOW       = 0x80710754,
	CELL_HTTP_ERROR_NET_RECV_EILSEQ          = 0x80710755,
	CELL_HTTP_ERROR_NET_RECV_ENOTSUP         = 0x80710756,
	CELL_HTTP_ERROR_NET_RECV_ECANCELED       = 0x80710757,
	CELL_HTTP_ERROR_NET_RECV_EBADMSG         = 0x80710758,
	CELL_HTTP_ERROR_NET_RECV_ENODATA         = 0x80710759,
	CELL_HTTP_ERROR_NET_RECV_ENOSR           = 0x8071075a,
	CELL_HTTP_ERROR_NET_RECV_ENOSTR          = 0x8071075b,
	CELL_HTTP_ERROR_NET_RECV_ETIME           = 0x8071075c,

	CELL_HTTP_ERROR_NET_SELECT_EPERM           = 0x80710801,
	CELL_HTTP_ERROR_NET_SELECT_ENOENT          = 0x80710802,
	CELL_HTTP_ERROR_NET_SELECT_ESRCH           = 0x80710803,
	CELL_HTTP_ERROR_NET_SELECT_EINTR           = 0x80710804,
	CELL_HTTP_ERROR_NET_SELECT_EIO             = 0x80710805,
	CELL_HTTP_ERROR_NET_SELECT_ENXIO           = 0x80710806,
	CELL_HTTP_ERROR_NET_SELECT_E2BIG           = 0x80710807,
	CELL_HTTP_ERROR_NET_SELECT_ENOEXC          = 0x80710808,
	CELL_HTTP_ERROR_NET_SELECT_EBADF           = 0x80710809,
	CELL_HTTP_ERROR_NET_SELECT_ECHILD          = 0x8071080a,
	CELL_HTTP_ERROR_NET_SELECT_EDEADLK         = 0x8071080b,
	CELL_HTTP_ERROR_NET_SELECT_ENOMEM          = 0x8071080c,
	CELL_HTTP_ERROR_NET_SELECT_EACCES          = 0x8071080d,
	CELL_HTTP_ERROR_NET_SELECT_EFAULT          = 0x8071080e,
	CELL_HTTP_ERROR_NET_SELECT_ENOTBLK         = 0x8071080f,
	CELL_HTTP_ERROR_NET_SELECT_EBUSY           = 0x80710810,
	CELL_HTTP_ERROR_NET_SELECT_EEXIST          = 0x80710811,
	CELL_HTTP_ERROR_NET_SELECT_EXDEV           = 0x80710812,
	CELL_HTTP_ERROR_NET_SELECT_ENODEV          = 0x80710813,
	CELL_HTTP_ERROR_NET_SELECT_ENOTDIR         = 0x80710814,
	CELL_HTTP_ERROR_NET_SELECT_EISDIR          = 0x80710815,
	CELL_HTTP_ERROR_NET_SELECT_EINVAL          = 0x80710816,
	CELL_HTTP_ERROR_NET_SELECT_ENFILE          = 0x80710817,
	CELL_HTTP_ERROR_NET_SELECT_EMFILE          = 0x80710818,
	CELL_HTTP_ERROR_NET_SELECT_ENOTTY          = 0x80710819,
	CELL_HTTP_ERROR_NET_SELECT_ETXTBSY         = 0x8071081a,
	CELL_HTTP_ERROR_NET_SELECT_EFBIG           = 0x8071081b,
	CELL_HTTP_ERROR_NET_SELECT_ENOSPC          = 0x8071081c,
	CELL_HTTP_ERROR_NET_SELECT_ESPIPE          = 0x8071081d,
	CELL_HTTP_ERROR_NET_SELECT_EROFS           = 0x8071081e,
	CELL_HTTP_ERROR_NET_SELECT_EMLINK          = 0x8071081f,
	CELL_HTTP_ERROR_NET_SELECT_EPIPE           = 0x80710820,
	CELL_HTTP_ERROR_NET_SELECT_EDOM            = 0x80710821,
	CELL_HTTP_ERROR_NET_SELECT_ERANGE          = 0x80710822,
	CELL_HTTP_ERROR_NET_SELECT_EAGAIN          = 0x80710823,
	CELL_HTTP_ERROR_NET_SELECT_EWOULDBLOCK     = 0x80710823,
	CELL_HTTP_ERROR_NET_SELECT_EINPROGRESS     = 0x80710824,
	CELL_HTTP_ERROR_NET_SELECT_EALREADY        = 0x80710825,
	CELL_HTTP_ERROR_NET_SELECT_ENOTSOCK        = 0x80710826,
	CELL_HTTP_ERROR_NET_SELECT_EDESTADDRREQ    = 0x80710827,
	CELL_HTTP_ERROR_NET_SELECT_EMSGSIZE        = 0x80710828,
	CELL_HTTP_ERROR_NET_SELECT_EPROTOTYPE      = 0x80710829,
	CELL_HTTP_ERROR_NET_SELECT_ENOPROTOOPT     = 0x8071082a,
	CELL_HTTP_ERROR_NET_SELECT_EPROTONOSUPPORT = 0x8071082b,
	CELL_HTTP_ERROR_NET_SELECT_ESOCKTNOSUPPORT = 0x8071082c,
	CELL_HTTP_ERROR_NET_SELECT_EOPNOTSUPP      = 0x8071082d,
	CELL_HTTP_ERROR_NET_SELECT_EPFNOSUPPORT    = 0x8071082e,
	CELL_HTTP_ERROR_NET_SELECT_EAFNOSUPPORT    = 0x8071082f,
	CELL_HTTP_ERROR_NET_SELECT_EADDRINUSE      = 0x80710830,
	CELL_HTTP_ERROR_NET_SELECT_EADDRNOTAVAIL   = 0x80710831,
	CELL_HTTP_ERROR_NET_SELECT_ENETDOWN        = 0x80710832,
	CELL_HTTP_ERROR_NET_SELECT_ENETUNREACH     = 0x80710833,
	CELL_HTTP_ERROR_NET_SELECT_ENETRESET       = 0x80710834,
	CELL_HTTP_ERROR_NET_SELECT_ECONNABORTED    = 0x80710835,
	CELL_HTTP_ERROR_NET_SELECT_ECONNRESET      = 0x80710836,
	CELL_HTTP_ERROR_NET_SELECT_ENOBUFS         = 0x80710837,
	CELL_HTTP_ERROR_NET_SELECT_EISCONN         = 0x80710838,
	CELL_HTTP_ERROR_NET_SELECT_ENOTCONN        = 0x80710839,
	CELL_HTTP_ERROR_NET_SELECT_ESHUTDOWN       = 0x8071083a,
	CELL_HTTP_ERROR_NET_SELECT_ETOOMANYREFS    = 0x8071083b,
	CELL_HTTP_ERROR_NET_SELECT_ETIMEDOUT       = 0x8071083c,
	CELL_HTTP_ERROR_NET_SELECT_ECONNREFUSED    = 0x8071083d,
	CELL_HTTP_ERROR_NET_SELECT_ELOOP           = 0x8071083e,
	CELL_HTTP_ERROR_NET_SELECT_ENAMETOOLONG    = 0x8071083f,
	CELL_HTTP_ERROR_NET_SELECT_EHOSTDOWN       = 0x80710840,
	CELL_HTTP_ERROR_NET_SELECT_EHOSTUNREACH    = 0x80710841,
	CELL_HTTP_ERROR_NET_SELECT_ENOTEMPTY       = 0x80710842,
	CELL_HTTP_ERROR_NET_SELECT_EPROCLIM        = 0x80710843,
	CELL_HTTP_ERROR_NET_SELECT_EUSERS          = 0x80710844,
	CELL_HTTP_ERROR_NET_SELECT_EDQUOT          = 0x80710845,
	CELL_HTTP_ERROR_NET_SELECT_ESTALE          = 0x80710846,
	CELL_HTTP_ERROR_NET_SELECT_EREMOTE         = 0x80710847,
	CELL_HTTP_ERROR_NET_SELECT_EBADRPC         = 0x80710848,
	CELL_HTTP_ERROR_NET_SELECT_ERPCMISMATCH    = 0x80710849,
	CELL_HTTP_ERROR_NET_SELECT_EPROGUNAVAIL    = 0x8071084a,
	CELL_HTTP_ERROR_NET_SELECT_EPROGMISMATCH   = 0x8071084b,
	CELL_HTTP_ERROR_NET_SELECT_EPROCUNAVAIL    = 0x8071084c,
	CELL_HTTP_ERROR_NET_SELECT_ENOLCK          = 0x8071084d,
	CELL_HTTP_ERROR_NET_SELECT_ENOSYS          = 0x8071084e,
	CELL_HTTP_ERROR_NET_SELECT_EFTYPE          = 0x8071084f,
	CELL_HTTP_ERROR_NET_SELECT_EAUTH           = 0x80710850,
	CELL_HTTP_ERROR_NET_SELECT_ENEEDAUTH       = 0x80710851,
	CELL_HTTP_ERROR_NET_SELECT_EIDRM           = 0x80710852,
	CELL_HTTP_ERROR_NET_SELECT_ENOMSG          = 0x80710853,
	CELL_HTTP_ERROR_NET_SELECT_EOVERFLOW       = 0x80710854,
	CELL_HTTP_ERROR_NET_SELECT_EILSEQ          = 0x80710855,
	CELL_HTTP_ERROR_NET_SELECT_ENOTSUP         = 0x80710856,
	CELL_HTTP_ERROR_NET_SELECT_ECANCELED       = 0x80710857,
	CELL_HTTP_ERROR_NET_SELECT_EBADMSG         = 0x80710858,
	CELL_HTTP_ERROR_NET_SELECT_ENODATA         = 0x80710859,
	CELL_HTTP_ERROR_NET_SELECT_ENOSR           = 0x8071085a,
	CELL_HTTP_ERROR_NET_SELECT_ENOSTR          = 0x8071085b,
	CELL_HTTP_ERROR_NET_SELECT_ETIME           = 0x8071085c,

	CELL_HTTP_ERROR_NET_SSL_CONNECT_EPERM           = 0x80710b01,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOENT          = 0x80710b02,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ESRCH           = 0x80710b03,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EINTR           = 0x80710b04,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EIO             = 0x80710b05,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENXIO           = 0x80710b06,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_E2BIG           = 0x80710b07,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOEXC          = 0x80710b08,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EBADF           = 0x80710b09,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ECHILD          = 0x80710b0a,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EDEADLK         = 0x80710b0b,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOMEM          = 0x80710b0c,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EACCES          = 0x80710b0d,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EFAULT          = 0x80710b0e,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTBLK         = 0x80710b0f,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EBUSY           = 0x80710b10,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EEXIST          = 0x80710b11,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EXDEV           = 0x80710b12,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENODEV          = 0x80710b13,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTDIR         = 0x80710b14,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EISDIR          = 0x80710b15,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EINVAL          = 0x80710b16,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENFILE          = 0x80710b17,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EMFILE          = 0x80710b18,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTTY          = 0x80710b19,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ETXTBSY         = 0x80710b1a,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EFBIG           = 0x80710b1b,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSPC          = 0x80710b1c,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ESPIPE          = 0x80710b1d,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EROFS           = 0x80710b1e,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EMLINK          = 0x80710b1f,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EPIPE           = 0x80710b20,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EDOM            = 0x80710b21,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ERANGE          = 0x80710b22,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EAGAIN          = 0x80710b23,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EWOULDBLOCK     = 0x80710b23,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EINPROGRESS     = 0x80710b24,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EALREADY        = 0x80710b25,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTSOCK        = 0x80710b26,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EDESTADDRREQ    = 0x80710b27,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EMSGSIZE        = 0x80710b28,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROTOTYPE      = 0x80710b29,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOPROTOOPT     = 0x80710b2a,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROTONOSUPPORT = 0x80710b2b,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ESOCKTNOSUPPORT = 0x80710b2c,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EOPNOTSUPP      = 0x80710b2d,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EPFNOSUPPORT    = 0x80710b2e,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EAFNOSUPPORT    = 0x80710b2f,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EADDRINUSE      = 0x80710b30,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EADDRNOTAVAIL   = 0x80710b31,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENETDOWN        = 0x80710b32,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENETUNREACH     = 0x80710b33,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENETRESET       = 0x80710b34,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ECONNABORTED    = 0x80710b35,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ECONNRESET      = 0x80710b36,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOBUFS         = 0x80710b37,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EISCONN         = 0x80710b38,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTCONN        = 0x80710b39,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ESHUTDOWN       = 0x80710b3a,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ETOOMANYREFS    = 0x80710b3b,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ETIMEDOUT       = 0x80710b3c,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ECONNREFUSED    = 0x80710b3d,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ELOOP           = 0x80710b3e,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENAMETOOLONG    = 0x80710b3f,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EHOSTDOWN       = 0x80710b40,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EHOSTUNREACH    = 0x80710b41,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTEMPTY       = 0x80710b42,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROCLIM        = 0x80710b43,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EUSERS          = 0x80710b44,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EDQUOT          = 0x80710b45,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ESTALE          = 0x80710b46,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EREMOTE         = 0x80710b47,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EBADRPC         = 0x80710b48,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ERPCMISMATCH    = 0x80710b49,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROGUNAVAIL    = 0x80710b4a,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROGMISMATCH   = 0x80710b4b,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EPROCUNAVAIL    = 0x80710b4c,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOLCK          = 0x80710b4d,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSYS          = 0x80710b4e,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EFTYPE          = 0x80710b4f,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EAUTH           = 0x80710b50,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENEEDAUTH       = 0x80710b51,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EIDRM           = 0x80710b52,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOMSG          = 0x80710b53,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EOVERFLOW       = 0x80710b54,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EILSEQ          = 0x80710b55,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOTSUP         = 0x80710b56,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ECANCELED       = 0x80710b57,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_EBADMSG         = 0x80710b58,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENODATA         = 0x80710b59,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSR           = 0x80710b5a,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ENOSTR          = 0x80710b5b,
	CELL_HTTP_ERROR_NET_SSL_CONNECT_ETIME           = 0x80710b5c,

	CELL_HTTP_ERROR_NET_SSL_SEND_EPERM           = 0x80710c01,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOENT          = 0x80710c02,
	CELL_HTTP_ERROR_NET_SSL_SEND_ESRCH           = 0x80710c03,
	CELL_HTTP_ERROR_NET_SSL_SEND_EINTR           = 0x80710c04,
	CELL_HTTP_ERROR_NET_SSL_SEND_EIO             = 0x80710c05,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENXIO           = 0x80710c06,
	CELL_HTTP_ERROR_NET_SSL_SEND_E2BIG           = 0x80710c07,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOEXC          = 0x80710c08,
	CELL_HTTP_ERROR_NET_SSL_SEND_EBADF           = 0x80710c09,
	CELL_HTTP_ERROR_NET_SSL_SEND_ECHILD          = 0x80710c0a,
	CELL_HTTP_ERROR_NET_SSL_SEND_EDEADLK         = 0x80710c0b,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOMEM          = 0x80710c0c,
	CELL_HTTP_ERROR_NET_SSL_SEND_EACCES          = 0x80710c0d,
	CELL_HTTP_ERROR_NET_SSL_SEND_EFAULT          = 0x80710c0e,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOTBLK         = 0x80710c0f,
	CELL_HTTP_ERROR_NET_SSL_SEND_EBUSY           = 0x80710c10,
	CELL_HTTP_ERROR_NET_SSL_SEND_EEXIST          = 0x80710c11,
	CELL_HTTP_ERROR_NET_SSL_SEND_EXDEV           = 0x80710c12,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENODEV          = 0x80710c13,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOTDIR         = 0x80710c14,
	CELL_HTTP_ERROR_NET_SSL_SEND_EISDIR          = 0x80710c15,
	CELL_HTTP_ERROR_NET_SSL_SEND_EINVAL          = 0x80710c16,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENFILE          = 0x80710c17,
	CELL_HTTP_ERROR_NET_SSL_SEND_EMFILE          = 0x80710c18,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOTTY          = 0x80710c19,
	CELL_HTTP_ERROR_NET_SSL_SEND_ETXTBSY         = 0x80710c1a,
	CELL_HTTP_ERROR_NET_SSL_SEND_EFBIG           = 0x80710c1b,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOSPC          = 0x80710c1c,
	CELL_HTTP_ERROR_NET_SSL_SEND_ESPIPE          = 0x80710c1d,
	CELL_HTTP_ERROR_NET_SSL_SEND_EROFS           = 0x80710c1e,
	CELL_HTTP_ERROR_NET_SSL_SEND_EMLINK          = 0x80710c1f,
	CELL_HTTP_ERROR_NET_SSL_SEND_EPIPE           = 0x80710c20,
	CELL_HTTP_ERROR_NET_SSL_SEND_EDOM            = 0x80710c21,
	CELL_HTTP_ERROR_NET_SSL_SEND_ERANGE          = 0x80710c22,
	CELL_HTTP_ERROR_NET_SSL_SEND_EAGAIN          = 0x80710c23,
	CELL_HTTP_ERROR_NET_SSL_SEND_EWOULDBLOCK     = 0x80710c23,
	CELL_HTTP_ERROR_NET_SSL_SEND_EINPROGRESS     = 0x80710c24,
	CELL_HTTP_ERROR_NET_SSL_SEND_EALREADY        = 0x80710c25,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOTSOCK        = 0x80710c26,
	CELL_HTTP_ERROR_NET_SSL_SEND_EDESTADDRREQ    = 0x80710c27,
	CELL_HTTP_ERROR_NET_SSL_SEND_EMSGSIZE        = 0x80710c28,
	CELL_HTTP_ERROR_NET_SSL_SEND_EPROTOTYPE      = 0x80710c29,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOPROTOOPT     = 0x80710c2a,
	CELL_HTTP_ERROR_NET_SSL_SEND_EPROTONOSUPPORT = 0x80710c2b,
	CELL_HTTP_ERROR_NET_SSL_SEND_ESOCKTNOSUPPORT = 0x80710c2c,
	CELL_HTTP_ERROR_NET_SSL_SEND_EOPNOTSUPP      = 0x80710c2d,
	CELL_HTTP_ERROR_NET_SSL_SEND_EPFNOSUPPORT    = 0x80710c2e,
	CELL_HTTP_ERROR_NET_SSL_SEND_EAFNOSUPPORT    = 0x80710c2f,
	CELL_HTTP_ERROR_NET_SSL_SEND_EADDRINUSE      = 0x80710c30,
	CELL_HTTP_ERROR_NET_SSL_SEND_EADDRNOTAVAIL   = 0x80710c31,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENETDOWN        = 0x80710c32,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENETUNREACH     = 0x80710c33,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENETRESET       = 0x80710c34,
	CELL_HTTP_ERROR_NET_SSL_SEND_ECONNABORTED    = 0x80710c35,
	CELL_HTTP_ERROR_NET_SSL_SEND_ECONNRESET      = 0x80710c36,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOBUFS         = 0x80710c37,
	CELL_HTTP_ERROR_NET_SSL_SEND_EISCONN         = 0x80710c38,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOTCONN        = 0x80710c39,
	CELL_HTTP_ERROR_NET_SSL_SEND_ESHUTDOWN       = 0x80710c3a,
	CELL_HTTP_ERROR_NET_SSL_SEND_ETOOMANYREFS    = 0x80710c3b,
	CELL_HTTP_ERROR_NET_SSL_SEND_ETIMEDOUT       = 0x80710c3c,
	CELL_HTTP_ERROR_NET_SSL_SEND_ECONNREFUSED    = 0x80710c3d,
	CELL_HTTP_ERROR_NET_SSL_SEND_ELOOP           = 0x80710c3e,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENAMETOOLONG    = 0x80710c3f,
	CELL_HTTP_ERROR_NET_SSL_SEND_EHOSTDOWN       = 0x80710c40,
	CELL_HTTP_ERROR_NET_SSL_SEND_EHOSTUNREACH    = 0x80710c41,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOTEMPTY       = 0x80710c42,
	CELL_HTTP_ERROR_NET_SSL_SEND_EPROCLIM        = 0x80710c43,
	CELL_HTTP_ERROR_NET_SSL_SEND_EUSERS          = 0x80710c44,
	CELL_HTTP_ERROR_NET_SSL_SEND_EDQUOT          = 0x80710c45,
	CELL_HTTP_ERROR_NET_SSL_SEND_ESTALE          = 0x80710c46,
	CELL_HTTP_ERROR_NET_SSL_SEND_EREMOTE         = 0x80710c47,
	CELL_HTTP_ERROR_NET_SSL_SEND_EBADRPC         = 0x80710c48,
	CELL_HTTP_ERROR_NET_SSL_SEND_ERPCMISMATCH    = 0x80710c49,
	CELL_HTTP_ERROR_NET_SSL_SEND_EPROGUNAVAIL    = 0x80710c4a,
	CELL_HTTP_ERROR_NET_SSL_SEND_EPROGMISMATCH   = 0x80710c4b,
	CELL_HTTP_ERROR_NET_SSL_SEND_EPROCUNAVAIL    = 0x80710c4c,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOLCK          = 0x80710c4d,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOSYS          = 0x80710c4e,
	CELL_HTTP_ERROR_NET_SSL_SEND_EFTYPE          = 0x80710c4f,
	CELL_HTTP_ERROR_NET_SSL_SEND_EAUTH           = 0x80710c50,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENEEDAUTH       = 0x80710c51,
	CELL_HTTP_ERROR_NET_SSL_SEND_EIDRM           = 0x80710c52,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOMSG          = 0x80710c53,
	CELL_HTTP_ERROR_NET_SSL_SEND_EOVERFLOW       = 0x80710c54,
	CELL_HTTP_ERROR_NET_SSL_SEND_EILSEQ          = 0x80710c55,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOTSUP         = 0x80710c56,
	CELL_HTTP_ERROR_NET_SSL_SEND_ECANCELED       = 0x80710c57,
	CELL_HTTP_ERROR_NET_SSL_SEND_EBADMSG         = 0x80710c58,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENODATA         = 0x80710c59,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOSR           = 0x80710c5a,
	CELL_HTTP_ERROR_NET_SSL_SEND_ENOSTR          = 0x80710c5b,
	CELL_HTTP_ERROR_NET_SSL_SEND_ETIME           = 0x80710c5c,

	CELL_HTTP_ERROR_NET_SSL_RECV_EPERM           = 0x80710d01,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOENT          = 0x80710d02,
	CELL_HTTP_ERROR_NET_SSL_RECV_ESRCH           = 0x80710d03,
	CELL_HTTP_ERROR_NET_SSL_RECV_EINTR           = 0x80710d04,
	CELL_HTTP_ERROR_NET_SSL_RECV_EIO             = 0x80710d05,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENXIO           = 0x80710d06,
	CELL_HTTP_ERROR_NET_SSL_RECV_E2BIG           = 0x80710d07,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOEXC          = 0x80710d08,
	CELL_HTTP_ERROR_NET_SSL_RECV_EBADF           = 0x80710d09,
	CELL_HTTP_ERROR_NET_SSL_RECV_ECHILD          = 0x80710d0a,
	CELL_HTTP_ERROR_NET_SSL_RECV_EDEADLK         = 0x80710d0b,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOMEM          = 0x80710d0c,
	CELL_HTTP_ERROR_NET_SSL_RECV_EACCES          = 0x80710d0d,
	CELL_HTTP_ERROR_NET_SSL_RECV_EFAULT          = 0x80710d0e,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOTBLK         = 0x80710d0f,
	CELL_HTTP_ERROR_NET_SSL_RECV_EBUSY           = 0x80710d10,
	CELL_HTTP_ERROR_NET_SSL_RECV_EEXIST          = 0x80710d11,
	CELL_HTTP_ERROR_NET_SSL_RECV_EXDEV           = 0x80710d12,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENODEV          = 0x80710d13,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOTDIR         = 0x80710d14,
	CELL_HTTP_ERROR_NET_SSL_RECV_EISDIR          = 0x80710d15,
	CELL_HTTP_ERROR_NET_SSL_RECV_EINVAL          = 0x80710d16,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENFILE          = 0x80710d17,
	CELL_HTTP_ERROR_NET_SSL_RECV_EMFILE          = 0x80710d18,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOTTY          = 0x80710d19,
	CELL_HTTP_ERROR_NET_SSL_RECV_ETXTBSY         = 0x80710d1a,
	CELL_HTTP_ERROR_NET_SSL_RECV_EFBIG           = 0x80710d1b,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOSPC          = 0x80710d1c,
	CELL_HTTP_ERROR_NET_SSL_RECV_ESPIPE          = 0x80710d1d,
	CELL_HTTP_ERROR_NET_SSL_RECV_EROFS           = 0x80710d1e,
	CELL_HTTP_ERROR_NET_SSL_RECV_EMLINK          = 0x80710d1f,
	CELL_HTTP_ERROR_NET_SSL_RECV_EPIPE           = 0x80710d20,
	CELL_HTTP_ERROR_NET_SSL_RECV_EDOM            = 0x80710d21,
	CELL_HTTP_ERROR_NET_SSL_RECV_ERANGE          = 0x80710d22,
	CELL_HTTP_ERROR_NET_SSL_RECV_EAGAIN          = 0x80710d23,
	CELL_HTTP_ERROR_NET_SSL_RECV_EWOULDBLOCK     = 0x80710d23,
	CELL_HTTP_ERROR_NET_SSL_RECV_EINPROGRESS     = 0x80710d24,
	CELL_HTTP_ERROR_NET_SSL_RECV_EALREADY        = 0x80710d25,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOTSOCK        = 0x80710d26,
	CELL_HTTP_ERROR_NET_SSL_RECV_EDESTADDRREQ    = 0x80710d27,
	CELL_HTTP_ERROR_NET_SSL_RECV_EMSGSIZE        = 0x80710d28,
	CELL_HTTP_ERROR_NET_SSL_RECV_EPROTOTYPE      = 0x80710d29,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOPROTOOPT     = 0x80710d2a,
	CELL_HTTP_ERROR_NET_SSL_RECV_EPROTONOSUPPORT = 0x80710d2b,
	CELL_HTTP_ERROR_NET_SSL_RECV_ESOCKTNOSUPPORT = 0x80710d2c,
	CELL_HTTP_ERROR_NET_SSL_RECV_EOPNOTSUPP      = 0x80710d2d,
	CELL_HTTP_ERROR_NET_SSL_RECV_EPFNOSUPPORT    = 0x80710d2e,
	CELL_HTTP_ERROR_NET_SSL_RECV_EAFNOSUPPORT    = 0x80710d2f,
	CELL_HTTP_ERROR_NET_SSL_RECV_EADDRINUSE      = 0x80710d30,
	CELL_HTTP_ERROR_NET_SSL_RECV_EADDRNOTAVAIL   = 0x80710d31,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENETDOWN        = 0x80710d32,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENETUNREACH     = 0x80710d33,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENETRESET       = 0x80710d34,
	CELL_HTTP_ERROR_NET_SSL_RECV_ECONNABORTED    = 0x80710d35,
	CELL_HTTP_ERROR_NET_SSL_RECV_ECONNRESET      = 0x80710d36,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOBUFS         = 0x80710d37,
	CELL_HTTP_ERROR_NET_SSL_RECV_EISCONN         = 0x80710d38,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOTCONN        = 0x80710d39,
	CELL_HTTP_ERROR_NET_SSL_RECV_ESHUTDOWN       = 0x80710d3a,
	CELL_HTTP_ERROR_NET_SSL_RECV_ETOOMANYREFS    = 0x80710d3b,
	CELL_HTTP_ERROR_NET_SSL_RECV_ETIMEDOUT       = 0x80710d3c,
	CELL_HTTP_ERROR_NET_SSL_RECV_ECONNREFUSED    = 0x80710d3d,
	CELL_HTTP_ERROR_NET_SSL_RECV_ELOOP           = 0x80710d3e,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENAMETOOLONG    = 0x80710d3f,
	CELL_HTTP_ERROR_NET_SSL_RECV_EHOSTDOWN       = 0x80710d40,
	CELL_HTTP_ERROR_NET_SSL_RECV_EHOSTUNREACH    = 0x80710d41,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOTEMPTY       = 0x80710d42,
	CELL_HTTP_ERROR_NET_SSL_RECV_EPROCLIM        = 0x80710d43,
	CELL_HTTP_ERROR_NET_SSL_RECV_EUSERS          = 0x80710d44,
	CELL_HTTP_ERROR_NET_SSL_RECV_EDQUOT          = 0x80710d45,
	CELL_HTTP_ERROR_NET_SSL_RECV_ESTALE          = 0x80710d46,
	CELL_HTTP_ERROR_NET_SSL_RECV_EREMOTE         = 0x80710d47,
	CELL_HTTP_ERROR_NET_SSL_RECV_EBADRPC         = 0x80710d48,
	CELL_HTTP_ERROR_NET_SSL_RECV_ERPCMISMATCH    = 0x80710d49,
	CELL_HTTP_ERROR_NET_SSL_RECV_EPROGUNAVAIL    = 0x80710d4a,
	CELL_HTTP_ERROR_NET_SSL_RECV_EPROGMISMATCH   = 0x80710d4b,
	CELL_HTTP_ERROR_NET_SSL_RECV_EPROCUNAVAIL    = 0x80710d4c,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOLCK          = 0x80710d4d,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOSYS          = 0x80710d4e,
	CELL_HTTP_ERROR_NET_SSL_RECV_EFTYPE          = 0x80710d4f,
	CELL_HTTP_ERROR_NET_SSL_RECV_EAUTH           = 0x80710d50,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENEEDAUTH       = 0x80710d51,
	CELL_HTTP_ERROR_NET_SSL_RECV_EIDRM           = 0x80710d52,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOMSG          = 0x80710d53,
	CELL_HTTP_ERROR_NET_SSL_RECV_EOVERFLOW       = 0x80710d54,
	CELL_HTTP_ERROR_NET_SSL_RECV_EILSEQ          = 0x80710d55,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOTSUP         = 0x80710d56,
	CELL_HTTP_ERROR_NET_SSL_RECV_ECANCELED       = 0x80710d57,
	CELL_HTTP_ERROR_NET_SSL_RECV_EBADMSG         = 0x80710d58,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENODATA         = 0x80710d59,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOSR           = 0x80710d5a,
	CELL_HTTP_ERROR_NET_SSL_RECV_ENOSTR          = 0x80710d5b,
	CELL_HTTP_ERROR_NET_SSL_RECV_ETIME           = 0x80710d5c,
};

enum
{
	CELL_HTTP_TRANSACTION_STATE_GETTING_CONNECTION     = 1,
	CELL_HTTP_TRANSACTION_STATE_PREPARING_REQUEST      = 2,
	CELL_HTTP_TRANSACTION_STATE_SENDING_REQUEST        = 3,
	CELL_HTTP_TRANSACTION_STATE_SENDING_BODY           = 4,
	CELL_HTTP_TRANSACTION_STATE_WAITING_FOR_REPLY      = 5,
	CELL_HTTP_TRANSACTION_STATE_READING_REPLY          = 6,
	CELL_HTTP_TRANSACTION_STATE_SETTING_REDIRECTION    = 7,
	CELL_HTTP_TRANSACTION_STATE_SETTING_AUTHENTICATION = 8,
};

enum
{
	CELL_HTTP_STATUS_CODE_Continue                        = 100,
	CELL_HTTP_STATUS_CODE_Switching_Protocols             = 101,
	CELL_HTTP_STATUS_CODE_Processing                      = 102,

	// Success codes
	CELL_HTTP_STATUS_CODE_OK                              = 200,
	CELL_HTTP_STATUS_CODE_Created                         = 201,
	CELL_HTTP_STATUS_CODE_Accepted                        = 202,
	CELL_HTTP_STATUS_CODE_NonAuthoritive_Information      = 203,
	CELL_HTTP_STATUS_CODE_No_Content                      = 204,
	CELL_HTTP_STATUS_CODE_Reset_Content                   = 205,
	CELL_HTTP_STATUS_CODE_Partial_Content                 = 206,
	CELL_HTTP_STATUS_CODE_MultiStatus                     = 207,
	/* Redirection 3xx */
	CELL_HTTP_STATUS_CODE_Multiple_Choices                = 300,
	CELL_HTTP_STATUS_CODE_Moved_Permanently               = 301,
	CELL_HTTP_STATUS_CODE_Moved_Temporarily               = 302,
	CELL_HTTP_STATUS_CODE_Found                           = CELL_HTTP_STATUS_CODE_Moved_Temporarily,
	CELL_HTTP_STATUS_CODE_See_Other                       = 303,
	CELL_HTTP_STATUS_CODE_Not_Modified                    = 304,
	CELL_HTTP_STATUS_CODE_Use_Proxy                       = 305,
	//CELL_HTTP_STATUS_CODE_UNUSED                          = 306,
	CELL_HTTP_STATUS_CODE_Temporary_Redirect              = 307,

	// Client errors
	CELL_HTTP_STATUS_CODE_Bad_Request                     = 400,
	CELL_HTTP_STATUS_CODE_Unauthorized                    = 401,
	CELL_HTTP_STATUS_CODE_Payment_Required                = 402,
	CELL_HTTP_STATUS_CODE_Forbidden                       = 403,
	CELL_HTTP_STATUS_CODE_Not_Found                       = 404,
	CELL_HTTP_STATUS_CODE_Method_Not_Allowed              = 405,
	CELL_HTTP_STATUS_CODE_Not_Acceptable                  = 406,
	CELL_HTTP_STATUS_CODE_Proxy_Authentication_Required   = 407,
	CELL_HTTP_STATUS_CODE_Request_Timeout                 = 408,
	CELL_HTTP_STATUS_CODE_Conflict                        = 409,
	CELL_HTTP_STATUS_CODE_Gone                            = 410,
	CELL_HTTP_STATUS_CODE_Length_Required                 = 411,
	CELL_HTTP_STATUS_CODE_Precondition_Failed             = 412,
	CELL_HTTP_STATUS_CODE_Request_Entity_Too_Large        = 413,
	CELL_HTTP_STATUS_CODE_RequestURI_Too_Long             = 414,
	CELL_HTTP_STATUS_CODE_Unsupported_Media_Type          = 415,
	CELL_HTTP_STATUS_CODE_Requested_Range_Not_Satisfiable = 416,
	CELL_HTTP_STATUS_CODE_Expectation_Failed              = 417,
	CELL_HTTP_STATUS_CODE_Unprocessable_Entity            = 422,
	CELL_HTTP_STATUS_CODE_Locked                          = 423,
	CELL_HTTP_STATUS_CODE_Failed_Dependency               = 424,
	CELL_HTTP_STATUS_CODE_Upgrade_Required                = 426,

	// Server error
	CELL_HTTP_STATUS_CODE_Internal_Server_Error           = 500,
	CELL_HTTP_STATUS_CODE_Not_Implemented                 = 501,
	CELL_HTTP_STATUS_CODE_Bad_Gateway                     = 502,
	CELL_HTTP_STATUS_CODE_Service_Unavailable             = 503,
	CELL_HTTP_STATUS_CODE_Gateway_Timeout                 = 504,
	CELL_HTTP_STATUS_CODE_HTTP_Version_Not_Supported      = 505,
	CELL_HTTP_STATUS_CODE_Insufficient_Storage            = 507,
};

enum
{
	CELL_HTTPS_VERIFY_ERROR_NONE           = 0x00000000U,
	CELL_HTTPS_VERIFY_ERROR_NO_CERT        = 0x00000001U,
	CELL_HTTPS_VERIFY_ERROR_BAD_SSL        = 0x00000002U,
	CELL_HTTPS_VERIFY_ERROR_BAD_CLIENT     = 0x00000004U,
	CELL_HTTPS_VERIFY_ERROR_UNKNOWN_CA     = 0x00000008U,
	CELL_HTTPS_VERIFY_ERROR_BAD_CHAIN      = 0x00000010U,
	CELL_HTTPS_VERIFY_ERROR_NO_MEMORY      = 0x00000020U,
	CELL_HTTPS_VERIFY_ERROR_NOT_VERIFIABLE = 0x00000040U,
	CELL_HTTPS_VERIFY_ERROR_INVALID_CERT   = 0x00000080U,
	CELL_HTTPS_VERIFY_ERROR_BAD_CONSTRAINT = 0x00000100U,
	CELL_HTTPS_VERIFY_ERROR_VERIFY_FAILED  = 0x00000200U,
	CELL_HTTPS_VERIFY_ERROR_COMMON_NAME    = 0x00000400U,
	CELL_HTTPS_VERIFY_ERROR_EXPIRED        = 0x00000800U,
	CELL_HTTPS_VERIFY_ERROR_NOT_YET_VALID  = 0x00001000U,
};

static constexpr const char* CELL_HTTP_METHOD_OPTIONS = "OPTIONS";
static constexpr const char* CELL_HTTP_METHOD_GET     = "GET";
static constexpr const char* CELL_HTTP_METHOD_HEAD    = "HEAD";
static constexpr const char* CELL_HTTP_METHOD_POST    = "POST";
static constexpr const char* CELL_HTTP_METHOD_PUT     = "PUT";
static constexpr const char* CELL_HTTP_METHOD_DELETE  = "DELETE";
static constexpr const char* CELL_HTTP_METHOD_TRACE   = "TRACE";

typedef u32 CellHttpClientId; //typedef struct CellHttpClient* CellHttpClientId;
typedef u32 CellHttpTransId; //typedef struct CellHttpTransaction* CellHttpTransId;
typedef const void* CellHttpSslId;

using CellHttpAuthenticationCallback   = s32(CellHttpTransId transId, vm::cptr<char> realm, vm::cptr<CellHttpUri> uri, vm::ptr<char> username, vm::ptr<char> password, vm::ptr<bool> save, vm::ptr<void> userArg);
using CellHttpTransactionStateCallback = s32(CellHttpTransId transId, s32 state, vm::ptr<void> userArg);
using CellHttpRedirectCallback         = s32(CellHttpTransId transId, vm::cptr<CellHttpStatusLine> response, vm::cptr<CellHttpUri> from, vm::cptr<CellHttpUri> to, vm::ptr<void> userArg);
using CellHttpsSslCallback             = s32(u32 verifyErr, vm::cpptr<void> sslCerts, s32 certNum, vm::cptr<char> hostname, vm::cptr<void> id, vm::ptr<void> userArg);
using CellHttpCookieSendCallback       = s32(CellHttpTransId transId, vm::cptr<CellHttpUri> uri, vm::cptr<char> cookieValue, vm::ptr<void> userArg);
using CellHttpCookieRecvCallback       = s32(CellHttpTransId transId, vm::cptr<CellHttpUri> uri, vm::cptr<char> cookieValue, vm::ptr<void> userArg);

struct CellHttpsData
{
	vm::bptr<char> ptr;
	be_t<u32> size;
};

struct http_manager
{
	shared_mutex mtx;
	bool initialized = false;
	bool cookie_initialized = false;
	bool cache_initialized = false;
	bool ext_cache_initialized = false;
	bool https_initialized = false;
};
