"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    CharGrabber: function() {
        return CharGrabber;
    },
    createCharGrabber: function() {
        return createCharGrabber;
    },
    trimChar: function() {
        return trimChar;
    },
    unquote: function() {
        return unquote;
    }
});
var _pluginhelper = require("@bbob/plugin-helper");
var CharGrabber = /*#__PURE__*/ function() {
    "use strict";
    function CharGrabber(source, options) {
        if (options === void 0) options = {};
        this.s = source;
        this.c = {
            pos: 0,
            len: source.length
        };
        this.o = options;
    }
    var _proto = CharGrabber.prototype;
    _proto.skip = function skip(num, silent) {
        if (num === void 0) num = 1;
        this.c.pos += num;
        if (this.o && this.o.onSkip && !silent) {
            this.o.onSkip();
        }
    };
    _proto.hasNext = function hasNext() {
        return this.c.len > this.c.pos;
    };
    _proto.getCurr = function getCurr() {
        if (typeof this.s[this.c.pos] === "undefined") {
            return "";
        }
        return this.s[this.c.pos];
    };
    _proto.getPos = function getPos() {
        return this.c.pos;
    };
    _proto.getLength = function getLength() {
        return this.c.len;
    };
    _proto.getRest = function getRest() {
        return this.s.substring(this.c.pos);
    };
    _proto.getNext = function getNext() {
        var nextPos = this.c.pos + 1;
        return nextPos <= this.s.length - 1 ? this.s[nextPos] : null;
    };
    _proto.getPrev = function getPrev() {
        var prevPos = this.c.pos - 1;
        if (typeof this.s[prevPos] === "undefined") {
            return null;
        }
        return this.s[prevPos];
    };
    _proto.isLast = function isLast() {
        return this.c.pos === this.c.len;
    };
    _proto.includes = function includes(val) {
        return this.s.indexOf(val, this.c.pos) >= 0;
    };
    _proto.grabWhile = function grabWhile(condition, silent) {
        var start = 0;
        if (this.hasNext()) {
            start = this.c.pos;
            while(this.hasNext() && condition(this.getCurr())){
                this.skip(1, silent);
            }
        }
        return this.s.substring(start, this.c.pos);
    };
    _proto.grabN = function grabN(num) {
        if (num === void 0) num = 0;
        return this.s.substring(this.c.pos, this.c.pos + num);
    };
    /**
   * Grabs rest of string until it find a char
   */ _proto.substrUntilChar = function substrUntilChar(char) {
        var pos = this.c.pos;
        var idx = this.s.indexOf(char, pos);
        return idx >= 0 ? this.s.substring(pos, idx) : "";
    };
    return CharGrabber;
}();
var createCharGrabber = function(source, options) {
    return new CharGrabber(source, options);
};
var trimChar = function(str, charToRemove) {
    while(str.charAt(0) === charToRemove){
        // eslint-disable-next-line no-param-reassign
        str = str.substring(1);
    }
    while(str.charAt(str.length - 1) === charToRemove){
        // eslint-disable-next-line no-param-reassign
        str = str.substring(0, str.length - 1);
    }
    return str;
};
var unquote = function(str) {
    return str.replace(_pluginhelper.BACKSLASH + _pluginhelper.QUOTEMARK, _pluginhelper.QUOTEMARK);
};
